/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.nameresolution;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.nameresolution.ACResolve;
import mb.nabl2.terms.ITerm;

public final class CResolve
extends ACResolve
implements Serializable {
    private final ITerm reference;
    private final ITerm declaration;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CResolve(ITerm reference, ITerm declaration, IMessageInfo messageInfo) {
        this.reference = Objects.requireNonNull(reference, "reference");
        this.declaration = Objects.requireNonNull(declaration, "declaration");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CResolve(CResolve original, ITerm reference, ITerm declaration, IMessageInfo messageInfo) {
        this.reference = reference;
        this.declaration = declaration;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getReference() {
        return this.reference;
    }

    @Override
    public ITerm getDeclaration() {
        return this.declaration;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CResolve withReference(ITerm value) {
        if (this.reference == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "reference");
        return new CResolve(this, newValue, this.declaration, this.messageInfo);
    }

    public final CResolve withDeclaration(ITerm value) {
        if (this.declaration == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "declaration");
        return new CResolve(this, this.reference, newValue, this.messageInfo);
    }

    public final CResolve withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CResolve(this, this.reference, this.declaration, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CResolve && this.equalTo((CResolve)another);
    }

    private boolean equalTo(CResolve another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.reference.equals(another.reference) && this.declaration.equals(another.declaration) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.reference.hashCode();
        h += (h << 5) + this.declaration.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CResolve of(ITerm reference, ITerm declaration, IMessageInfo messageInfo) {
        return new CResolve(reference, declaration, messageInfo);
    }

    public static CResolve copyOf(ACResolve instance) {
        if (instance instanceof CResolve) {
            return (CResolve)instance;
        }
        return CResolve.of(instance.getReference(), instance.getDeclaration(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CResolve(this, this.reference, this.declaration, this.messageInfo);
    }
}

