/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.constraints.ast.AstConstraints;
import mb.nabl2.constraints.base.BaseConstraints;
import mb.nabl2.constraints.base.CConj;
import mb.nabl2.constraints.equality.EqualityConstraints;
import mb.nabl2.constraints.nameresolution.NameResolutionConstraints;
import mb.nabl2.constraints.relations.RelationConstraints;
import mb.nabl2.constraints.scopegraph.ScopeGraphConstraints;
import mb.nabl2.constraints.sets.SetConstraints;
import mb.nabl2.constraints.sym.SymbolicConstraints;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.substitution.ISubstitution;
import org.metaborg.util.functions.Function1;

public class Constraints {
    public static TermMatch.IMatcher<IConstraint> matchConstraintOrList() {
        return TermMatch.M.cases(TermMatch.M.listElems(Constraints.matcher(), (l, cs) -> CConj.of((Iterable<IConstraint>)cs)), Constraints.matcher());
    }

    public static TermMatch.IMatcher<IConstraint> matcher() {
        return TermMatch.M.req("Not a constraint", TermMatch.M.cases(AstConstraints.matcher(), BaseConstraints.matcher(), EqualityConstraints.matcher(), ScopeGraphConstraints.matcher(), NameResolutionConstraints.matcher(), RelationConstraints.matcher(), SetConstraints.matcher(), SymbolicConstraints.matcher()));
    }

    public static TermMatch.IMatcher<Integer> priorityMatcher() {
        return TermMatch.M.string(s -> s.getValue().length());
    }

    public static ITerm build(IConstraint constraint) {
        return constraint.match(IConstraint.Cases.of(AstConstraints::build, BaseConstraints::build, EqualityConstraints::build, ScopeGraphConstraints::build, NameResolutionConstraints::build, RelationConstraints::build, SetConstraints::build, SymbolicConstraints::build));
    }

    public static ITerm buildAll(Collection<IConstraint> constraints) {
        List constraintTerms = (List)constraints.stream().map(Constraints::build).collect(ImmutableList.toImmutableList());
        return TermBuild.B.newAppl("Constraints", TermBuild.B.newList(constraintTerms));
    }

    public static ITerm buildPriority(int prio) {
        return TermBuild.B.newString(String.join((CharSequence)"", Collections.nCopies(prio, "!")));
    }

    public static IConstraint substitute(IConstraint constraint, ISubstitution.Immutable subst) {
        return subst.isEmpty() ? constraint : constraint.match(IConstraint.Cases.of(c -> AstConstraints.substitute(c, subst), c -> BaseConstraints.substitute(c, subst), c -> EqualityConstraints.substitute(c, subst), c -> ScopeGraphConstraints.substitute(c, subst), c -> NameResolutionConstraints.substitute(c, subst), c -> RelationConstraints.substitute(c, subst), c -> SetConstraints.substitute(c, subst), c -> SymbolicConstraints.substitute(c, subst)));
    }

    public static IConstraint transform(IConstraint constraint, Function1<ITerm, ITerm> map) {
        return constraint.match(IConstraint.Cases.of(c -> AstConstraints.transform(c, map), c -> BaseConstraints.transform(c, map), c -> EqualityConstraints.transform(c, map), c -> ScopeGraphConstraints.transform(c, map), c -> NameResolutionConstraints.transform(c, map), c -> RelationConstraints.transform(c, map), c -> SetConstraints.transform(c, map), c -> SymbolicConstraints.transform(c, map)));
    }
}

