/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.locals;

import com.oracle.truffle.api.dsl.NodeField;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.FrameUtil;
import com.oracle.truffle.api.frame.VirtualFrame;
import mb.flowspec.runtime.interpreter.Types;
import mb.flowspec.runtime.interpreter.expressions.RefNode;

@NodeField(name="slot", type=FrameSlot.class)
public abstract class ReadVarNode
extends RefNode {
    protected abstract FrameSlot getSlot();

    @Specialization(guards={"isInt(frame)"})
    protected int readInt(VirtualFrame frame) {
        try {
            return frame.getInt(this.getSlot());
        }
        catch (FrameSlotTypeException e) {
            return Types.asInteger(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot()));
        }
    }

    @Specialization(guards={"isBoolean(frame)"})
    protected boolean readBoolean(VirtualFrame frame) {
        try {
            return frame.getBoolean(this.getSlot());
        }
        catch (FrameSlotTypeException e) {
            return Types.asBoolean(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot()));
        }
    }

    @Specialization(replaces={"readInt", "readBoolean"})
    protected Object readObject(VirtualFrame frame) {
        return Types.typeSpecializeTerm(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot()));
    }

    protected boolean isInt(VirtualFrame frame) {
        return this.getSlot().getKind() == FrameSlotKind.Int || this.getSlot().getKind() == FrameSlotKind.Object && Types.isInteger(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot()));
    }

    protected boolean isBoolean(VirtualFrame frame) {
        return this.getSlot().getKind() == FrameSlotKind.Boolean || this.getSlot().getKind() == FrameSlotKind.Object && Types.isBoolean(FrameUtil.getObjectSafe((Frame)frame, (FrameSlot)this.getSlot()));
    }
}

