/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.expressions.SetIntersectNode;
import mb.flowspec.runtime.interpreter.values.ISet;

@GeneratedBy(value=SetIntersectNode.class)
public final class SetIntersectNodeGen
extends SetIntersectNode {
    @Node.Child
    private ExpressionNode left_;
    @Node.Child
    private ExpressionNode right_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private SetIntersectNodeGen(ExpressionNode left, ExpressionNode right) {
        this.left_ = left;
        this.right_ = right;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state = this.state_;
        Object leftValue_ = this.left_.executeGeneric(frameValue);
        Object rightValue_ = this.right_.executeGeneric(frameValue);
        if (state != 0 && leftValue_ instanceof ISet) {
            ISet leftValue__ = (ISet)leftValue_;
            if (rightValue_ instanceof ISet) {
                ISet rightValue__ = (ISet)rightValue_;
                return this.intersect(leftValue__, rightValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftValue_, rightValue_);
    }

    private ISet executeAndSpecialize(Object leftValue, Object rightValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (leftValue instanceof ISet) {
                ISet leftValue_ = (ISet)leftValue;
                if (rightValue instanceof ISet) {
                    ISet rightValue_ = (ISet)rightValue;
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    ISet iSet = this.intersect(leftValue_, rightValue_);
                    return iSet;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.right_}, new Object[]{leftValue, rightValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public static SetIntersectNode create(ExpressionNode left, ExpressionNode right) {
        return new SetIntersectNodeGen(left, right);
    }
}

