/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.ri.swing.Resources;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public final class Net {
    public static String fileToUrlString(File f) {
        String fp = f.getAbsolutePath();
        StringBuffer sb = new StringBuffer(17 + fp.length());
        sb.append("file://localhost");
        if ("\\".equals(File.separator)) {
            sb.append('/');
            sb.append(fp.replace('\\', '/'));
        } else {
            if (!fp.startsWith("/")) {
                sb.append('/');
            }
            sb.append(fp);
        }
        return sb.toString();
    }

    public static URL checkURL(String location, Resources res) {
        URL u = null;
        try {
            u = new URL(location);
        }
        catch (MalformedURLException ex) {
            if (!ex.getMessage().startsWith("no protocol: ")) {
                res.displayError("url.malformed", location);
                return null;
            }
            String newLocation = location.regionMatches(true, 0, "ftp", 0, 3) ? "ftp://" + location : (location.regionMatches(true, 0, "gopher", 0, 6) ? "gopher://" + location : "http://" + location);
            try {
                u = new URL(newLocation);
            }
            catch (MalformedURLException ex2) {
                res.displayError("url.malformed", location);
                return null;
            }
        }
        if (u.getProtocol().equalsIgnoreCase("mailto")) {
            res.displayError("mail.noclient_error");
            return null;
        }
        return u;
    }

    public static String getExtension(URL u) {
        String fileName = Net.getFile(u);
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            return fileName.substring(i + 1);
        }
        return "";
    }

    public static String getDirectory(URL u) {
        String fileName = u.getFile();
        int i = fileName.lastIndexOf(47);
        if (i >= fileName.length() - 1) {
            return fileName;
        }
        return fileName.substring(0, i);
    }

    public static String getFile(URL u) {
        String fileName = u.getFile();
        int i = fileName.lastIndexOf(47);
        if (i >= fileName.length() - 1) {
            return "";
        }
        return fileName.substring(i + 1);
    }
}

