/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.awt;

import java.awt.TextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class DecimalTextField
extends TextField {
    private int maxLength;

    public DecimalTextField(double value, int maxLength, int columns) {
        super(value + "", columns);
        this.maxLength = maxLength;
        this.enableEvents(8L);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (DecimalTextField.this.checkValue()) {
                    return;
                }
                DecimalTextField.this.requestFocus();
            }
        });
    }

    private boolean checkValue() {
        boolean returnValue = true;
        String content = this.getText();
        if (content.length() != 0 && content.length() < this.maxLength) {
            try {
                Double.valueOf(content);
            }
            catch (NumberFormatException e) {
                returnValue = false;
            }
        } else if (content.length() > 0) {
            this.setText(content.substring(0, this.maxLength));
        } else {
            this.setText("0");
        }
        return returnValue;
    }

    public double getValue() {
        return Double.valueOf(this.getText());
    }

    public void setValue(int value) {
        this.setText(value + "");
    }

    protected void processKeyEvent(KeyEvent e) {
        char c = e.getKeyChar();
        if (!Character.isDigit(c) && c != '\b' && c != '\u007f' && c != '\n' && c != '.') {
            this.getToolkit().beep();
            e.consume();
        }
    }
}

