/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.util.Defs;
import ice.util.JavaVersion;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormInputText
extends JTextField
implements EventListener,
ObjectPainter,
DocumentListener,
CaretListener,
Movable {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private Border _originalBorder = this.getBorder();
    int maxLength = 10000;
    private String startValue;
    private boolean drawWidgetBorder = true;

    FormInputText(DocView docView, DElement e) {
        this.docView = docView;
        this.element = (DInputElement)e;
        this.checkAttributes();
        int sz = e.getAttributeAsInt("size");
        if (sz <= 0) {
            sz = 20;
        }
        this.setColumns(sz + 1);
        this.setOpaque(true);
        if (JavaVersion.isV14orGreater()) {
            try {
                Class<?> c = Class.forName("ice.pilots.html4.swing.dnd.jdk14.TextComponentTransferHandler");
                Method m = c.getMethod("installCustomHandler", JTextComponent.class);
                if (m != null) {
                    m.invoke(c, this);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.getDocument().addDocumentListener(this);
        this.addCaretListener(this);
    }

    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
    }

    private void checkAttributes() {
        String s;
        this.setEditable(!this.element.getReadOnly());
        this.setEnabled(!this.element.getDisabled());
        int i = this.element.getMaxLength();
        if (i > 0) {
            this.maxLength = i;
        }
        if ((s = this.element.getValue()) != null && !s.equals(this.getText())) {
            int caretPosition = this.getCaretPosition();
            this.setText(s);
            try {
                this.setCaretPosition(caretPosition);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    public void caretUpdate(CaretEvent e) {
        int selMark;
        int caret = e.getDot();
        if (caret != (selMark = e.getMark())) {
            int end;
            int start;
            if (caret < selMark) {
                start = caret;
                end = selMark;
            } else {
                end = caret;
                start = selMark;
            }
            this.element.dispatchSelection(start, end);
        }
    }

    private void textValueChanged() {
        this.docView.getPilot().getStorm().runOnEventThreadLater(new Runnable(){

            public void run() {
                FormInputText.this.updateFont();
                String s = FormInputText.this.getText();
                if (s.length() > FormInputText.this.maxLength) {
                    int cpos = FormInputText.this.getCaretPosition();
                    if (cpos > FormInputText.this.maxLength) {
                        cpos = FormInputText.this.maxLength;
                    }
                    s = s.substring(0, FormInputText.this.maxLength);
                    FormInputText.this.setText(s);
                    FormInputText.this.setCaretPosition(cpos);
                }
            }
        }, 0L);
        String domString = this.element.getValue();
        String s = this.getText();
        if (!s.equals(domString)) {
            this.element.setValue(s);
        }
    }

    void updateFont() {
        if (this.box != null) {
            String s = this.getText();
            CSSAttribs css = this.box.getCSSAttribs();
            Font f = css.getTestedFont(s);
            if (!f.equals(this.getFont())) {
                this.setFont(f);
            }
        }
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics g) {
    }

    public void paintComponent(Graphics g) {
        if (this.isShowing() || !this.drawWidgetBorder) {
            super.paintComponent(g);
        } else {
            try {
                Dimension size = this.getSize();
                g.translate(1, 1);
                g.setColor(UIManager.getColor("TextField.background"));
                g.fillRect(0, 0, size.width - 2, size.height - 2);
                g.setColor(UIManager.getColor("TextField.shadow"));
                g.drawRect(0, 0, size.width - 2, size.height - 2);
                g.setColor(UIManager.getColor("TextField.foreground"));
                String text = this.element.getValue();
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int height = fontMetrics.getDescent();
                g.drawString(text, 2, size.height / 2 + height);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        KeyEvent ke;
        int kc;
        FormInputText action = null;
        int id = e.getID();
        if (!(id != 401 && id != 402 || (kc = (ke = (KeyEvent)e).getKeyCode()) != 38 && kc != 40 && kc != 39 && kc != 37)) {
            action = this;
        }
        if (this.docView.onComponentEvent(this, e, action)) {
            super.processEvent(e);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        int id = e.getID();
        if (id == 1004) {
            this.processFocusGained(e);
        } else if (id == 1005) {
            this.processFocusLost(e);
        }
        super.processFocusEvent(e);
    }

    private void processFocusGained(FocusEvent e) {
        if (this.startValue == null) {
            this.startValue = this.getText();
        }
    }

    private void processFocusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        String tmp = this.getText();
        if (!tmp.equals(this.startValue)) {
            this.element.dispatchChange();
        }
        this.startValue = null;
    }

    public void handleEvent(Event event) {
        DOMEvent de = (DOMEvent)event;
        super.processEvent((AWTEvent)de.getSystemEvent());
        de.setDefaultDone();
    }

    protected int getColumnWidth() {
        String widthChar = Defs.sysProperty("ice.pilots.html4.colWidthChar", "o");
        if (widthChar == null || widthChar.length() != 1) {
            return super.getColumnWidth();
        }
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        return metrics.charWidth(widthChar.charAt(0));
    }

    public void setBorderVisible(boolean aDrawBorder) {
        if (!aDrawBorder) {
            this.setBorder(null);
            this.drawWidgetBorder = false;
        } else {
            this.setBorder(this._originalBorder);
            this.drawWidgetBorder = true;
        }
    }

    public void setFontHints(CSSAttribs css) {
        this.updateFont();
    }

    public int getClientHeight() {
        Border b = this.getBorder();
        Insets i = b.getBorderInsets(this);
        return this.getHeight() - i.top - i.bottom;
    }

    public int getClientWidth() {
        Border b = this.getBorder();
        Insets i = b.getBorderInsets(this);
        return this.getWidth() - i.left - i.right;
    }
}

