/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSRect;
import java.awt.Graphics;
import java.awt.Point;

class FloatPainter {
    protected CSSBox first;
    protected CSSBox last;

    FloatPainter() {
    }

    void clear() {
        this.last = null;
        this.first = null;
    }

    CSSBox getFirst() {
        return this.first;
    }

    void add(CSSBox b) {
        if (this.first == null) {
            this.first = b;
            while (b.next != null) {
                b = b.next;
            }
            this.last = b;
        } else if (b.css.z_index < this.first.css.z_index) {
            CSSBox prev = this.first;
            this.first = b;
            this.first.next = prev;
        } else {
            CSSBox prev = this.first;
            CSSBox curr = this.first.next;
            while (curr != null) {
                if (b.css.z_index < curr.css.z_index) {
                    prev.next = b;
                    b.next = curr;
                    break;
                }
                prev = curr;
                curr = curr.next;
            }
            if (curr == null) {
                this.last.next = b;
                while (b.next != null) {
                    b = b.next;
                }
                this.last = b;
            }
        }
    }

    protected void do_paint(Graphics g, CSSBox b, boolean fromRelative) {
        if (!fromRelative && b.css.position == 125) {
            return;
        }
        if (this.isVisible(b)) {
            Graphics gg = g.create();
            this.applyClippingFromParents(gg, b);
            gg.clipRect(b.ox, b.oy, b.width, b.height);
            b.cssLayout.outlinePainter.drawBox(gg, b, b.ox, b.oy);
            gg.dispose();
        }
    }

    void paintNegativeZ_Indices(Graphics g) {
        CSSBox b = this.first;
        while (b != null && b.css.z_index < 0) {
            this.do_paint(g, b, false);
            b = b.next;
        }
    }

    void paintPositiveZ_Indices(Graphics g) {
        CSSBox b = this.first;
        while (b != null && b.css.z_index < 0) {
            b = b.next;
        }
        while (b != null) {
            this.do_paint(g, b, false);
            b = b.next;
        }
    }

    protected CSSBox do_getBoxAt(int x, int y, Point rv, CSSBox b) {
        CSSBox result = null;
        if (b.css.clip != null) {
            CSSRect clip = b.css.clip;
            if (x >= b.ox + clip.left && y >= b.oy + clip.top && x < b.ox + clip.right && y < b.oy + clip.bottom) {
                result = b.getBoxAt(x - b.ox, y - b.oy, rv);
            }
        } else if (x >= b.ox && y >= b.oy && x < b.ox + b.width && y < b.oy + b.height) {
            result = b.getBoxAt(x - b.ox, y - b.oy, rv);
        }
        return result;
    }

    CSSBox getBoxAt(int x, int y, Point rv) {
        return this.getBox_r(this.first, x, y, rv);
    }

    private final CSSBox getBox_r(CSSBox b, int x, int y, Point rv) {
        if (b == null) {
            return null;
        }
        CSSBox result = this.getBox_r(b.next, x, y, rv);
        if (result == null) {
            if (!this.isVisible(b)) {
                return null;
            }
            if (this.isClippedByParents(b, x, y)) {
                return null;
            }
            result = this.do_getBoxAt(x, y, rv, b);
        }
        return result;
    }

    protected boolean isVisible(CSSBox b) {
        return true;
    }

    protected void applyClippingFromParents(Graphics g, CSSBox b) {
    }

    protected boolean isClippedByParents(CSSBox b, int x, int y) {
        return false;
    }
}

