/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.ObjectPainter;
import ice.storm.DynEnv;
import ice.util.Defs;
import java.awt.Toolkit;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.events.UIEvent;
import org.w3c.dom.views.AbstractView;

public class DOMUIEvent
extends DOMEvent
implements UIEvent,
MouseEvent {
    public static final short BUTTON_NONE = 0;
    public static final short BUTTON_LEFT = 1;
    public static final short BUTTON_RIGHT = 2;
    public static final short BUTTON_LEFT_RIGHT = 3;
    public static final short BUTTON_MIDDLE = 4;
    public static final short BUTTON_LEFT_MIDDLE = 5;
    public static final short BUTTON_RIGHT_MIDDLE = 6;
    public static final short BUTTON_ALL = 7;
    long keyCode;
    long charCode;
    int modifiers;
    boolean altKey = false;
    boolean shiftKey = false;
    boolean ctrlKey = false;
    boolean metaKey = false;
    int detail;
    int scrollX = 0;
    int scrollY = 0;
    int clientX;
    int clientY;
    int screenX;
    int screenY;
    short mouseButtons = 0;
    boolean isPopupTrigger = false;
    boolean isMousePressPopupTrigger = false;
    ObjectPainter objectPainter = null;
    AbstractView abstractView = null;
    static final int MSIE_DELETE_CODE = 46;
    static final int MSIE_ENTER_CODE = 13;
    static final int MSIE_INSERT_CODE = 45;
    static final int MSIE_MINUS_CODE = 189;
    private static final int Field_altKey = 1;
    private static final int Field_button = 2;
    private static final int Field_charCode = 3;
    private static final int Field_clientX = 4;
    private static final int Field_clientY = 5;
    private static final int Field_ctrlKey = 6;
    private static final int Field_detail = 7;
    private static final int Field_keyCode = 8;
    private static final int Field_metaKey = 9;
    private static final int Field_objectPainter = 10;
    private static final int Field_offsetX = 11;
    private static final int Field_offsetY = 12;
    private static final int Field_posX = 13;
    private static final int Field_posY = 14;
    private static final int Field_relatedNode = 15;
    private static final int Field_relatedTarget = 16;
    private static final int Field_screenX = 17;
    private static final int Field_screenY = 18;
    private static final int Field_scrollX = 19;
    private static final int Field_scrollY = 20;
    private static final int Field_shiftKey = 21;
    private static final int Field_view = 22;
    private static final int Field_x = 23;
    private static final int Field_y = 24;
    private static final int Method_initMouseEvent = -1;
    private static final int Method_initUIEvent = -2;

    DOMUIEvent(DDocument doc, int id) {
        super(doc, id);
    }

    private boolean is_msie_event_emulation() {
        DocPaneXml docPane = (DocPaneXml)this.doc.getPilot().getDocPane();
        return docPane.is_msie_event_emulation();
    }

    protected void copyUIDataFrom(DOMEvent a_source) {
        super.copyUIDataFrom(a_source);
        if (a_source instanceof DOMUIEvent) {
            DOMUIEvent source = (DOMUIEvent)a_source;
            this.keyCode = source.keyCode;
            this.charCode = source.charCode;
            this.altKey = source.altKey;
            this.shiftKey = source.shiftKey;
            this.ctrlKey = source.ctrlKey;
            this.metaKey = source.metaKey;
            this.modifiers = source.modifiers;
            this.detail = source.detail;
            this.scrollX = source.scrollX;
            this.scrollY = source.scrollY;
            this.clientX = source.clientX;
            this.clientY = source.clientY;
            this.screenX = source.screenX;
            this.screenY = source.screenY;
            this.mouseButtons = source.mouseButtons;
            this.objectPainter = source.objectPainter;
            this.abstractView = source.abstractView;
            this.isPopupTrigger = source.isPopupTrigger;
            this.isMousePressPopupTrigger = source.isMousePressPopupTrigger;
        }
    }

    public AbstractView getView() {
        return this.abstractView;
    }

    public int getDetail() {
        return this.detail;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public int getClientX() {
        return this.clientX;
    }

    public int getClientY() {
        return this.clientY;
    }

    public long getCharCode() {
        return this.charCode;
    }

    public long getKeyCode() {
        return this.keyCode;
    }

    public boolean getCtrlKey() {
        return this.ctrlKey;
    }

    public boolean getShiftKey() {
        return this.shiftKey;
    }

    public boolean getAltKey() {
        return this.altKey;
    }

    public boolean getMetaKey() {
        return this.metaKey;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isShortcutKey() {
        if (Defs.booleanProperty("java.awt.headless", false)) {
            return false;
        }
        return this.modifiers == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    public short getButton() {
        switch (this.mouseButtons) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                return 0;
            }
            case 4: 
            case 6: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public short getMouseButtons() {
        return this.mouseButtons;
    }

    public Node getRelatedNode() {
        return this.relatedNode;
    }

    public EventTarget getRelatedTarget() {
        return this.relatedNode;
    }

    public void initUIEvent(String typeArg, boolean canBubbleArg, boolean cancelableArg, AbstractView viewArg, int detailArg) {
        this.initEvent(typeArg, canBubbleArg, cancelableArg);
        this.abstractView = viewArg;
        this.detail = detailArg;
    }

    public void initMouseEvent(String typeArg, boolean canBubbleArg, boolean cancelableArg, AbstractView viewArg, int detailArg, int screenXArg, int screenYArg, int clientXArg, int clientYArg, boolean ctrlKeyArg, boolean altKeyArg, boolean shiftKeyArg, boolean metaKeyArg, short buttonArg, EventTarget relatedTargetArg) {
        this.initUIEvent(typeArg, canBubbleArg, cancelableArg, viewArg, detailArg);
        this.screenX = screenXArg;
        this.screenY = screenYArg;
        this.clientX = clientXArg;
        this.clientY = clientYArg;
        this.ctrlKey = ctrlKeyArg;
        this.altKey = altKeyArg;
        this.shiftKey = shiftKeyArg;
        this.metaKey = metaKeyArg;
        this.setButton(buttonArg);
        this.relatedNode = (DNode)relatedTargetArg;
    }

    public void setClientCoords(int new_x, int new_y, int new_scrollX, int new_scrollY) {
        this.posX = new_x;
        this.posY = new_y;
        this.clientX = new_x;
        this.clientY = new_y;
        this.scrollX = new_scrollX;
        this.scrollY = new_scrollY;
    }

    public void setScreenCoords(int x, int y) {
        this.screenX = x;
        this.screenY = y;
    }

    public void setKeyCode(long kc) {
        this.keyCode = kc;
    }

    public void setCharCode(long cc) {
        this.charCode = cc;
    }

    public void setAltKey(boolean val) {
        this.altKey = val;
    }

    public void setCtrlKey(boolean val) {
        this.ctrlKey = val;
    }

    public void setShiftKey(boolean val) {
        this.shiftKey = val;
    }

    public void setMetaKey(boolean val) {
        this.metaKey = val;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setButton(short value) {
        switch (value) {
            case 0: {
                this.mouseButtons = 1;
                break;
            }
            case 1: {
                this.mouseButtons = (short)4;
                break;
            }
            case 2: {
                this.mouseButtons = (short)2;
                break;
            }
            default: {
                this.mouseButtons = 1;
            }
        }
    }

    public void setMouseButtons(short value) {
        this.mouseButtons = value;
    }

    public boolean isPopupTrigger() {
        return this.isPopupTrigger;
    }

    public boolean isMousePressPopupTrigger() {
        return this.isPopupTrigger;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setPopupTrigger(boolean trigger) {
        this.isPopupTrigger = trigger;
    }

    public void setMousePressPopupTrigger(boolean trigger) {
        this.isMousePressPopupTrigger = trigger;
    }

    public void setPosX(int val) {
        this.posX = val;
    }

    public void setPosY(int val) {
        this.posY = val;
    }

    private void setScrollX(int val) {
        this.scrollX = val;
    }

    private void setScrollY(int val) {
        this.scrollY = val;
    }

    public void setObjectPainter(ObjectPainter op) {
        this.objectPainter = op;
    }

    public ObjectPainter getObjectPainter() {
        return this.objectPainter;
    }

    int getX() {
        return this.clientX;
    }

    int getY() {
        return this.clientY;
    }

    int getOffsetX() {
        return this.posX;
    }

    int getOffsetY() {
        return this.posY;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DOMUIEvent.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DOMUIEvent.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DOMUIEvent.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return env.wrapBoolean(this.getAltKey());
            }
            case 2: {
                short button = this.is_msie_event_emulation() ? this.getMouseButtons() : this.getButton();
                return env.wrapInt(button);
            }
            case 3: {
                return env.wrapLong(this.getCharCode());
            }
            case 4: {
                return env.wrapInt(this.getClientX());
            }
            case 5: {
                return env.wrapInt(this.getClientY());
            }
            case 6: {
                return env.wrapBoolean(this.getCtrlKey());
            }
            case 7: {
                return env.wrapInt(this.getDetail());
            }
            case 8: {
                return env.wrapLong(this.getKeyCode());
            }
            case 9: {
                return env.wrapBoolean(this.getMetaKey());
            }
            case 10: {
                return this.getObjectPainter();
            }
            case 11: {
                return env.wrapInt(this.getOffsetX());
            }
            case 12: {
                return env.wrapInt(this.getOffsetY());
            }
            case 13: {
                return env.wrapInt(this.getPosX());
            }
            case 14: {
                return env.wrapInt(this.getPosY());
            }
            case 15: {
                return this.getRelatedNode();
            }
            case 16: {
                return this.getRelatedTarget();
            }
            case 17: {
                return env.wrapInt(this.getScreenX());
            }
            case 18: {
                return env.wrapInt(this.getScreenY());
            }
            case 19: {
                return env.wrapInt(this.getScrollX());
            }
            case 20: {
                return env.wrapInt(this.getScrollY());
            }
            case 21: {
                return env.wrapBoolean(this.getShiftKey());
            }
            case 22: {
                return this.getView();
            }
            case 23: {
                return env.wrapInt(this.getX());
            }
            case 24: {
                return env.wrapInt(this.getY());
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                return 1;
            }
            case 2: {
                short button = env.toShort(value);
                if (this.is_msie_event_emulation()) {
                    this.setMouseButtons(button);
                } else {
                    this.setButton(button);
                }
                return 1;
            }
            case 3: {
                this.setCharCode(env.toLong(value));
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                this.setKeyCode(env.toLong(value));
                return 1;
            }
            case 9: {
                return 1;
            }
            case 10: {
                this.setObjectPainter((ObjectPainter)env.toNative(value));
                return 1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 1;
            }
            case 13: {
                this.setPosX(env.toInt(value));
                return 1;
            }
            case 14: {
                this.setPosY(env.toInt(value));
                return 1;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 17: {
                return 1;
            }
            case 18: {
                return 1;
            }
            case 19: {
                this.setScrollX(env.toInt(value));
                return 1;
            }
            case 20: {
                this.setScrollY(env.toInt(value));
                return 1;
            }
            case 21: {
                this.setShiftKey(env.toBoolean(value));
                return 1;
            }
            case 22: {
                return 1;
            }
            case 23: {
                return 1;
            }
            case 24: {
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                String eventTypeArg = env.toStr(args, 0);
                boolean canBubbleArg = env.toBoolean(args, 1);
                boolean cancelableArg = env.toBoolean(args, 2);
                AbstractView viewArg = (AbstractView)env.toNative(args, 3);
                int detailArg = env.toInt(args, 4);
                int screenXArg = env.toInt(args, 5);
                int screenYArg = env.toInt(args, 6);
                int clientXArg = env.toInt(args, 7);
                int clientYArg = env.toInt(args, 8);
                boolean ctrlKeyArg = env.toBoolean(args, 9);
                boolean altKeyArg = env.toBoolean(args, 10);
                boolean shiftKeyArg = env.toBoolean(args, 11);
                boolean metaKeyArg = env.toBoolean(args, 12);
                short buttonArg = env.toShort(args, 13);
                EventTarget relatedNodeArg = (EventTarget)env.toNative(args, 14);
                this.initMouseEvent(eventTypeArg, canBubbleArg, cancelableArg, viewArg, detailArg, screenXArg, screenYArg, clientXArg, clientYArg, ctrlKeyArg, altKeyArg, shiftKeyArg, metaKeyArg, buttonArg, relatedNodeArg);
                break;
            }
            case -2: {
                String eventTypeArg = env.toStr(args, 0);
                boolean canBubbleArg = env.toBoolean(args, 1);
                boolean cancelableArg = env.toBoolean(args, 2);
                AbstractView viewArg = (AbstractView)env.toNative(args, 3);
                int detailArg = env.toInt(args, 4);
                this.initUIEvent(eventTypeArg, canBubbleArg, cancelableArg, viewArg, detailArg);
                break;
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        block0 : switch (s.length()) {
            case 1: {
                char c = s.charAt(0);
                if (c == 'x') {
                    return 23;
                }
                if (c != 'y') break;
                return 24;
            }
            case 4: {
                char c = s.charAt(3);
                if (c == 'X') {
                    guess = "posX";
                    id = 13;
                    break;
                }
                if (c == 'Y') {
                    guess = "posY";
                    id = 14;
                    break;
                }
                if (c != 'w') break;
                guess = "view";
                id = 22;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'a') {
                    guess = "altKey";
                    id = 1;
                    break;
                }
                if (c == 'b') {
                    guess = "button";
                    id = 2;
                    break;
                }
                if (c != 'd') break;
                guess = "detail";
                id = 7;
                break;
            }
            case 7: {
                switch (s.charAt(3)) {
                    case 'C': {
                        guess = "keyCode";
                        id = 8;
                        break block0;
                    }
                    case 'a': {
                        guess = "metaKey";
                        id = 9;
                        break block0;
                    }
                    case 'e': {
                        char c = s.charAt(0);
                        if (c == 'c') {
                            c = s.charAt(6);
                            if (c == 'X') {
                                guess = "clientX";
                                id = 4;
                                break block0;
                            }
                            if (c != 'Y') break block0;
                            guess = "clientY";
                            id = 5;
                            break block0;
                        }
                        if (c != 's') break block0;
                        c = s.charAt(6);
                        if (c == 'X') {
                            guess = "screenX";
                            id = 17;
                            break block0;
                        }
                        if (c != 'Y') break block0;
                        guess = "screenY";
                        id = 18;
                        break block0;
                    }
                    case 'l': {
                        guess = "ctrlKey";
                        id = 6;
                        break block0;
                    }
                    case 'o': {
                        char c = s.charAt(6);
                        if (c == 'X') {
                            guess = "scrollX";
                            id = 19;
                            break block0;
                        }
                        if (c != 'Y') break block0;
                        guess = "scrollY";
                        id = 20;
                        break block0;
                    }
                    case 's': {
                        char c = s.charAt(6);
                        if (c == 'X') {
                            guess = "offsetX";
                            id = 11;
                            break block0;
                        }
                        if (c != 'Y') break block0;
                        guess = "offsetY";
                        id = 12;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'c') {
                    guess = "charCode";
                    id = 3;
                    break;
                }
                if (c != 's') break;
                guess = "shiftKey";
                id = 21;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'i') {
                    guess = "initUIEvent";
                    id = -2;
                    break;
                }
                if (c != 'r') break;
                guess = "relatedNode";
                id = 15;
                break;
            }
            case 13: {
                char c = s.charAt(0);
                if (c == 'o') {
                    guess = "objectPainter";
                    id = 10;
                    break;
                }
                if (c != 'r') break;
                guess = "relatedTarget";
                id = 16;
                break;
            }
            case 14: {
                guess = "initMouseEvent";
                id = -1;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

