/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DOMEvent;
import org.w3c.dom.events.EventListener;

class DNodeListeners {
    private static final int SLOT_SIZE = 3;

    DNodeListeners() {
    }

    private static int findListenerOffset(Object[] data, String type, boolean useCapture, EventListener listener) {
        if (data != null) {
            int offset = data.length;
            do {
                Object current;
                if (data[(offset -= 3) + 1] != type || !(useCapture ^ data[offset + 2] == null) || listener != (current = data[offset]) && !listener.equals(current)) continue;
                return offset;
            } while (offset != 0);
        }
        return -1;
    }

    static Object[] addEventListener(Object[] data, String type, boolean useCapture, EventListener listener) {
        if (type != null && (type = DOMEvent.internType(type)) == null) {
            return data;
        }
        if (DNodeListeners.findListenerOffset(data, type, useCapture, listener) < 0) {
            int offset;
            if (data == null) {
                offset = 0;
                data = new Object[3];
            } else {
                offset = data.length;
                Object[] x = new Object[offset + 3];
                System.arraycopy(data, 0, x, 0, offset);
                data = x;
            }
            data[offset] = listener;
            data[offset + 1] = type;
            if (useCapture) {
                data[offset + 2] = Boolean.TRUE;
            }
        }
        return data;
    }

    static Object[] removeEventListener(Object[] data, String type, boolean useCapture, EventListener listener) {
        if (type != null && (type = DOMEvent.internType(type)) == null) {
            return data;
        }
        int offset = DNodeListeners.findListenerOffset(data, type, useCapture, listener);
        if (offset >= 0) {
            int max_offset = data.length;
            if (max_offset == 3) {
                data = null;
            } else {
                Object[] x = new Object[max_offset - 3];
                System.arraycopy(data, 0, x, 0, offset);
                System.arraycopy(data, offset + 3, x, offset, max_offset - 3 - offset);
                data = x;
            }
        }
        return data;
    }

    static void handleEvent(Object[] data, DOMEvent devent, boolean capturePhase) {
        if (data != null) {
            String type = devent.getType();
            int max_offset = data.length;
            for (int i = 0; i != max_offset; i += 3) {
                Object listenerType = data[i + 1];
                if (listenerType != null && listenerType != type || !(capturePhase ^ data[i + 2] == null)) continue;
                EventListener listener = (EventListener)data[i];
                listener.handleEvent(devent);
            }
        }
    }
}

