/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.storm.DynamicList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DAttrMap
extends DynamicList
implements NamedNodeMap {
    protected DElement element;
    private static final int Method_getNamedItem = -1;
    private static final int Method_getNamedItemNS = -2;
    private static final int Method_setNamedItem = -3;
    private static final int Method_setNamedItemNS = -4;
    private static final int Method_removeNamedItem = -5;
    private static final int Method_removeNamedItemNS = -6;

    protected DAttrMap(DElement element) {
        this.element = element;
    }

    public Node getNamedItem(String name) {
        return this.element.getAttributeNode(name);
    }

    public Node setNamedItem(Node n) {
        if (n instanceof DAttr) {
            return this.element.setDAttr((DAttr)n, true);
        }
        return null;
    }

    public Node removeNamedItem(String name) {
        return this.element.removeDAttr(this.element.attrNameToId(name), true);
    }

    public Node item(int index) {
        return this.element.getDAttrFromIndex(index);
    }

    protected Object script_item(int index, DynEnv env) {
        return this.item(index);
    }

    protected Object script_namedItem(String name, DynEnv env) {
        return this.getNamedItem(name);
    }

    public int getLength() {
        return this.element.getDAttrCount();
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        if (!DNode.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + namespaceURI);
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        return this.getNamedItem(localName);
    }

    public Node setNamedItemNS(Node arg) {
        if (!DNode.isNullOrEmpty(arg.getNamespaceURI())) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + arg.getNamespaceURI());
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        return this.setNamedItem(arg);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) {
        if (!DNode.isNullOrEmpty(namespaceURI)) {
            if (Debug.trace) {
                Debug.trace("namespaces are not supported: " + namespaceURI);
            }
            return null;
        }
        if (Debug.trace) {
            Debug.trace("namespaces are not supported but namespace is null");
        }
        return this.removeNamedItem(localName);
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DAttrMap.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DAttrMap.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DAttrMap.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                return this.getNamedItem(env.toStr(args, 0));
            }
            case -2: {
                return this.getNamedItemNS(env.toStr(args, 0), env.toStr(args, 1));
            }
            case -3: {
                return this.setNamedItem((Node)env.toNative(args, 0));
            }
            case -4: {
                return this.setNamedItemNS((Node)env.toNative(args, 0));
            }
            case -5: {
                return this.removeNamedItem(env.toStr(args, 0));
            }
            case -6: {
                return this.removeNamedItemNS(env.toStr(args, 0), env.toStr(args, 1));
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 12: {
                char c = s.charAt(0);
                if (c == 'g') {
                    guess = "getNamedItem";
                    id = -1;
                    break;
                }
                if (c != 's') break;
                guess = "setNamedItem";
                id = -3;
                break;
            }
            case 14: {
                char c = s.charAt(0);
                if (c == 'g') {
                    guess = "getNamedItemNS";
                    id = -2;
                    break;
                }
                if (c != 's') break;
                guess = "setNamedItemNS";
                id = -4;
                break;
            }
            case 15: {
                guess = "removeNamedItem";
                id = -5;
                break;
            }
            case 17: {
                guess = "removeNamedItemNS";
                id = -6;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

