/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.CSSRect;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.ExternalCSSBoxAssist;
import ice.pilots.html4.FloatBox;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.OutlinePainter;
import ice.pilots.html4.TableBox;
import ice.pilots.html4.TableCellBox;
import ice.util.Defs;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

class BlockBox
extends InlineBox {
    protected boolean isPureBlock = false;
    private BlockBox lastAnon = null;
    static final int CHUNK_X_OFFSET = 0;
    static final int SCREEN_X_OFFSET = 1;
    static final int LINE_HEIGHT_OFFSET = 2;
    protected static final int LINE_BLOCK_SIZE = 3;
    protected static final int LINE_ARRAY_SIZE = 10;
    protected static final int _passes = 0;
    protected static final int _expansions = 0;
    protected int[] lines = new int[24];
    protected LineBox[] _lineBoxArray = new LineBox[10];
    protected int sizeLines = 0;
    protected int totalSkipped;
    protected int _lineBoxIndex;
    BlockBox markerBefore;
    private FloatManager curFloatManager;
    private static ExternalCSSBoxAssist runtimeExtension;

    BlockBox(DElement element, CSSAttribs css, CSSLayout cssLayout, byte dynamic) {
        super(element, css, cssLayout, dynamic);
    }

    void dispose() {
        this.markerBefore = null;
        super.dispose();
    }

    void propagateVisibility(short b, boolean self) {
        super.propagateVisibility(b, self);
        if (this.markerBefore != null) {
            this.markerBefore.propagateVisibility(b, self);
        }
    }

    int getType() {
        return 1;
    }

    CSSBox addChild(CSSBox box) {
        if (box.getType() == 1) {
            if (!this.isPureBlock) {
                if (this.first != null) {
                    CSSAttribs a = new CSSAttribs(this.cssLayout.sdata, this.css);
                    a.display = 41;
                    BlockBox anon = new BlockBox(this.element, a, this.cssLayout, 0);
                    anon.first = this.first;
                    anon.last = this.last;
                    CSSBox b = this.first;
                    while (b != null) {
                        b.setParentBox(anon);
                        b = b.next;
                    }
                    this.last = null;
                    this.first = null;
                    super.addChild(anon);
                }
                this.isPureBlock = true;
            }
        } else if (box.getType() != 2) {
            DNode tmp;
            if ((this.isPureBlock && this.lastAnon == null || this.first == null) && (tmp = box.getDomNode()) != null && tmp.getNameId() == 92) {
                DTextNode tmp2 = (DTextNode)tmp;
                if (tmp2.text.length == 1 && tmp2.text[0] == ' ') {
                    return this;
                }
            }
            if (this.isPureBlock) {
                if (this.lastAnon == null) {
                    CSSAttribs a = new CSSAttribs(this.cssLayout.sdata, this.css);
                    a.display = 41;
                    this.lastAnon = new BlockBox(this.element, a, this.cssLayout, 0);
                    super.addChild(this.lastAnon);
                }
                this.lastAnon.addChild(box);
                return this;
            }
        }
        this.lastAnon = null;
        super.addChild(box);
        return this;
    }

    void calcMinMaxWidths() {
        if (this.minWidth > 0) {
            return;
        }
        if (this.markerBefore != null) {
            this.markerBefore.calcMinMaxWidths();
        }
        this.maxWidth = 1;
        this.minWidth = 1;
        int leftX = this.css.border_left_width + this.css.padding_left;
        int rightX = this.css.border_right_width + this.css.padding_right;
        int presetWidth = 0;
        if (this.css.width != -123456 && (this.css.percentage_flag & 0x100000) == 0) {
            presetWidth = this.css.width;
        }
        if (this.isPureBlock) {
            CSSBox bb = this.first;
            while (bb != null) {
                CSSBox b = bb;
                if (b.getType() == 2) {
                    b = ((FloatBox)b).getBlock();
                }
                b.calcMinMaxWidths();
                int t = 0;
                if (b.css.margin_left != -123456 && (b.css.percentage_flag & 0x80) == 0) {
                    t += b.css.margin_left;
                }
                if (b.css.margin_right != -123456 && (b.css.percentage_flag & 0x100) == 0) {
                    t += b.css.margin_right;
                }
                if (b.minWidth + t > this.minWidth) {
                    this.minWidth = b.minWidth + t;
                }
                if (b.maxWidth + t > this.maxWidth) {
                    this.maxWidth = b.maxWidth + t;
                }
                bb = bb.next;
            }
            if (presetWidth > 0) {
                if (this instanceof TableCellBox) {
                    this.maxWidth = presetWidth >= this.minWidth ? presetWidth : this.minWidth;
                } else if (presetWidth >= this.minWidth) {
                    this.minWidth = presetWidth;
                    if (presetWidth > this.maxWidth) {
                        this.maxWidth = presetWidth;
                    }
                } else {
                    this.css.width = this.minWidth;
                }
            }
            if (this.minWidth > this.maxWidth) {
                this.maxWidth = this.minWidth;
            }
            this.minWidth += leftX + rightX;
            this.maxWidth += leftX + rightX;
            if ((this.css.misc & 8) != 0) {
                this.minWidth = this.maxWidth;
            }
            return;
        }
        this.calcBreaks();
        if (this.numBreaks >= this.cssLayout.breaks.length) {
            int N = this.cssLayout.breaks.length * 2;
            if (this.numBreaks >= N) {
                N = this.numBreaks + 1;
            }
            if (N < 10) {
                N = 10;
            }
            this.cssLayout.breaks = new int[N];
        }
        int[] breaks = this.cssLayout.breaks;
        this.getBreaks(breaks, 0);
        if (this.numBreaks > 0) {
            int prevBreak;
            int start = 0;
            for (int i = 0; i < this.numBreaks; ++i) {
                if (breaks[i] >= 0) continue;
                int w = -breaks[i] - start;
                if (w > this.maxWidth) {
                    this.maxWidth = w;
                }
                start = -breaks[i];
            }
            if (this.totalWidth - start > this.maxWidth) {
                this.maxWidth = this.totalWidth - start;
            }
            if ((prevBreak = breaks[0]) < 0) {
                prevBreak = -prevBreak;
            }
            this.minWidth = prevBreak;
            for (int i = 1; i < this.numBreaks; ++i) {
                int t = breaks[i];
                if (t < 0) {
                    t = -t;
                }
                if (t - prevBreak > this.minWidth) {
                    this.minWidth = t - prevBreak;
                }
                prevBreak = t;
            }
            if (this.totalWidth - prevBreak > this.minWidth) {
                this.minWidth = this.totalWidth - prevBreak;
            }
            if (this.maxWidth != this.totalWidth) {
                --this.minWidth;
            }
        } else if (this.totalWidth > this.minWidth) {
            this.minWidth = this.maxWidth = this.totalWidth;
        }
        CSSBox b = this.first;
        while (b != null) {
            if (b.getType() == 2) {
                CSSBox block = ((FloatBox)b).getBlock();
                block.calcMinMaxWidths();
                if (block.minWidth > this.minWidth) {
                    this.minWidth = block.minWidth;
                }
            }
            if (b instanceof InlineBox) {
                InlineBox ib = (InlineBox)b;
                if (ib.first != null) {
                    b = ib.first;
                    continue;
                }
            }
            if (b.next != null) {
                b = b.next;
                continue;
            }
            b = b.parentBox;
            if (b == this) break;
            b = b.next;
        }
        if (presetWidth > 0) {
            if (this instanceof TableCellBox) {
                this.maxWidth = presetWidth >= this.minWidth ? presetWidth : this.minWidth;
            } else if (presetWidth >= this.minWidth) {
                this.minWidth = presetWidth;
                if (presetWidth > this.maxWidth) {
                    this.maxWidth = presetWidth;
                }
            } else if ((this.css.misc & 0x80) == 0) {
                this.css.width = -123456;
            }
        }
        if (this.minWidth > this.maxWidth) {
            this.maxWidth = this.minWidth;
        }
        this.minWidth += leftX + rightX;
        this.maxWidth += leftX + rightX;
        if ((this.css.misc & 8) != 0) {
            this.minWidth = this.maxWidth;
        }
    }

    public void layout(int parentContentWidth, int parentContentHeight, FloatManager m) {
        this.curFloatManager = m;
        int leftX = this.css.border_left_width + this.css.padding_left;
        int rightX = this.css.border_right_width + this.css.padding_right;
        int m1 = 0;
        int m2 = 0;
        if (this.css.position == 6) {
            this.width = parentContentWidth;
        } else if (this.css.width == -123456 || this.css.display == 54) {
            if (this.css.margin_left == -123456 && this.css.margin_right == -123456) {
                this.width = parentContentWidth;
            } else {
                if (this.css.margin_left != -123456) {
                    m1 = this.css.margin_left;
                    if ((this.css.percentage_flag & 0x80) != 0) {
                        m1 = m1 * parentContentWidth / 100;
                    }
                }
                if (this.css.margin_right != -123456) {
                    m2 = this.css.margin_right;
                    if ((this.css.percentage_flag & 0x100) != 0) {
                        m2 = m2 * parentContentWidth / 100;
                    }
                }
                this.width = parentContentWidth - m1 - m2;
            }
            if ((this.css.do_floats & 3) != 0 && this.width > this.maxWidth) {
                m2 += this.width - this.maxWidth;
                this.width = this.maxWidth;
            }
        } else if ((this.css.percentage_flag & 0x100000) != 0) {
            this.width = leftX + rightX + this.css.width * parentContentWidth / 100;
            if (this.css.margin_left == -123456 && this.css.margin_right == -123456) {
                m1 = m2 = (parentContentWidth - this.width) / 2;
            } else {
                if (this.css.margin_left != -123456) {
                    m1 = this.css.margin_left;
                }
                if (this.css.margin_right != -123456) {
                    m2 = this.css.margin_right;
                }
                if (this.width + m1 + m2 < parentContentWidth) {
                    m2 = parentContentWidth - this.width - m1;
                } else if (this.width + m1 + m2 > parentContentWidth) {
                    if (this.width >= parentContentWidth) {
                        m2 = 0;
                        m1 = 0;
                    } else if (this.width + m1 >= parentContentWidth) {
                        m2 = 0;
                        m1 = parentContentWidth - this.width;
                    } else {
                        m2 = parentContentWidth - this.width - m1;
                    }
                }
            }
            if (this.width < this.minWidth) {
                m2 -= this.minWidth - this.width;
                this.width = this.minWidth;
            }
        } else {
            this.width = this.css.width + leftX + rightX;
            if (this.width < this.minWidth) {
                this.width = this.minWidth;
            }
            if (this.css.margin_left == -123456 && this.css.margin_right == -123456) {
                m1 = m2 = (parentContentWidth - this.width) / 2;
            } else {
                if (this.css.margin_left != -123456) {
                    m1 = this.css.margin_left;
                }
                if (this.css.margin_right != -123456) {
                    m2 = this.css.margin_right;
                }
                if (this.width + m1 + m2 < parentContentWidth) {
                    m2 = parentContentWidth - this.width - m1;
                } else if (this.width + m1 + m2 > parentContentWidth) {
                    if (this.width >= parentContentWidth) {
                        if (this.minWidth == this.maxWidth) {
                            m1 = 0;
                            m2 = parentContentWidth - this.width - m1;
                        } else {
                            m2 = 0;
                            m1 = 0;
                        }
                    } else if (this.width + m1 >= parentContentWidth) {
                        m2 = 0;
                        m1 = parentContentWidth - this.width;
                    } else {
                        m2 = parentContentWidth - this.width - m1;
                    }
                }
            }
        }
        this.ox += m1;
        m.translate(m1 + leftX, -m2 - rightX);
        int topY = this.css.border_top_width + this.css.padding_top;
        int bottomY = this.css.border_bottom_width + this.css.padding_bottom;
        int reqHeight = -1;
        if (this.css.height != -123456) {
            if ((this.css.percentage_flag & 8) != 0) {
                if (this instanceof TableCellBox) {
                    CSSBox determiningParent = null;
                    CSSBox pbx = this.parentBox;
                    while (pbx != null) {
                        if (pbx instanceof TableBox) {
                            determiningParent = pbx;
                        }
                        pbx = pbx.parentBox;
                    }
                    if (determiningParent != null && determiningParent.css.height != -123456 && parentContentHeight >= 0) {
                        reqHeight = this.css.height * parentContentHeight / 100;
                    }
                } else if (parentContentHeight > 0) {
                    reqHeight = this.css.height * parentContentHeight / 100;
                }
            } else {
                reqHeight = this.css.height;
            }
        }
        this.sizeLines = 0;
        this._lineBoxIndex = 0;
        if (this.isPureBlock) {
            int contentWidth = this.width - leftX - rightX;
            this.height = topY;
            m.advance(topY);
            int v_margin = 0;
            CSSBox b = this.first;
            while (b != null) {
                if (b.getType() == 2) {
                    CSSBox fb = ((FloatBox)b).getBlock();
                    this.addFloater(fb);
                    if (m.canPosition(fb.width)) {
                        m.advance(0);
                    } else {
                        fb.oy += this.height;
                    }
                } else {
                    if ((b.css.do_floats & 4) != 0) {
                        this.height += m.clearLeft();
                    }
                    if ((b.css.do_floats & 8) != 0) {
                        this.height += m.clearRight();
                    }
                    int aw = contentWidth;
                    if (m.hasActiveFloaters()) {
                        aw = m.getAvailableWidth();
                    }
                    if (aw > contentWidth) {
                        aw = contentWidth;
                    }
                    if (v_margin < b.css.margin_top) {
                        v_margin = b.css.margin_top;
                    }
                    this.height += v_margin;
                    m.advance(v_margin);
                    b.oy = this.height;
                    b.ox = leftX;
                    int ref_height = reqHeight;
                    if (ref_height < 0) {
                        ref_height = parentContentHeight;
                    }
                    ref_height -= this.css.margin_top;
                    b.layout(contentWidth, (ref_height -= this.css.margin_bottom) - topY - bottomY, m);
                    if (b instanceof TableBox && b.width < aw) {
                        if (this.css.text_align == 2 || (b.css.misc & 0x40) != 0) {
                            b.ox += (aw - b.width) / 2;
                        } else if (this.css.text_align == 3) {
                            b.ox += aw - b.width;
                        }
                    }
                    if (b.css.margin_top < 0 && b.css.margin_top != -123456) {
                        b.oy += b.css.margin_top;
                        this.height += b.height + b.css.margin_top;
                        m.advance(b.css.margin_top);
                    } else {
                        this.height += b.height;
                    }
                    v_margin = b.css.margin_bottom >= 0 ? b.css.margin_bottom : 0;
                }
                b = b.next;
            }
            this.height += v_margin;
            m.advance(v_margin);
        } else {
            int ref_height = reqHeight;
            if (ref_height < 0) {
                ref_height = parentContentHeight;
            }
            this.height = ref_height - topY - bottomY;
            this.width -= leftX + rightX;
            this.calcBreaks();
            this.width += leftX + rightX;
            this.height = topY;
            m.advance(topY);
            int n = this.numBreaks;
            int[] breaks = new int[n + 1];
            this.getBreaks(breaks, 0);
            int startPos = 0;
            int breakIdx = 0;
            int lineStartBreakIdx = 0;
            breaks[n] = this.totalWidth;
            this.lastProcessedChild = null;
            this.lastPosition = 0;
            this.totalSkipped = 0;
            while (breakIdx <= n) {
                int temp;
                int br;
                int pos = breaks[breakIdx];
                if (pos < 0) {
                    if ((pos = -pos) - startPos > m.getAvailableWidth() + 1 && (br = breakIdx) > 0) {
                        temp = breaks[br - 1];
                        if (temp < 0) {
                            temp = -temp;
                        }
                        if (startPos != temp) {
                            --breakIdx;
                            pos = temp;
                        }
                    }
                    if (this.recordLineChunk(startPos, pos)) {
                        breakIdx = lineStartBreakIdx;
                        continue;
                    }
                    startPos = pos;
                    lineStartBreakIdx = ++breakIdx;
                    continue;
                }
                if (pos - startPos > m.getAvailableWidth()) {
                    br = breakIdx;
                    if (br > 0) {
                        temp = breaks[br - 1];
                        if (temp < 0) {
                            temp = -temp;
                        }
                        if (startPos != temp) {
                            --br;
                            pos = temp;
                        }
                    }
                    if (br == breakIdx && m.hasActiveFloaters()) {
                        int a = m.skipTill(pos - startPos);
                        this.lines[this.sizeLines + 0] = startPos;
                        this.lines[this.sizeLines + 1] = 0;
                        this.lines[this.sizeLines + 2] = a;
                        this.height += a;
                        this.sizeLines += 3;
                        continue;
                    }
                    if (this.recordLineChunk(startPos, pos)) {
                        breakIdx = lineStartBreakIdx;
                        continue;
                    }
                    startPos = pos;
                    lineStartBreakIdx = breakIdx = br + 1;
                    continue;
                }
                if (breakIdx == n) {
                    if (this.recordLineChunk(startPos, pos)) {
                        breakIdx = lineStartBreakIdx;
                        continue;
                    }
                    ++breakIdx;
                    continue;
                }
                ++breakIdx;
            }
            this.lines[this.sizeLines] = this.totalWidth;
            if (this.sizeLines + 4 < this.lines.length / 2 && this.lines.length > 24) {
                int[] tmp = new int[this.lines.length / 2];
                System.arraycopy(this.lines, 0, tmp, 0, this.sizeLines + 1);
                this.lines = tmp;
            }
        }
        this.height += bottomY;
        m.advance(bottomY);
        if ((this.css.misc & 0x80) != 0) {
            this.width = this.css.width != -123456 && this.css.width < this.width ? this.css.width : this.width;
            this.height = this.css.height != -123456 && this.css.height < this.height ? this.css.height : this.height;
        } else if (!(reqHeight < 0 || reqHeight <= this.height || this.parentBox != null && this.parentBox instanceof TableCellBox && (this.css.percentage_flag & 8) != 0)) {
            m.advance(reqHeight - this.height);
            if (this instanceof TableCellBox) {
                ((TableCellBox)this).tbc_height = this.height;
            }
            this.height = reqHeight;
        }
        m.translate(-m1 - leftX, m2 + rightX);
        this.curFloatManager = null;
        if (this.markerBefore != null) {
            FloatManager fm = new FloatManager(0, this.markerBefore.maxWidth);
            this.markerBefore.layout(this.markerBefore.maxWidth, -1, fm);
            this.markerBefore.ox = this.css.directionFlag == 1 ? this.ox + this.width + 5 : -this.markerBefore.width;
            this.markerBefore.oy = 0;
        }
        if (this.element != null && this.element.tagId == 42) {
            int contentWidth = this.width - leftX - rightX;
            if (this.css.text_align == 3 && this.width < parentContentWidth) {
                this.ox += parentContentWidth - this.width;
            } else if (this.css.text_align == 2 && this.width < parentContentWidth) {
                this.ox += (parentContentWidth - this.width) / 2;
            }
        }
    }

    private final boolean recordLineChunk(int pxStartPos, int pxEndPosition) {
        int lineHeight;
        int chunkWidth = pxEndPosition - pxStartPos;
        LineBox line = new LineBox();
        long dawrap = this.getChunkDescentAscent(pxStartPos, chunkWidth, line);
        if (this.curFloatManager.containsNewFloaters()) {
            this.curFloatManager.advance(0);
            this.lastProcessedChild = null;
            this.lastPosition = 0;
            return true;
        }
        if (this.sizeLines + 4 > this.lines.length) {
            int[] tmp = new int[this.lines.length * 2];
            System.arraycopy(this.lines, 0, tmp, 0, this.lines.length);
            this.lines = tmp;
        }
        if (this._lineBoxIndex == this._lineBoxArray.length) {
            LineBox[] newArray = new LineBox[this._lineBoxArray.length * 2];
            System.arraycopy(this._lineBoxArray, 0, newArray, 0, this._lineBoxArray.length);
            this._lineBoxArray = newArray;
        }
        int ax = this.curFloatManager.getAvailableX();
        int aw = this.curFloatManager.getAvailableWidth();
        this.lines[this.sizeLines] = pxStartPos;
        this.lines[this.sizeLines + 1] = this.css.text_align == 3 && chunkWidth < aw ? ax + aw - chunkWidth : (this.css.text_align == 2 && chunkWidth < aw ? ax + (aw - chunkWidth) / 2 : ax);
        line.doneLine();
        dawrap = line.getLineParameters();
        this.lines[this.sizeLines + 2] = lineHeight = BlockBox.unwrapLineHeight(dawrap);
        this.curFloatManager.advance(lineHeight);
        this.height += lineHeight;
        this._lineBoxArray[this._lineBoxIndex++] = line;
        this.sizeLines += 3;
        return false;
    }

    final void addFloater(CSSBox b) {
        FloatManager fm = this.curFloatManager;
        if (fm == null) {
            return;
        }
        if (fm.contains(b)) {
            return;
        }
        int leftX = this.css.border_left_width + this.css.padding_left;
        int rightX = this.css.border_right_width + this.css.padding_right;
        int contentWidth = this.width - leftX - rightX;
        b.ox = 0;
        b.oy = 0;
        if (b.css.margin_top > 0) {
            b.oy += b.css.margin_top;
        }
        b.calcMinMaxWidths();
        FloatManager m = new FloatManager(0, contentWidth);
        b.layout(contentWidth, -1, m);
        if (!(b instanceof TableBox)) {
            b.height -= b.css.border_bottom_width + b.css.border_bottom_width;
        }
        fm.addFloater(b);
    }

    private final int getFirstLineHeight() {
        if (this.isPureBlock) {
            CSSBox b = this.first;
            if (b == null || !(b instanceof BlockBox)) {
                return 0;
            }
            BlockBox bb = (BlockBox)b;
            return bb.getFirstLineHeight();
        }
        if (this.sizeLines == 0) {
            return 0;
        }
        return this.lines[2];
    }

    int getLineNumber(int y) {
        if (this.isPureBlock) {
            return -1;
        }
        if ((y -= this.css.padding_top + this.css.border_top_width) < 0) {
            return -1;
        }
        int idx = 0;
        int heightOfLine = 0;
        for (idx = 0; idx < this._lineBoxIndex; ++idx) {
            if ((heightOfLine += this.lines[idx * 3 + 2]) < y) continue;
            return idx;
        }
        if (heightOfLine + this.css.padding_bottom > y) {
            return idx;
        }
        return -1;
    }

    CSSBox getRightmostBoxInLine(int lineNumber, Point rightEdge) {
        if (lineNumber < 0 || lineNumber + 10 + 0 > this.lines.length) {
            return null;
        }
        int ypos = this.css.border_top_width + this.css.padding_top;
        int lastLineHeight = 0;
        for (int idx = 0; idx <= lineNumber; ++idx) {
            lastLineHeight = this.lines[idx * 3 + 2];
            ypos += lastLineHeight;
        }
        int xPos = this.lines[(lineNumber + 1) * 3 + 0] - this.lines[lineNumber * 3 + 0] - 1;
        CSSBox box = this.getBoxAt(xPos, ypos -= lastLineHeight / 2, rightEdge);
        rightEdge.x = this.lines[lineNumber * 3 + 0] + xPos;
        return box;
    }

    CSSBox getLeftmostBoxInLine(int lineNumber, Point leftEdge) {
        if (lineNumber < 0 || lineNumber + 3 + 0 > this.lines.length) {
            return null;
        }
        int ypos = this.css.border_top_width + this.css.padding_top;
        int lastLineHeight = 0;
        for (int idx = 0; idx <= lineNumber; ++idx) {
            lastLineHeight = this.lines[idx * 3 + 2];
            ypos += lastLineHeight;
        }
        int xPos = this.css.padding_left + this.ox + this.lines[lineNumber * 3 + 1] + 1;
        CSSBox box = this.getBoxAt(xPos, ypos -= lastLineHeight / 2, leftEdge);
        leftEdge.x = this.lines[lineNumber * 3 + 0];
        return box;
    }

    void findAbsolutePosition(Point p) {
        if (!this.isPureBlock) {
            int y = 0;
            for (int lineIdx = 0; lineIdx < this.sizeLines; lineIdx += 3) {
                int x1 = this.lines[lineIdx + 0];
                int x2 = this.lines[lineIdx + 0 + 3];
                if (p.x >= x1 && p.x < x2) {
                    p.x -= x1;
                    p.x += this.lines[lineIdx + 1];
                    p.y += y;
                    break;
                }
                y += this.lines[lineIdx + 2];
            }
            p.x += this.css.padding_left + this.css.border_left_width;
            p.y += this.css.padding_top + this.css.border_top_width;
        }
        p.x += this.ox;
        p.y += this.oy;
        if (this.css.position != 125 && this.css.position != 126 && this.css.position != 6 && this.parentBox != null) {
            this.parentBox.findAbsolutePosition_int(p);
        }
    }

    void findAbsolutePosition_int(Point p) {
        this.findAbsolutePosition(p);
    }

    void findBoundingBox(Rectangle r) {
        Point p = new Point();
        this.findAbsolutePosition(p);
        r.x = p.x;
        r.y = p.y;
        r.width = this.width;
        r.height = this.height;
    }

    void recordBoundingBoxForInline(Rectangle r, int x, int w) {
        int y = 0;
        int topY = -1;
        for (int lineIdx = 0; lineIdx < this.sizeLines; lineIdx += 3) {
            int spos = this.lines[lineIdx + 0];
            int epos = this.lines[lineIdx + 0 + 3];
            if (topY >= 0) {
                if (epos + 1 >= x + w) {
                    r.x = 0;
                    r.width = this.width;
                    r.y = topY;
                    r.height = y - topY + this.lines[lineIdx + 2];
                    break;
                }
            } else if (x >= spos && x < epos) {
                if (x + w <= epos + 1) {
                    r.x = this.lines[lineIdx + 1] + x - spos;
                    r.width = w;
                    r.y = y;
                    r.height = this.lines[lineIdx + 2];
                    break;
                }
                topY = y;
            }
            y += this.lines[lineIdx + 2];
        }
        if (r.width > 0) {
            r.x += this.ox + this.css.border_left_width + this.css.padding_left;
            r.y += this.oy + this.css.border_top_width + this.css.padding_top;
        }
    }

    CSSBox getBoxAt(int xPos, int yPos, Point rv) {
        if (this.isPureBlock) {
            CSSBox bb = this.first;
            while (bb != null) {
                if (bb.css.position != 125 && bb.oy + bb.height > yPos) {
                    if (bb.oy > yPos) break;
                    CSSBox box = bb.getBoxAt(xPos - bb.ox, yPos - bb.oy, rv);
                    if (box != null) {
                        return box;
                    }
                    if (bb.css.clip != null ? xPos >= bb.ox + bb.css.clip.left && xPos < bb.ox + bb.css.clip.right && yPos >= bb.oy + bb.css.clip.top && yPos < bb.oy + bb.css.clip.bottom : xPos >= bb.ox && xPos < bb.ox + bb.width && yPos >= bb.oy && yPos < bb.oy + bb.height) break;
                }
                bb = bb.next;
            }
        } else {
            int sx = this.css.border_left_width + this.css.padding_left;
            int sy = this.css.border_top_width + this.css.padding_top;
            int lineIdx = 0;
            for (lineIdx = 0; lineIdx < this.sizeLines; lineIdx += 3) {
                sx = this.css.border_left_width + this.css.padding_left + this.lines[lineIdx + 1];
                int spos = this.lines[lineIdx + 0];
                int w = this.lines[lineIdx + 0 + 3] - spos;
                int height = this.lines[lineIdx + 2];
                if (xPos >= sx && xPos < sx + w && yPos >= sy && yPos < sy + height) {
                    return super.getBoxAt(xPos - sx + spos, yPos - sy, rv);
                }
                sy += height;
            }
        }
        rv.x = xPos;
        rv.y = yPos;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics og) {
        if (!this.checkIfVisible()) {
            return;
        }
        Graphics g = og;
        try {
            CSSRect clip = this.css.clip;
            if (clip != null) {
                g = og.create(0, 0, this.width, this.height);
                g.clipRect(clip.left, clip.top, clip.right - clip.left, clip.bottom - clip.top);
            } else if ((this.css.misc & 0x80) != 0) {
                g = og.create(0, 0, this.width, this.height);
            }
            Rectangle clipRect = g.getClipBounds();
            if ((this.css.misc & 1) != 0) {
                if (this.cssLayout.topBox != this) {
                    super.paintBackground(g, clipRect, 0, 0, this.width, this.height, 0);
                }
                this.paintBorders(g, clipRect, 0, 0, this.width, this.height, this.css.border_top_width > 0 && this.css.border_top_style != 8, this.css.border_bottom_width > 0 && this.css.border_bottom_style != 8, this.css.border_left_width > 0 && this.css.border_left_style != 8, this.css.border_right_width > 0 && this.css.border_right_style != 8);
            }
            OutlinePainter outlinePainter = this.cssLayout.outlinePainter;
            if (this.isPureBlock) {
                CSSBox bb = this.first;
                while (bb != null) {
                    if (bb.css.position != 125 && bb.oy + bb.height >= clipRect.y) {
                        if (bb.oy > clipRect.y + clipRect.height) break;
                        outlinePainter.drawBox(g, bb, bb.ox, bb.oy);
                    }
                    bb = bb.next;
                }
            } else {
                int sx = this.css.border_left_width + this.css.padding_left;
                int sy = this.css.border_top_width + this.css.padding_top;
                if (this.parentBox instanceof FloatBox) {
                    sy = this.css.padding_top;
                }
                int lineIdx = 0;
                int lineBoxIdx = 0;
                while (lineIdx < this.sizeLines) {
                    int x = this.lines[lineIdx + 0];
                    int lineHeight = this.lines[lineIdx + 2];
                    if (sy + lineHeight < clipRect.y) {
                        sy += lineHeight;
                    } else {
                        if (sy > clipRect.y + clipRect.height) break;
                        if (this.lines[lineIdx + 0 + 3] == x) {
                            if (runtimeExtension != null) {
                                CSSBox child = this.first;
                                while (child != null) {
                                    if (child.getDomNode() instanceof DAnchorElement) {
                                        runtimeExtension.addonAnchorProcessing(g, child);
                                    }
                                    child = child.next;
                                }
                            }
                            sy += lineHeight;
                        } else {
                            outlinePainter.translate(g, sx - x + this.lines[lineIdx + 1], sy);
                            if (lineBoxIdx < this._lineBoxArray.length) {
                                super.paintChildren(g, x, this.lines[lineIdx + 0 + 3] - x, this._lineBoxArray[lineBoxIdx]);
                            }
                            outlinePainter.translate(g, -sx + x - this.lines[lineIdx + 1], -sy);
                            sy += lineHeight;
                        }
                    }
                    lineIdx += 3;
                    ++lineBoxIdx;
                }
            }
            if (this.markerBefore != null) {
                outlinePainter.drawBox(g, this.markerBefore, this.markerBefore.ox, 0);
            }
        }
        finally {
            if (g != og) {
                g.dispose();
            }
        }
    }

    CSSBox findChildByIndex(int aType, int aIndex) {
        Point p = new Point();
        CSSBox box = this.first;
        return box.findChildByIndex_r(aType, aIndex, p);
    }

    public boolean hasMoreThanOneChild() {
        CSSBox b = this.first;
        return b != null && b.next != null;
    }

    static {
        String extensionClass = Defs.property("ice.pilots.html4.GraphicExtension");
        if (extensionClass != null) {
            try {
                Class<?> addon = Class.forName(extensionClass);
                runtimeExtension = (ExternalCSSBoxAssist)addon.newInstance();
            }
            catch (Exception e) {
                Debug.p("Exception occured loading graphic extension class:" + e);
            }
        }
    }
}

