/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript.regexp;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.Function;
import ice.mozilla.javascript.JavaScriptException;
import ice.mozilla.javascript.ObjArray;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.regexp.GlobData;
import ice.mozilla.javascript.regexp.NativeRegExp;
import ice.mozilla.javascript.regexp.RegExpImpl;
import ice.mozilla.javascript.regexp.SubString;

class ReplaceData
extends GlobData {
    static SubString dollarStr = new SubString("$");
    Function lambda;
    char[] repstr;
    int dollar = -1;
    char[] charArray;
    int length;
    int index;
    int leftIndex;

    ReplaceData() {
    }

    void doGlobal(Context cx, Scriptable scope, int count, RegExpImpl reImpl) throws JavaScriptException {
        char[] charArray;
        ReplaceData rdata = this;
        SubString lc = reImpl.leftContext;
        char[] leftArray = lc.charArray;
        int leftIndex = rdata.leftIndex;
        int leftlen = reImpl.lastMatch.index - leftIndex;
        rdata.leftIndex = reImpl.lastMatch.index + reImpl.lastMatch.length;
        int replen = this.findReplen(cx, reImpl);
        int growth = leftlen + replen;
        if (rdata.charArray != null) {
            charArray = new char[rdata.length + growth];
            System.arraycopy(rdata.charArray, 0, charArray, 0, rdata.length);
        } else {
            charArray = new char[growth];
        }
        rdata.charArray = charArray;
        rdata.length += growth;
        int index = rdata.index;
        rdata.index += growth;
        System.arraycopy(leftArray, leftIndex, charArray, index, leftlen);
        this.doReplace(cx, reImpl, charArray, index += leftlen);
    }

    static SubString interpretDollar(Context cx, RegExpImpl res, char[] da, int dp, int bp, int[] skip) {
        if (da[dp] != '$') {
            throw new RuntimeException();
        }
        if (cx.getLanguageVersion() != 0 && cx.getLanguageVersion() <= 140 && dp > bp && da[dp - 1] == '\\') {
            return null;
        }
        if (dp + 1 >= da.length) {
            return null;
        }
        char dc = da[dp + 1];
        if (NativeRegExp.isDigit(dc)) {
            int tmp;
            int cp;
            int num;
            if (cx.getLanguageVersion() != 0 && cx.getLanguageVersion() <= 140) {
                if (dc == '0') {
                    return null;
                }
                num = 0;
                char[] ca = da;
                cp = dp;
                while (++cp < ca.length && NativeRegExp.isDigit(dc = ca[cp]) && (tmp = 10 * num + NativeRegExp.unDigit(dc)) >= num) {
                    num = tmp;
                }
            } else {
                int parenCount = res.parens.size();
                num = NativeRegExp.unDigit(dc);
                if (num > parenCount) {
                    return null;
                }
                cp = dp + 2;
                if (dp + 2 < da.length && NativeRegExp.isDigit(dc = da[dp + 2]) && (tmp = 10 * num + NativeRegExp.unDigit(dc)) <= parenCount) {
                    ++cp;
                    num = tmp;
                }
                if (num == 0) {
                    return null;
                }
            }
            skip[0] = cp - dp;
            return res.getParenSubString(--num);
        }
        skip[0] = 2;
        switch (dc) {
            case '$': {
                return dollarStr;
            }
            case '&': {
                return res.lastMatch;
            }
            case '+': {
                return res.lastParen;
            }
            case '`': {
                if (cx.getLanguageVersion() == 120) {
                    res.leftContext.index = 0;
                    res.leftContext.length = res.lastMatch.index;
                }
                return res.leftContext;
            }
            case '\'': {
                return res.rightContext;
            }
        }
        return null;
    }

    int findReplen(Context cx, RegExpImpl reImpl) throws JavaScriptException {
        if (this.lambda != null) {
            ObjArray parens = reImpl.parens;
            int parenCount = parens.size();
            Object[] args = new Object[parenCount + 3];
            args[0] = reImpl.lastMatch.toString();
            for (int i = 0; i < parenCount; ++i) {
                SubString sub = (SubString)parens.get(i);
                args[i + 1] = sub.toString();
            }
            args[parenCount + 1] = new Integer(reImpl.leftContext.length);
            args[parenCount + 2] = this.str;
            Scriptable parent = this.lambda.getParentScope();
            Object result = this.lambda.call(cx, parent, parent, args);
            this.repstr = ScriptRuntime.toString(result).toCharArray();
            return this.repstr.length;
        }
        int replen = this.repstr.length;
        if (this.dollar == -1) {
            return replen;
        }
        int bp = 0;
        int dp = this.dollar;
        while (dp < this.repstr.length) {
            char c = this.repstr[dp];
            if (c != '$') {
                ++dp;
                continue;
            }
            int[] skip = new int[]{0};
            SubString sub = ReplaceData.interpretDollar(cx, reImpl, this.repstr, dp, bp, skip);
            if (sub != null) {
                replen += sub.length - skip[0];
                dp += skip[0];
                continue;
            }
            ++dp;
        }
        return replen;
    }

    void doReplace(Context cx, RegExpImpl regExpImpl, char[] charArray, int arrayIndex) {
        int cp = 0;
        char[] da = this.repstr;
        int dp = this.dollar;
        int bp = cp;
        if (dp != -1) {
            block0: while (true) {
                int len = dp - cp;
                System.arraycopy(this.repstr, cp, charArray, arrayIndex, len);
                arrayIndex += len;
                cp = dp;
                int[] skip = new int[]{0};
                SubString sub = ReplaceData.interpretDollar(cx, regExpImpl, da, dp, bp, skip);
                if (sub != null) {
                    len = sub.length;
                    if (len > 0) {
                        System.arraycopy(sub.charArray, sub.index, charArray, arrayIndex, len);
                    }
                    arrayIndex += len;
                    cp += skip[0];
                    dp += skip[0];
                } else {
                    ++dp;
                }
                if (dp >= this.repstr.length) break;
                do {
                    if (this.repstr[dp] == '$') continue block0;
                } while (++dp < this.repstr.length);
                break;
            }
        }
        if (this.repstr.length > cp) {
            System.arraycopy(this.repstr, cp, charArray, arrayIndex, this.repstr.length - cp);
        }
    }
}

