/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.BaseFunction;
import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.NativeCall;
import ice.mozilla.javascript.Parser;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.WrappedException;
import java.lang.reflect.Method;

public class NativeFunction
extends BaseFunction {
    protected String[] argNames;
    protected short argCount;
    protected short version;
    boolean fromFunctionConstructor;

    public String decompile(Context cx, int indent, boolean justbody) {
        Object sourcesTree = this.getSourcesTree();
        if (sourcesTree == null) {
            return super.decompile(cx, indent, justbody);
        }
        return Parser.decompile(sourcesTree, this.fromFunctionConstructor, this.version, indent, justbody);
    }

    public int getLength() {
        Context cx = Context.getContext();
        if (cx != null && cx.getLanguageVersion() != 120) {
            return this.argCount;
        }
        NativeCall activation = this.getActivation(cx);
        if (activation == null) {
            return this.argCount;
        }
        return activation.getOriginalArguments().length;
    }

    public int getArity() {
        return this.argCount;
    }

    public String getFunctionName() {
        if (this.fromFunctionConstructor) {
            return this.version == 120 ? "" : "anonymous";
        }
        return super.getFunctionName();
    }

    public String jsGet_name() {
        return this.getFunctionName();
    }

    protected Object getSourcesTree() {
        Class<?> cl = this.getClass();
        try {
            Method m = cl.getDeclaredMethod("getSourcesTreeImpl", new Class[0]);
            return m.invoke(null, ScriptRuntime.emptyArgs);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw WrappedException.wrapException(ex);
        }
    }
}

