/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SegY2SqlLdr {
    public static void readFile(DataInputStream dataInputStream, BufferedOutputStream bufferedOutputStream, BufferedOutputStream bufferedOutputStream2, PrintStream printStream, long l) throws IOException {
        long l2;
        long l3 = System.currentTimeMillis();
        TextualFileHeader.readTextualFileHeader(dataInputStream, printStream, false, 0);
        BinaryFileHeader binaryFileHeader = new BinaryFileHeader(dataInputStream, printStream);
        for (int i = 0; i < binaryFileHeader.m_numberOfExtendedTextualFileHeaderRecords; ++i) {
            TextualFileHeader.readTextualFileHeader(dataInputStream, printStream, true, i + 1);
        }
        long l4 = 0L;
        for (l2 = 0L; dataInputStream.available() > 0 && l2 < l; ++l2) {
            DataTraceHeader dataTraceHeader = new DataTraceHeader(dataInputStream, bufferedOutputStream2, printStream, l2, binaryFileHeader.m_version);
            l4 += (long)dataTraceHeader.m_numberOfSamplesInThisTrace;
            DataTraceBody dataTraceBody = new DataTraceBody(dataInputStream, bufferedOutputStream, dataTraceHeader);
        }
        printStream.format("# of Data Traces:   %,20d%n", l2);
        printStream.format("Total # of samples: %,20d%n", l4);
        SegY2SqlLdr.readRestOfFile(dataInputStream, printStream);
        long l5 = System.currentTimeMillis();
        printStream.format("Total time, s:      %,24.3f%n", (double)(l5 - l3) / 1000.0);
        printStream.format("# Samples / s:      %,20d%n", 1000L * l4 / (l5 - l3));
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        bufferedOutputStream2.flush();
        bufferedOutputStream2.close();
        printStream.flush();
        printStream.close();
    }

    private static void readRestOfFile(DataInputStream dataInputStream, PrintStream printStream) throws IOException {
        int n = 0;
        while (n++ >= 0) {
            try {
                dataInputStream.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                if (n <= 1) break;
                printStream.println("Rest:");
                printStream.println(n - 1 + " more bytes read");
                break;
            }
        }
    }

    public static void readFile(String string, BufferedOutputStream bufferedOutputStream, BufferedOutputStream bufferedOutputStream2, PrintStream printStream, long l) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(string.compareToIgnoreCase("stdin") == 0 ? System.in : new FileInputStream(string)));
            SegY2SqlLdr.readFile(dataInputStream, bufferedOutputStream, bufferedOutputStream2, printStream, l);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedOutputStream2.flush();
            bufferedOutputStream2.close();
            printStream.flush();
            printStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        String string = stringArray.length < 2 ? "1000000000" : stringArray[1];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream("SegYSamples.csv"));
        BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(new FileOutputStream("SegYTraces.csv"));
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream("SegYInfo.txt")));
        SegY2SqlLdr.readFile(stringArray[0], bufferedOutputStream, bufferedOutputStream2, printStream, Long.parseLong(string));
    }

    private static class DataTraceHeader {
        protected final int m_traceSequenceNumberWithinLine;
        protected final int m_traceSequenceNumberWithinSegYFile;
        protected final int m_originalFieldRecordNumber;
        protected final int m_energySourcePointNumber;
        protected final int m_ensembleNumber;
        protected final short m_traceIdentificationCode;
        protected final short m_dataUse;
        protected final short m_scalarToBeAppliedToHeader;
        protected final double m_sourceCoordinateX;
        protected final double m_sourceCoordinateY;
        protected final double m_groupCoordinateX;
        protected final double m_groupCoordinateY;
        protected final short m_coordinateUnit;
        protected final short m_lagTimeA;
        protected final short m_delayRecordingTime;
        protected final short m_numberOfSamplesInThisTrace;
        protected final short m_sampleIntervalInMicroseconds;
        protected final double m_xCoordOfEnsemblePosOfThisTrace;
        protected final double m_yCoordOfEnsemblePosOfThisTrace;
        protected final int m_inlineNumberFor3dPoststack;
        protected final int m_crosslineNumberFor3dPoststack;
        protected final int m_shotpointNumber;
        protected final long m_dataTraceHeaderNum;
        private static final String[] DATA_USES = new String[]{"Production", "Test"};
        private static final String[] COORDINATE_UNITS = new String[]{"Length (meters or feet)", "Seconds of Arc", "Decimal Degrees", "Degrees, Minutes, Seconds (DMS)"};

        protected DataTraceHeader(DataInputStream dataInputStream, BufferedOutputStream bufferedOutputStream, PrintStream printStream, long l, double d) throws IOException {
            int n;
            byte[] byArray = new byte[240];
            boolean[] blArray = new boolean[byArray.length];
            this.m_dataTraceHeaderNum = l;
            for (n = 0; n < byArray.length; ++n) {
                blArray[n] = false;
            }
            dataInputStream.readFully(byArray, 0, byArray.length);
            this.m_traceSequenceNumberWithinLine = DataTraceHeader.determineTraceSequenceNumberWithinLine(byArray, blArray, d);
            this.m_traceSequenceNumberWithinSegYFile = DataTraceHeader.determineTraceSequenceNumberWithinSegYFile(byArray, blArray, d);
            this.m_originalFieldRecordNumber = DataTraceHeader.determineOriginalFieldRecordNumber(byArray, blArray, d);
            this.m_energySourcePointNumber = DataTraceHeader.determineEnergySourcePointNumber(byArray, blArray, d);
            this.m_ensembleNumber = DataTraceHeader.determineEnsembleNumber(byArray, blArray, d);
            this.m_traceIdentificationCode = DataTraceHeader.determineTraceIdentificationCode(byArray, blArray, d);
            this.m_dataUse = DataTraceHeader.determineDataUse(byArray, blArray, d);
            this.m_scalarToBeAppliedToHeader = DataTraceHeader.determineScalarToBeAppliedToHeader(byArray, blArray, d);
            this.m_sourceCoordinateX = DataTraceHeader.determineSourceCoordinateX(byArray, blArray, d, this.m_scalarToBeAppliedToHeader);
            this.m_sourceCoordinateY = DataTraceHeader.determineSourceCoordinateY(byArray, blArray, d, this.m_scalarToBeAppliedToHeader);
            this.m_groupCoordinateX = DataTraceHeader.determineGroupCoordinateX(byArray, blArray, d, this.m_scalarToBeAppliedToHeader);
            this.m_groupCoordinateY = DataTraceHeader.determineGroupCoordinateY(byArray, blArray, d, this.m_scalarToBeAppliedToHeader);
            this.m_coordinateUnit = DataTraceHeader.determineCoordinateUnit(byArray, blArray, d);
            this.m_lagTimeA = DataTraceHeader.determineLagTimeA(byArray, blArray, d);
            this.m_delayRecordingTime = DataTraceHeader.determineDelayRecordingTime(byArray, blArray, d);
            this.m_numberOfSamplesInThisTrace = DataTraceHeader.determineNumberOfSamplesInThisTrace(byArray, blArray, d);
            this.m_sampleIntervalInMicroseconds = DataTraceHeader.determineSampleIntervalInMicroseconds(byArray, blArray, d);
            this.m_xCoordOfEnsemblePosOfThisTrace = DataTraceHeader.determineXCoordOfEnsemblePosOfThisTrace(byArray, blArray, d, this.m_scalarToBeAppliedToHeader);
            this.m_yCoordOfEnsemblePosOfThisTrace = DataTraceHeader.determineYCoordOfEnsemblePosOfThisTrace(byArray, blArray, d, this.m_scalarToBeAppliedToHeader);
            this.m_inlineNumberFor3dPoststack = DataTraceHeader.determineInlineNumberFor3dPoststack(byArray, blArray, d);
            this.m_crosslineNumberFor3dPoststack = DataTraceHeader.determineCrosslineNumberFor3dPoststack(byArray, blArray, d);
            this.m_shotpointNumber = DataTraceHeader.determineShotpointNumber(byArray, blArray, d);
            if (l == 0L) {
                printStream.println();
                printStream.println("Data Trace Header " + l + ":");
                printStream.println("--------------------------------------------------------------------------------");
                printStream.format("Trace Sequence # Within Line: ................................... %,14d%n", this.m_traceSequenceNumberWithinLine);
                printStream.format("Trace Sequence # Within SegY File: .............................. %,14d%n", this.m_traceSequenceNumberWithinSegYFile);
                printStream.format("Original Field Record #: ........................................ %,14d%n", this.m_originalFieldRecordNumber);
                printStream.format("Energy Source Point #: .......................................... %,14d%n", this.m_energySourcePointNumber);
                printStream.format("Ensemble #: ..................................................... %,14d%n", this.m_ensembleNumber);
                printStream.format("Trace Identification Code: ...................................... %,14d%n", this.m_traceIdentificationCode);
                printStream.format("Data Use: ....................................................... %,14d%n", this.m_dataUse);
                printStream.println("           (1 = Production,");
                printStream.println("            2 = Test)");
                printStream.format("Scalar To Be Applied To Header: ................................. %,14d%n", this.m_scalarToBeAppliedToHeader);
                printStream.format("Source Coordinate X: ............................................ %,14.2f%n", this.m_sourceCoordinateX);
                printStream.format("Source Coordinate Y: ............................................ %,14.2f%n", this.m_sourceCoordinateY);
                printStream.format("Group Coordinate X: ............................................. %,14.2f%n", this.m_groupCoordinateX);
                printStream.format("Group Coordinate Y: ............................................. %,14.2f%n", this.m_groupCoordinateY);
                printStream.format("Coordinate Unit: ................................................ %,14d%n", this.m_coordinateUnit);
                printStream.println("           (1 = Length (meters or feet),");
                printStream.println("            2 = Seconds of Arc,");
                printStream.println("            3 = Decimal Degrees,");
                printStream.println("            4 = Degrees, Minutes, Seconds (DMS))");
                printStream.format("Lag Time A: ..................................................... %,14d%n", this.m_lagTimeA);
                printStream.format("Delay Recording Time: ........................................... %,14d%n", this.m_delayRecordingTime);
                printStream.format("# Of Samples In This Trace: ..................................... %,14d%n", this.m_numberOfSamplesInThisTrace);
                printStream.format("Sample Interval In Microseconds: ................................ %,14d%n", this.m_sampleIntervalInMicroseconds);
                printStream.format("X Coord Of Ensemble Pos Of This Trace: .......................... %,14.2f%n", this.m_xCoordOfEnsemblePosOfThisTrace);
                printStream.format("Y Coord Of Ensemble Pos Of This Trace: .......................... %,14.2f%n", this.m_yCoordOfEnsemblePosOfThisTrace);
                printStream.format("Inline # For 3d Poststack: ...................................... %,14d%n", this.m_inlineNumberFor3dPoststack);
                printStream.format("Crossline # For 3d Poststack: ................................... %,14d%n", this.m_crosslineNumberFor3dPoststack);
                printStream.format("Shotpoint #: .................................................... %,14d%n", this.m_shotpointNumber);
                printStream.println("--------------------------------------------------------------------------------");
                printStream.println("Not yet analyzed:");
                for (n = 0; n < byArray.length; ++n) {
                    if (byArray[n] == 0 || blArray[n]) continue;
                    printStream.println(n + 1 + ": " + byArray[n]);
                }
                printStream.println("--------------------------------------------------------------------------------");
            }
            bufferedOutputStream.write((this.m_traceSequenceNumberWithinSegYFile + ", " + this.m_traceSequenceNumberWithinLine + ", " + this.m_originalFieldRecordNumber + ", " + this.m_energySourcePointNumber + ", " + this.m_ensembleNumber + ", " + this.m_traceIdentificationCode + "," + DATA_USES[this.m_dataUse - 1] + ", " + this.m_sourceCoordinateX + ", " + this.m_sourceCoordinateY + ", " + this.m_groupCoordinateX + ", " + this.m_groupCoordinateY + "," + COORDINATE_UNITS[this.m_coordinateUnit - 1] + ", " + this.m_lagTimeA + ", " + this.m_delayRecordingTime + ", " + this.m_numberOfSamplesInThisTrace + ", " + this.m_sampleIntervalInMicroseconds + ", " + this.m_xCoordOfEnsemblePosOfThisTrace + ", " + this.m_yCoordOfEnsemblePosOfThisTrace + ", " + this.m_inlineNumberFor3dPoststack + ", " + this.m_crosslineNumberFor3dPoststack + ", " + this.m_shotpointNumber + "\n").getBytes());
        }

        protected static int determineTraceSequenceNumberWithinLine(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Trace Sequence Number Within Line (Trace Header) applies to version " + d);
            }
            blArray[3] = true;
            blArray[2] = true;
            blArray[1] = true;
            blArray[0] = true;
            return ByteBuffer.wrap(byArray, 0, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static int determineTraceSequenceNumberWithinSegYFile(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Trace Sequence Number Within SegY File (Trace Header) applies to version " + d);
            }
            blArray[7] = true;
            blArray[6] = true;
            blArray[5] = true;
            blArray[4] = true;
            return ByteBuffer.wrap(byArray, 4, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static int determineOriginalFieldRecordNumber(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Original Field Record Number (Trace Header) applies to version " + d);
            }
            blArray[11] = true;
            blArray[10] = true;
            blArray[9] = true;
            blArray[8] = true;
            return ByteBuffer.wrap(byArray, 8, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static int determineEnergySourcePointNumber(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Energy Source Point Number (Trace Header) applies to version " + d);
            }
            blArray[19] = true;
            blArray[18] = true;
            blArray[17] = true;
            blArray[16] = true;
            return ByteBuffer.wrap(byArray, 16, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static int determineEnsembleNumber(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Ensemble Number (Trace Header) applies to version " + d);
            }
            blArray[23] = true;
            blArray[22] = true;
            blArray[21] = true;
            blArray[20] = true;
            return ByteBuffer.wrap(byArray, 20, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        private static short determineTraceIdentificationCode(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Trace Identification Code (Trace Header) applies to version " + d);
            }
            blArray[29] = true;
            blArray[28] = true;
            return ByteBuffer.wrap(byArray, 28, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineDataUse(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Data Use (Trace Header) applies to version " + d);
            }
            blArray[35] = true;
            blArray[34] = true;
            return ByteBuffer.wrap(byArray, 34, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineScalarToBeAppliedToHeader(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Scalar To Be Applied To Header (Trace Header) applies to version " + d);
            }
            blArray[71] = true;
            blArray[70] = true;
            return ByteBuffer.wrap(byArray, 70, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        protected static double determineSourceCoordinateX(byte[] byArray, boolean[] blArray, double d, short s) {
            double d2 = 1.0;
            if (s < 0) {
                d2 = 1.0 / (double)(-s);
            }
            if (s > 0) {
                d2 = s;
            }
            if (d != 1.0) {
                throw new RuntimeException("Not sure Source Coordinate X (Trace Header) applies to version " + d);
            }
            blArray[75] = true;
            blArray[74] = true;
            blArray[73] = true;
            blArray[72] = true;
            return d2 * (double)ByteBuffer.wrap(byArray, 72, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static double determineSourceCoordinateY(byte[] byArray, boolean[] blArray, double d, short s) {
            double d2 = 1.0;
            if (s < 0) {
                d2 = 1.0 / (double)(-s);
            }
            if (s > 0) {
                d2 = s;
            }
            if (d != 1.0) {
                throw new RuntimeException("Not sure Source Coordinate Y (Trace Header) applies to version " + d);
            }
            blArray[79] = true;
            blArray[78] = true;
            blArray[77] = true;
            blArray[76] = true;
            return d2 * (double)ByteBuffer.wrap(byArray, 76, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static double determineGroupCoordinateX(byte[] byArray, boolean[] blArray, double d, short s) {
            double d2 = 1.0;
            if (s < 0) {
                d2 = 1.0 / (double)(-s);
            }
            if (s > 0) {
                d2 = s;
            }
            if (d != 1.0) {
                throw new RuntimeException("Not sure Group Coordinate X (Trace Header) applies to version " + d);
            }
            blArray[83] = true;
            blArray[82] = true;
            blArray[81] = true;
            blArray[80] = true;
            return d2 * (double)ByteBuffer.wrap(byArray, 80, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static double determineGroupCoordinateY(byte[] byArray, boolean[] blArray, double d, short s) {
            double d2 = 1.0;
            if (s < 0) {
                d2 = 1.0 / (double)(-s);
            }
            if (s > 0) {
                d2 = s;
            }
            if (d != 1.0) {
                throw new RuntimeException("Not sure Group Coordinate Y (Trace Header) applies to version " + d);
            }
            blArray[87] = true;
            blArray[86] = true;
            blArray[85] = true;
            blArray[84] = true;
            return d2 * (double)ByteBuffer.wrap(byArray, 84, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        private static short determineCoordinateUnit(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Coordinate Units (Trace Header) applies to version " + d);
            }
            blArray[89] = true;
            blArray[88] = true;
            short s = ByteBuffer.wrap(byArray, 88, 2).order(ByteOrder.BIG_ENDIAN).getShort();
            if (s == 4) {
                throw new RuntimeException("Have to decode DMS");
            }
            return s;
        }

        private static short determineLagTimeA(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Lag Time A (Trace Header) applies to version " + d);
            }
            blArray[105] = true;
            blArray[104] = true;
            return ByteBuffer.wrap(byArray, 104, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineDelayRecordingTime(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Delay Recording Time (Trace Header) applies to version " + d);
            }
            blArray[109] = true;
            blArray[108] = true;
            return ByteBuffer.wrap(byArray, 108, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineNumberOfSamplesInThisTrace(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Number Of Samples In This Trace (Trace Header) applies to version " + d);
            }
            blArray[115] = true;
            blArray[114] = true;
            return ByteBuffer.wrap(byArray, 114, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineSampleIntervalInMicroseconds(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Sample Interval In Microseconds (Trace Header) applies to version " + d);
            }
            blArray[117] = true;
            blArray[116] = true;
            return ByteBuffer.wrap(byArray, 116, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static double determineXCoordOfEnsemblePosOfThisTrace(byte[] byArray, boolean[] blArray, double d, short s) {
            double d2 = 1.0;
            if (s < 0) {
                d2 = 1.0 / (double)(-s);
            }
            if (s > 0) {
                d2 = s;
            }
            if (d != 1.0) {
                throw new RuntimeException("Not sure X Coord Of Ensemble Pos Of This Trace (Trace Header) applies to version " + d);
            }
            blArray[183] = true;
            blArray[182] = true;
            blArray[181] = true;
            blArray[180] = true;
            return d2 * (double)ByteBuffer.wrap(byArray, 180, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        private static double determineYCoordOfEnsemblePosOfThisTrace(byte[] byArray, boolean[] blArray, double d, short s) {
            double d2 = 1.0;
            if (s < 0) {
                d2 = 1.0 / (double)(-s);
            }
            if (s > 0) {
                d2 = s;
            }
            if (d != 1.0) {
                throw new RuntimeException("Not sure Y Coord Of Ensemble Pos Of This Trace (Trace Header) applies to version " + d);
            }
            blArray[187] = true;
            blArray[186] = true;
            blArray[185] = true;
            blArray[184] = true;
            return d2 * (double)ByteBuffer.wrap(byArray, 184, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static int determineInlineNumberFor3dPoststack(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Inline # for 3d Poststack (Trace Header) applies to version " + d);
            }
            blArray[191] = true;
            blArray[190] = true;
            blArray[189] = true;
            blArray[188] = true;
            return ByteBuffer.wrap(byArray, 188, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static int determineCrosslineNumberFor3dPoststack(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Crossline # for 3d Poststack (Trace Header) applies to version " + d);
            }
            blArray[195] = true;
            blArray[194] = true;
            blArray[193] = true;
            blArray[192] = true;
            return ByteBuffer.wrap(byArray, 192, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        protected static int determineShotpointNumber(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Shotpoint # (Trace Header) applies to version " + d);
            }
            blArray[199] = true;
            blArray[198] = true;
            blArray[197] = true;
            blArray[196] = true;
            return ByteBuffer.wrap(byArray, 196, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }
    }

    private static class DataTraceBody {
        protected final DataTraceHeader m_header;

        protected DataTraceBody(DataInputStream dataInputStream, BufferedOutputStream bufferedOutputStream, DataTraceHeader dataTraceHeader) throws IOException {
            this.m_header = dataTraceHeader;
            byte[] byArray = new byte[2 * dataTraceHeader.m_numberOfSamplesInThisTrace];
            dataInputStream.readFully(byArray, 0, byArray.length);
            for (int i = 0; i < dataTraceHeader.m_numberOfSamplesInThisTrace; ++i) {
                short s = ByteBuffer.wrap(byArray, 2 * i, 2).order(ByteOrder.BIG_ENDIAN).getShort();
                bufferedOutputStream.write((dataTraceHeader.m_traceSequenceNumberWithinSegYFile + ", " + i + ", " + s + "\n").getBytes());
            }
        }
    }

    private static class BinaryFileHeader {
        protected final double m_version;
        protected final int m_jobIdentificationNumber;
        protected final short m_sampleIntervalInMicroseconds;
        protected final short m_numberOfSamplesPerDataTrace;
        protected final short m_dataSampleFormatCode;
        protected final short m_traceSortingCode;
        protected final short m_measurementSystem;
        protected final short m_fixedLengthTraceFlag;
        protected final short m_numberOfExtendedTextualFileHeaderRecords;

        protected BinaryFileHeader(DataInputStream dataInputStream, PrintStream printStream) throws IOException {
            int n;
            byte[] byArray = new byte[400];
            boolean[] blArray = new boolean[byArray.length];
            for (n = 0; n < byArray.length; ++n) {
                blArray[n] = false;
            }
            dataInputStream.readFully(byArray, 0, byArray.length);
            this.m_version = BinaryFileHeader.determineVersion(byArray, blArray);
            this.m_jobIdentificationNumber = BinaryFileHeader.determineJobIdentificationNumber(byArray, blArray, this.m_version);
            this.m_sampleIntervalInMicroseconds = BinaryFileHeader.determineSampleIntervalInMicroseconds(byArray, blArray, this.m_version);
            this.m_numberOfSamplesPerDataTrace = BinaryFileHeader.determineNumberOfSamplesPerDataTrace(byArray, blArray, this.m_version);
            this.m_dataSampleFormatCode = BinaryFileHeader.determineDataSampleFormatCode(byArray, blArray, this.m_version);
            this.m_traceSortingCode = BinaryFileHeader.determineTraceSortingCode(byArray, blArray, this.m_version);
            this.m_measurementSystem = BinaryFileHeader.determineMeasurementSystem(byArray, blArray, this.m_version);
            this.m_fixedLengthTraceFlag = BinaryFileHeader.determineFixedLengthTraceFlag(byArray, blArray, this.m_version);
            this.m_numberOfExtendedTextualFileHeaderRecords = BinaryFileHeader.determineNumberOfExtendedTextualFileHeaderRecords(byArray, blArray, this.m_version);
            printStream.println();
            printStream.println("Binary File Header:");
            printStream.println("--------------------------------------------------------------------------------");
            printStream.format("SEG-Y Version: ...................................................... %10.1f%n", this.m_version);
            printStream.format("Job Identification #: ............................................... %,10d%n", this.m_jobIdentificationNumber);
            printStream.format("Sample Interval in Microseconds: .................................... %,10d%n", this.m_sampleIntervalInMicroseconds);
            printStream.format("# of Samples/Data Trace: ............................................ %,10d%n", this.m_numberOfSamplesPerDataTrace);
            printStream.format("Fixed Length Trace Flag: ............................................ %,10d%n", this.m_fixedLengthTraceFlag);
            printStream.println("           (0 = Variable Sample Interval and # of Samples/DataTrace,");
            printStream.println("            1 = Fixed Sample Interval and # of Samples/Data Trace)");
            printStream.format("Data Sample Format Code: ............................................ %,10d%n", this.m_dataSampleFormatCode);
            printStream.println("           (1 = 4-byte IBM floating point,");
            printStream.println("            2 = 4-byte, two's complement integer,");
            printStream.println("            3 = 2-byte, two's complement integer,");
            printStream.println("            4 = 4-byte fixed-point with gain (obsolete),");
            printStream.println("            5 = 4-byte IEEEfloating-point,");
            printStream.println("            6 = Not currently used,");
            printStream.println("            7 = Not currently used,");
            printStream.println("            8 = 1-byte, two's complement integer)");
            printStream.format("Trace Sorting Code: ................................................. %,10d%n", this.m_traceSortingCode);
            printStream.println("          (-1 = Other,");
            printStream.println("            0 = Unknown,");
            printStream.println("            1 = As recorded (no sorting),");
            printStream.println("            2 = CDP ensemble,");
            printStream.println("            3 = Single fold continuous profile,");
            printStream.println("            4 = Horizontally Stacked,");
            printStream.println("            5 = Common source point,");
            printStream.println("            6 = Common receiver point,");
            printStream.println("            7 = Common offset point,");
            printStream.println("            8 = Common mid-point,");
            printStream.println("            9 = Common conversion point)");
            printStream.format("Measurement System: ................................................. %,10d%n", this.m_measurementSystem);
            printStream.println("           (1 = Meter,");
            printStream.println("            2 = Feet)");
            printStream.format("# Of Extended Textual File Header Records: .......................... %,10d%n", this.m_numberOfExtendedTextualFileHeaderRecords);
            printStream.println("--------------------------------------------------------------------------------");
            printStream.println("Not yet analyzed:");
            for (n = 0; n < byArray.length; ++n) {
                if (byArray[n] == 0 || blArray[n]) continue;
                printStream.println(3200 + n + 1 + ": " + byArray[n]);
            }
            printStream.println("--------------------------------------------------------------------------------");
        }

        private static double determineVersion(byte[] byArray, boolean[] blArray) {
            blArray[301] = true;
            blArray[300] = true;
            if (byArray[300] == 1 && byArray[301] == 0) {
                return 1.0;
            }
            if (byArray[300] == 2 && byArray[301] == 0) {
                return 2.0;
            }
            throw new RuntimeException("Don't know SEG-Y Rev " + byArray[301] + "." + byArray[302]);
        }

        private static int determineJobIdentificationNumber(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Job Identification Number applies to version " + d);
            }
            blArray[3] = true;
            blArray[2] = true;
            blArray[1] = true;
            blArray[0] = true;
            return ByteBuffer.wrap(byArray, 0, 4).order(ByteOrder.BIG_ENDIAN).getInt();
        }

        private static short determineSampleIntervalInMicroseconds(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Sample Interval applies to version " + d);
            }
            blArray[17] = true;
            blArray[16] = true;
            return ByteBuffer.wrap(byArray, 16, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineNumberOfSamplesPerDataTrace(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Number Of Samples Per Data Trace applies to version " + d);
            }
            blArray[21] = true;
            blArray[20] = true;
            return ByteBuffer.wrap(byArray, 20, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineDataSampleFormatCode(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Data Sample Format Code applies to version " + d);
            }
            blArray[25] = true;
            blArray[24] = true;
            return ByteBuffer.wrap(byArray, 24, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineTraceSortingCode(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Trace Sorting Code applies to version " + d);
            }
            blArray[29] = true;
            blArray[28] = true;
            return ByteBuffer.wrap(byArray, 28, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineMeasurementSystem(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Measurement System applies to version " + d);
            }
            blArray[55] = true;
            blArray[54] = true;
            return ByteBuffer.wrap(byArray, 54, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }

        private static short determineFixedLengthTraceFlag(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Fixed Length Trace Flag applies to version " + d);
            }
            blArray[303] = true;
            blArray[302] = true;
            short s = ByteBuffer.wrap(byArray, 302, 2).order(ByteOrder.BIG_ENDIAN).getShort();
            if (s == 0) {
                throw new RuntimeException("Currently not allowing variable Sample Interval and # of Samples/Data Trace");
            }
            return s;
        }

        private static short determineNumberOfExtendedTextualFileHeaderRecords(byte[] byArray, boolean[] blArray, double d) {
            if (d != 1.0) {
                throw new RuntimeException("Not sure Number Of Extended Textual File Header Records applies to version " + d);
            }
            blArray[305] = true;
            blArray[304] = true;
            return ByteBuffer.wrap(byArray, 304, 2).order(ByteOrder.BIG_ENDIAN).getShort();
        }
    }

    protected static class TextualFileHeader {
        protected TextualFileHeader() {
        }

        protected static void readTextualFileHeader(DataInputStream dataInputStream, PrintStream printStream, boolean bl, int n) throws IOException {
            byte[] byArray = new byte[80];
            if (bl) {
                printStream.println("Extended Textual File Header " + n + ":");
            } else {
                printStream.println("Textual File Header:");
            }
            printStream.println("--------------------------------------------------------------------------------");
            for (int i = 0; i < 40; ++i) {
                dataInputStream.readFully(byArray, 0, 80);
                printStream.print(new String(byArray));
                printStream.println("|");
            }
            printStream.println("--------------------------------------------------------------------------------");
        }
    }
}

