/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaEntityResolver
implements EntityResolver {
    protected Connection conn;

    public SchemaEntityResolver(Connection connection) {
        this.conn = connection;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException, RuntimeException {
        Reader reader;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.conn.prepareStatement("select XSD_DOC from MDSYS.SDO_XSD_TABLE where XSD_URL = ?");
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            reader = resultSet.getCharacterStream(1);
        }
        catch (SQLException sQLException) {
            System.out.println("Exception while resolving:" + string + ":" + string2);
            sQLException.printStackTrace();
            throw new RuntimeException(sQLException);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                } else {
                    System.out.println("ResultSet in oracle.spatial.util.SchemaEntityResolver.resolveEntity method is null");
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                } else {
                    System.out.println("Prepared Statement in oracle.spatial.util.SchemaEntityResolver.resolveEntity method is null");
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string2);
        return inputSource;
    }
}

