/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.spatial.util.DBFReaderJGeom;
import oracle.spatial.util.ShapefileFeatureJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;

public class SampleShapefileToJGeomFeature {
    private static String m_host;
    private static String m_port;
    private static String m_sid;
    private static String m_svc;
    private static String m_user;
    private static String m_password;
    private static String m_wallet_dir;
    private static String m_tableName;
    private static String m_shapefileName;
    private static String m_idName;
    private static int m_srid;
    private static String m_geom;
    private static String m_keyword_table;
    private static String min_x;
    private static String min_y;
    private static String max_x;
    private static String max_y;
    private static String m_tolerance;
    private static String mg_tolerance;
    private static int m_start_id;
    private static int m_commit_interval;
    private static int m_println_interval;
    private static String dimArray;
    private static String dimArrayMig;
    private static boolean defaultX;
    private static boolean defaultY;
    private static String m_tns_alias;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string = "The following key/value is missing: ";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        if (stringArray.length <= 1) {
            System.out.println("USAGE: \n\tjava -cp [ORACLE_HOME]/jdbc/lib/ojdbc8.jar;./sdoutl.jar;./sdoapi.jar SampleShapefileToJGeomFeature -h db_host -p db_port [-s db_sid | -sn service_name ] -u db_username -d db_password -t db_table -f shapefile_name [-i table_id_column_name][-r srid][-g db_geometry_column][-x max_x,min_x][-y max_y,min_y][-o tolerance]");
            System.out.println("\tjava -cp [ORACLE_HOME]/jdbc/lib/ojdbc8.jar;./sdoutl.jar;./sdoapi.jar SampleShapefileToJGeomFeature -tns_alias db_alias -u db_username -d db_password -t db_table -f shapefile_name [-i table_id_column_name][-r srid][-g db_geometry_column][-x max_x,min_x][-y max_y,min_y][-o tolerance]");
            System.out.println("\tjava -cp [ORACLE_HOME]/jdbc/lib/ojdbc8.jar;[ORACLE_HOME]/jlib/oraclepki.jar;./sdoutl.jar;./sdoapi.jar SampleShapefileToJGeomFeature -w wallet_dir -tns_alias db_alias [-u db_username] [-d db_password] -t db_table -f shapefile_name [-i table_id_column_name][-r srid][-g db_geometry_column][-x max_x,min_x][-y max_y,min_y][-o tolerance]");
            System.out.println("Usage explanation (parameters used):");
            System.out.println("<-h>: Host machine with existing Oracle database");
            System.out.println("<-p>: Host machine's port with existing Oracle database (e.g. 1521)");
            System.out.println("<-s>: Host machine's SID with existing Oracle database");
            System.out.println("<-w>: Oracle Wallet file or directory where Oracle Wallet was extracted");
            System.out.println("<-sn>: Host machine's Service Name with existing Oracle database");
            System.out.println("<-tns_alias>: Alias of an entry of tnsnames.ora file");
            System.out.println("<-u>: Database user");
            System.out.println("<-d>: Database user's password");
            System.out.println("<-t>: Table name for the result");
            System.out.println("<-f>: File name of an input Shapefile (without extension)");
            System.out.println("[-i]: Column name for unique numeric ID; if required");
            System.out.println("[-r]: Valid Oracle SRID for coordinate system; use 0 if unknown");
            System.out.println("[-g]: Preferred or valid SDO_GEOMETRY column name");
            System.out.println("[-x]: Bounds for the X dimension; use -180,180 if unknown");
            System.out.println("[-y]: Bounds for the Y dimension; use -90,90 if unknown");
            System.out.println("[-o]: Load tolerance fields (x and y) in metadata, if not specified, tolerance fields are 0.05");
            System.out.println("[-a]: Append shapefile data to an existing table");
            System.out.println("[-n]: Start ID for column specified in -i parameter");
            System.out.println("[-c]: Commit interval. Default, commits every 1000 conversions and at the end of a run");
            System.out.println("[-v]: Println interval. Default, displays every 10 conversions.");
            System.out.println("[-k]: Table name that contains Oracle reserved word(s) in a column called KEYWORD.");
            System.exit(1);
        } else {
            for (int i = 0; stringArray.length > i; ++i) {
                vector.add(i, stringArray[i]);
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                try {
                    String string2 = (String)object.nextElement();
                    if (string2.equals("-a")) {
                        bl = true;
                        continue;
                    }
                    String string3 = (String)object.nextElement();
                    if (string2 == null || string3 == null) continue;
                    hashMap.put(string2, string3);
                }
                catch (Exception exception) {
                    System.out.println("One of your key-value pairs failed.  Please try again");
                    exception.printStackTrace();
                    System.exit(1);
                }
            }
        }
        if (hashMap.containsKey("-h")) {
            System.out.println("host: " + (String)hashMap.get("-h"));
            m_host = (String)hashMap.get("-h");
            if (hashMap.containsKey("-p")) {
                System.out.println("port: " + (String)hashMap.get("-p"));
                m_port = (String)hashMap.get("-p");
            } else {
                System.out.println(string + "-p db_port");
                System.exit(1);
            }
            if (hashMap.containsKey("-s") || hashMap.containsKey("-sn")) {
                if (hashMap.containsKey("-s")) {
                    System.out.println("sid: " + (String)hashMap.get("-s"));
                    m_sid = (String)hashMap.get("-s");
                }
                if (hashMap.containsKey("-sn")) {
                    System.out.println("service_name: " + (String)hashMap.get("-sn"));
                    m_svc = (String)hashMap.get("-sn");
                }
            } else {
                System.out.println(string + "-s db_sid OR -sn db_service_name OR -tns_alias db_tns_alias");
                System.exit(1);
            }
            if (hashMap.containsKey("-u")) {
                System.out.println("db_username: " + (String)hashMap.get("-u"));
                m_user = (String)hashMap.get("-u");
            } else {
                System.out.println(string + "-u db_username");
                System.exit(1);
            }
            if (hashMap.containsKey("-d")) {
                System.out.println("db_password: ********");
                m_password = (String)hashMap.get("-d");
            } else {
                System.out.println(string + "-d password");
                System.exit(1);
            }
        } else if (hashMap.containsKey("-w")) {
            System.out.println("wallet_directory: " + (String)hashMap.get("-w"));
            m_wallet_dir = (String)hashMap.get("-w");
            object = Paths.get(m_wallet_dir, new String[0]);
            if (!Files.isDirectory((Path)object, new LinkOption[0])) {
                if (Files.isRegularFile((Path)object, new LinkOption[0])) {
                    m_wallet_dir = SampleShapefileToJGeomFeature.unzipWallet((Path)object).toString();
                } else {
                    System.out.println("Invalid Wallet parameter");
                    System.exit(1);
                }
            }
            if (hashMap.containsKey("-tns_alias")) {
                m_tns_alias = (String)hashMap.get("-tns_alias");
                System.out.println("tns_alias: " + m_tns_alias);
            } else {
                System.out.println(string + "-tns_alias db_tns_alias");
                System.exit(1);
            }
            if (hashMap.containsKey("-u")) {
                System.out.println("db_username: " + (String)hashMap.get("-u"));
                m_user = (String)hashMap.get("-u");
            } else {
                m_user = null;
            }
            if (hashMap.containsKey("-d")) {
                System.out.println("db_password: ********");
                m_password = (String)hashMap.get("-d");
            } else {
                m_password = null;
            }
        } else if (hashMap.containsKey("-tns_alias")) {
            m_tns_alias = (String)hashMap.get("-tns_alias");
            System.out.println("tns_alias: " + m_tns_alias);
            if (hashMap.containsKey("-u")) {
                System.out.println("db_username: " + (String)hashMap.get("-u"));
                m_user = (String)hashMap.get("-u");
            } else {
                System.out.println(string + "-u db_username");
                System.exit(1);
            }
            if (hashMap.containsKey("-d")) {
                System.out.println("db_password: ********");
                m_password = (String)hashMap.get("-d");
            } else {
                System.out.println(string + "-d password");
                System.exit(1);
            }
        } else {
            System.out.println(string + "-h db_host OR -w wallet_dir OR -tns_alias");
            System.exit(1);
        }
        if (hashMap.containsKey("-t")) {
            System.out.println("db_tablename: " + (String)hashMap.get("-t"));
            m_tableName = (String)hashMap.get("-t");
        } else {
            System.out.println(string + "-t tablename");
            System.exit(1);
        }
        if (hashMap.containsKey("-f")) {
            System.out.println("shapefile_name: " + (String)hashMap.get("-f"));
            m_shapefileName = (String)hashMap.get("-f");
        } else {
            System.out.println(string + "-f shapefile_name");
            System.exit(1);
        }
        if (hashMap.containsKey("-i")) {
            System.out.println("table_id_column_name: " + (String)hashMap.get("-i"));
            m_idName = (String)hashMap.get("-i");
        }
        if (hashMap.containsKey("-r")) {
            System.out.println("SRID: " + (String)hashMap.get("-r"));
            m_srid = Integer.parseInt((String)hashMap.get("-r"));
        }
        if (hashMap.containsKey("-g")) {
            System.out.println("db_geometry_column: " + (String)hashMap.get("-g"));
            m_geom = (String)hashMap.get("-g");
        }
        if (hashMap.containsKey("-x")) {
            System.out.println("X: " + (String)hashMap.get("-x"));
            object = new StringTokenizer((String)hashMap.get("-x"), ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                min_x = ((StringTokenizer)object).nextToken();
                max_x = ((StringTokenizer)object).nextToken();
                defaultX = false;
            }
        }
        if (hashMap.containsKey("-y")) {
            System.out.println("Y: " + (String)hashMap.get("-y"));
            object = new StringTokenizer((String)hashMap.get("-y"), ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                min_y = ((StringTokenizer)object).nextToken();
                max_y = ((StringTokenizer)object).nextToken();
                defaultY = false;
            }
        }
        if (hashMap.containsKey("-o")) {
            System.out.println("tolerance: " + (String)hashMap.get("-o"));
            m_tolerance = (String)hashMap.get("-o");
        }
        if (hashMap.containsKey("-n")) {
            System.out.println("start_id: " + (String)hashMap.get("-n"));
            m_start_id = Integer.parseInt((String)hashMap.get("-n"));
        }
        if (hashMap.containsKey("-c")) {
            System.out.println("commit_interval: " + (String)hashMap.get("-c"));
            m_commit_interval = Integer.parseInt((String)hashMap.get("-c"));
        }
        if (hashMap.containsKey("-v")) {
            System.out.println("println_interval: " + (String)hashMap.get("-v"));
            m_println_interval = Integer.parseInt((String)hashMap.get("-v"));
        }
        if (hashMap.containsKey("-k")) {
            System.out.println("keyword_table: " + (String)hashMap.get("-k"));
            m_keyword_table = (String)hashMap.get("-k");
        }
        try {
            object = SampleShapefileToJGeomFeature.getConnection();
            Throwable throwable = null;
            try (DBFReaderJGeom dBFReaderJGeom = new DBFReaderJGeom(m_shapefileName);
                 ShapefileReaderJGeom shapefileReaderJGeom = new ShapefileReaderJGeom(m_shapefileName);){
                object.setAutoCommit(false);
                int n = shapefileReaderJGeom.getShpFileType();
                double d = shapefileReaderJGeom.getMinMeasure();
                double d2 = shapefileReaderJGeom.getMaxMeasure();
                if (d2 <= -1.0E39) {
                    d2 = Double.NaN;
                } else if (!(d2 != d || n != 11 && n != 13 && n != 15 && n != 18 || ShapefileFeatureJGeom.validateMvalue(shapefileReaderJGeom, m_srid))) {
                    d2 = Double.NaN;
                }
                double d3 = shapefileReaderJGeom.getMinZ();
                double d4 = shapefileReaderJGeom.getMaxZ();
                if (defaultX && !ShapefileFeatureJGeom.isGeodetic((OracleConnection)object, m_srid)) {
                    min_x = String.valueOf(shapefileReaderJGeom.getMinX());
                    max_x = String.valueOf(shapefileReaderJGeom.getMaxX());
                }
                if (defaultY && !ShapefileFeatureJGeom.isGeodetic((OracleConnection)object, m_srid)) {
                    min_y = String.valueOf(shapefileReaderJGeom.getMinY());
                    max_y = String.valueOf(shapefileReaderJGeom.getMaxY());
                }
                int n2 = ShapefileReaderJGeom.getShpDims(n, d2);
                dimArray = ShapefileFeatureJGeom.getDimArray(n2, m_tolerance, min_x, max_x, min_y, max_y, d3, d4, d, d2);
                dimArrayMig = ShapefileFeatureJGeom.getDimArray(n2, mg_tolerance, min_x, max_x, min_y, max_y, d3, d4, d, d2);
                if (!bl) {
                    ShapefileFeatureJGeom.prepareTableForData((OracleConnection)object, dBFReaderJGeom, m_tableName, m_idName, m_geom, m_srid, dimArray, m_keyword_table);
                } else {
                    System.out.println("Appending to existing table\n");
                }
                ShapefileFeatureJGeom.insertFeatures((OracleConnection)object, dBFReaderJGeom, shapefileReaderJGeom, m_tableName, m_idName, m_start_id, m_commit_interval, m_println_interval, m_srid, dimArrayMig);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static Path unzipWallet(Path path) throws IOException {
        Path path2 = Files.createTempDirectory("", new FileAttribute[0]);
        path2.toFile().deleteOnExit();
        byte[] byArray = new byte[1024];
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(path.toFile()));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                Throwable throwable;
                Closeable closeable;
                Object object;
                File file;
                if ("sqlnet.ora".equals(zipEntry.getName())) {
                    file = new File(path2.toFile(), "sqlnet.ora");
                    file.createNewFile();
                    file.deleteOnExit();
                    object = new PropertyResourceBundle(zipInputStream);
                    closeable = new PrintWriter(file);
                    throwable = null;
                    try {
                        for (String string : ((ResourceBundle)object).keySet()) {
                            if ("WALLET_LOCATION".equalsIgnoreCase(string)) {
                                ((PrintWriter)closeable).println("WALLET_LOCATION = (SOURCE = (METHOD = file) (METHOD_DATA = (DIRECTORY=\"" + path2.toString() + "\")))");
                                continue;
                            }
                            ((PrintWriter)closeable).println(string + " = " + ((ResourceBundle)object).getString(string));
                        }
                        ((PrintWriter)closeable).flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (closeable != null) {
                            if (throwable != null) {
                                try {
                                    ((PrintWriter)closeable).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((PrintWriter)closeable).close();
                            }
                        }
                    }
                    zipEntry = zipInputStream.getNextEntry();
                    continue;
                }
                file = SampleShapefileToJGeomFeature.newFile(path2.toFile(), zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!file.isDirectory() && !file.mkdirs()) {
                        throw new IOException("Failed to create directory " + file);
                    }
                } else {
                    object = file.getParentFile();
                    if (!((File)object).isDirectory() && !((File)object).mkdirs()) {
                        throw new IOException("Failed to create directory " + object);
                    }
                    file.createNewFile();
                    file.deleteOnExit();
                    closeable = new FileOutputStream(file);
                    throwable = null;
                    try {
                        int n;
                        while ((n = zipInputStream.read(byArray)) > 0) {
                            ((FileOutputStream)closeable).write(byArray, 0, n);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (closeable != null) {
                            if (throwable != null) {
                                try {
                                    ((FileOutputStream)closeable).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((FileOutputStream)closeable).close();
                            }
                        }
                    }
                }
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        return path2;
    }

    private static File newFile(File file, ZipEntry zipEntry) throws IOException {
        File file2 = new File(file, zipEntry.getName());
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        if (!string2.startsWith(string + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return file2;
    }

    private static OracleConnection getConnection() throws SQLException {
        String string;
        System.out.println("Connecting to Oracle Database using...");
        OracleConnection oracleConnection = null;
        DriverManager.registerDriver((Driver)new OracleDriver());
        Properties properties = null;
        if (m_wallet_dir != null) {
            System.out.println("Oracle Wallet");
            string = "jdbc:oracle:thin:@" + m_tns_alias + "?TNS_ADMIN=" + m_wallet_dir;
            properties = new Properties();
            properties.put("oracle.net.wallet_location", m_wallet_dir);
        } else if (m_tns_alias != null) {
            System.out.println("TNS Alias");
            string = "jdbc:oracle:thin:@" + m_tns_alias;
        } else if (m_sid == null || m_sid.length() == 0) {
            System.out.println("Service Name");
            string = "jdbc:oracle:thin:@(DESCRIPTION = (ADDRESS = (PROTOCOL = TCP)(HOST = " + m_host + ")(PORT = " + m_port + ")) (LOAD_BALANCE = yes) (CONNECT_DATA = (SERVER = DEDICATED)(SERVICE_NAME = " + m_svc + ")) )";
        } else {
            System.out.println("Service ID");
            string = "jdbc:oracle:thin:@ " + m_host + ":" + m_port + ":" + m_sid;
        }
        try {
            oracleConnection = m_user == null || m_password == null ? DriverManager.getConnection(string, properties).unwrap(OracleConnection.class) : DriverManager.getConnection(string, m_user, m_password).unwrap(OracleConnection.class);
        }
        catch (Exception exception) {
            if (exception.getMessage().contains("OracleWallet")) {
                System.out.println("oraclepki.jar is missing from classpath");
            } else if (exception.getMessage().contains("X509Extension")) {
                System.out.println("osdt_cert.jar is missing from classpath");
            } else if (exception.getMessage().contains("ASN1Object") || exception.getMessage().contains("AuthenticationException")) {
                System.out.println("osdt_core.jar is missing from classpath");
            } else {
                exception.printStackTrace();
            }
            System.exit(1);
        }
        return oracleConnection;
    }

    static {
        m_sid = null;
        m_svc = null;
        m_idName = null;
        m_srid = 0;
        m_geom = "geometry";
        m_keyword_table = null;
        min_x = "-180";
        min_y = "-90";
        max_x = "180";
        max_y = "90";
        m_tolerance = "0.05";
        mg_tolerance = "0.000000005";
        m_start_id = 1;
        m_commit_interval = -1;
        m_println_interval = 10;
        dimArray = null;
        dimArrayMig = null;
        defaultX = true;
        defaultY = true;
    }
}

