/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.OracleDriver;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.AdapterShapefileJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;
import oracle.spatial.util.Util;
import oracle.sql.STRUCT;

public class SampleShapefileToJGeom {
    private static String m_host = "adc2191103";
    private static String m_port = "16721";
    private static String m_sid = "shape";
    private static String m_user = "scott";
    private static String m_password = "tiger";
    private static String m_tableName;
    private static String m_shapefileName;
    private static int m_srid;
    private static String geomMetaDataTable;

    public static void main(String[] stringArray) throws Exception {
        byte[] byArray;
        Object object;
        Object object2;
        int n;
        if (stringArray.length == 2) {
            m_shapefileName = stringArray[0];
            m_tableName = stringArray[1].toUpperCase();
        } else if (stringArray.length == 1) {
            m_shapefileName = stringArray[0];
            m_tableName = stringArray[0].toUpperCase();
        } else if (stringArray.length == 3) {
            m_shapefileName = stringArray[0];
            m_tableName = stringArray[1].toUpperCase();
            m_srid = Integer.parseInt(stringArray[2]);
        } else {
            System.out.println("Parameters:");
            System.out.println("<Filename>: File name of an input Shapefile (without extension)");
            System.out.println("<Table name>: Table name for the result");
            System.out.println("[SRID]: Valid Oracle SRID for coordinate system");
            return;
        }
        System.out.println("Connecting to DB...");
        String string = "jdbc:oracle:thin:@" + m_host + ":" + m_port + ":" + m_sid;
        Connection connection = null;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            connection = DriverManager.getConnection(string, m_user, m_password);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ShapefileReaderJGeom shapefileReaderJGeom = new ShapefileReaderJGeom(m_shapefileName);
        int n2 = shapefileReaderJGeom.getShpFileType();
        double d = shapefileReaderJGeom.getMinMeasure();
        double d2 = shapefileReaderJGeom.getMaxMeasure();
        if (d2 <= -1.0E39) {
            d2 = Double.NaN;
        } else if (d2 == d && (n2 == 11 || n2 == 13 || n2 == 15 || n2 == 18)) {
            n = 0;
            object2 = new AdapterShapefileJGeom();
            object = null;
            byArray = shapefileReaderJGeom.getGeometryBytes(0);
            try {
                object = ((AdapterShapefileJGeom)object2).importGeometry(byArray, m_srid);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
            if (object != null) {
                n = ShapefileReaderJGeom.shpMval ? 1 : 0;
            }
            if (n == 0) {
                d2 = Double.NaN;
            }
        }
        n = ShapefileReaderJGeom.getShpDims(shapefileReaderJGeom.getShpFileType(), d2);
        SampleShapefileToJGeom.prepareTableForData(connection, n, d2, shapefileReaderJGeom);
        object2 = "INSERT INTO " + Util.enquoteTableName(connection, m_tableName) + " VALUES(?, ?)";
        object = connection.prepareStatement((String)object2);
        for (int i = 0; i < shapefileReaderJGeom.numRecords(); ++i) {
            System.out.println("Converting geometry #" + (i + 1));
            byArray = shapefileReaderJGeom.getGeometryBytes(i);
            AdapterShapefileJGeom adapterShapefileJGeom = new AdapterShapefileJGeom();
            JGeometry jGeometry = adapterShapefileJGeom.importGeometry(byArray, m_srid);
            STRUCT sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)connection);
            int n3 = i + 1;
            object.setInt(1, n3);
            object.setObject(2, sTRUCT);
            object.executeUpdate();
        }
        shapefileReaderJGeom.closeShapefile();
        object.close();
        connection.close();
        System.out.println("Done.");
    }

    protected static void prepareTableForData(Connection connection, int n, double d, ShapefileReaderJGeom shapefileReaderJGeom) {
        String string;
        System.out.println("Dropping old table...");
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        try {
            statement = connection.createStatement();
            string = "DROP TABLE " + Util.enquoteTableName(connection, m_tableName);
            statement.executeUpdate(string);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        try {
            string = "DELETE FROM " + geomMetaDataTable + " WHERE table_name = ?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, m_tableName);
            preparedStatement.executeUpdate(string);
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        try {
            System.out.println("Creating new table...");
            statement = connection.createStatement();
            string = "CREATE TABLE " + Util.enquoteTableName(connection, m_tableName) + " (gid NUMBER(38), geometry MDSYS.SDO_GEOMETRY)";
            statement.executeUpdate(string);
            statement.close();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
        try {
            if (n == 2 || n == 0) {
                string = "INSERT INTO " + Util.enquoteTableName(connection, geomMetaDataTable) + " VALUES (?, 'GEOMETRY', MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', -180, 180, 0.005), MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, 0.005)), ?)";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, m_tableName);
                preparedStatement.setInt(2, m_srid);
                preparedStatement.executeUpdate(string);
                preparedStatement.close();
            } else if (n == 3 && Double.isNaN(d)) {
                string = "INSERT INTO " + Util.enquoteTableName(connection, geomMetaDataTable) + " VALUES (?, 'GEOMETRY', MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', -180, 180, 0.005), MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, 0.005), MDSYS.SDO_DIM_ELEMENT('Z', ?, ?, 0.005)), ?)";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, m_tableName);
                preparedStatement.setDouble(2, shapefileReaderJGeom.getMinZ());
                preparedStatement.setDouble(3, shapefileReaderJGeom.getMaxZ());
                preparedStatement.setInt(4, m_srid);
                preparedStatement.executeUpdate(string);
                preparedStatement.close();
            } else if (n == 3) {
                string = "INSERT INTO " + Util.enquoteTableName(connection, geomMetaDataTable) + " VALUES (?, 'GEOMETRY', MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', -180, 180, 0.005), MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, 0.005), MDSYS.SDO_DIM_ELEMENT('M', ?, ?, 0.005)), ?)";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, m_tableName);
                preparedStatement.setDouble(2, shapefileReaderJGeom.getMinMeasure());
                preparedStatement.setDouble(3, d);
                preparedStatement.setInt(4, m_srid);
                preparedStatement.executeUpdate(string);
                preparedStatement.close();
            } else if (n == 4) {
                string = "INSERT INTO " + Util.enquoteTableName(connection, geomMetaDataTable) + " VALUES (?, 'GEOMETRY', MDSYS.SDO_DIM_ARRAY(MDSYS.SDO_DIM_ELEMENT('X', -180, 180, 0.005), MDSYS.SDO_DIM_ELEMENT('Y', -90, 90, 0.005), MDSYS.SDO_DIM_ELEMENT('Z', ?, ?, 0.005), MDSYS.SDO_DIM_ELEMENT('M', ?, ?, 0.005)), ?)";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, m_tableName);
                preparedStatement.setDouble(2, shapefileReaderJGeom.getMinZ());
                preparedStatement.setDouble(3, shapefileReaderJGeom.getMaxZ());
                preparedStatement.setDouble(4, shapefileReaderJGeom.getMinMeasure());
                preparedStatement.setDouble(5, d);
                preparedStatement.setInt(6, m_srid);
                preparedStatement.executeUpdate(string);
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
        }
    }

    static {
        m_srid = 0;
        geomMetaDataTable = "user_sdo_geom_metadata";
    }
}

