/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.spatial.util.Util;
import oracle.sql.STRUCT;

public class Pc2Dem {
    private static OraclePreparedStatement preparePcQuery(oracle.jdbc.OracleConnection oracleConnection, String string, STRUCT sTRUCT, String string2, long l) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement;
        if (string2.equals("R-tree") || string2.equals("Hilbert R-tree")) {
            oraclePreparedStatement = (OraclePreparedStatement)oracleConnection.prepareStatement("select\n  query_points.x,\n  query_points.y,\n  query_points.z\nfrom\n  table(\n    sdo_pc_pkg.clip_pc(\n      inp           => :inp,\n      ind_dim_qry   => sdo_geometry(\n                         2003,\n                         :srid,\n                         null,\n                         sdo_elem_info_array(1, 1003, 3),\n                         sdo_ordinate_array(:xmin, :ymin, :xmax, :ymax)),\n      other_dim_qry => null,\n      qry_min_res   => 1,\n      qry_max_res   => 1)) query_blocks,\n  table(\n    sdo_util.getvertices(\n      geometry => sdo_pc_pkg.to_geometry(\n                    pts        => query_blocks.points,\n                    num_pts    => query_blocks.num_points,\n                    pc_tot_dim => 3,\n                    srid       => null))) query_points");
            oraclePreparedStatement.setSTRUCT(1, sTRUCT);
            oraclePreparedStatement.setLong(2, l);
        } else if (string2.equals("Flat")) {
            oraclePreparedStatement = (OraclePreparedStatement)oracleConnection.prepareStatement("select\n  val_d1,\n  val_d2,\n  val_d3\nfrom\n  " + string + "\nwhere\n  val_d1 between :xmin and :xmax and\n  val_d2 between :ymin and :ymax");
        } else {
            throw new RuntimeException("PC2DEM only supports blocked and flat model.");
        }
        return oraclePreparedStatement;
    }

    private static int[] getPcQueryParamStartPos(String string) {
        if (string.equals("R-tree") || string.equals("Hilbert R-tree")) {
            return new int[]{3, 4, 5, 6};
        }
        if (string.equals("Flat")) {
            return new int[]{1, 3, 2, 4};
        }
        throw new RuntimeException("PC2DEM only supports blocked and flat model.");
    }

    private static ResultSet getDemBlockResultSet(oracle.jdbc.OracleConnection oracleConnection, String string, long l) throws SQLException {
        Statement statement = oracleConnection.createStatement(1005, 1008);
        return statement.executeQuery("select\n  rowblocknumber,\n  columnblocknumber,\n  rasterblock\nfrom\n  " + Util.enquoteTableName((Connection)oracleConnection, string) + "\nwhere\n  rasterid = " + l + " and\n  pyramidlevel = 0\norder by\n  rowblocknumber,\n  columnblocknumber");
    }

    public static void createDemBlocks(STRUCT sTRUCT, String string, String string2, String string3, long l, long l2, double d, double d2, double d3, double d4, long l3, long l4, double d5, double d6, int n, int n2) throws IOException, SQLException {
        long l5 = System.currentTimeMillis();
        double d7 = d3;
        double d8 = d2;
        double[][] dArray = new double[n2][n];
        OracleConnection oracleConnection = sTRUCT.getInternalConnection();
        OraclePreparedStatement oraclePreparedStatement = Pc2Dem.preparePcQuery((oracle.jdbc.OracleConnection)oracleConnection, string2, sTRUCT, string3, l2);
        ResultSet resultSet = Pc2Dem.getDemBlockResultSet((oracle.jdbc.OracleConnection)oracleConnection, string, l);
        long l6 = System.currentTimeMillis();
        System.out.println("Times: Init: " + (l6 - l5) + "ms.");
        while (resultSet.next()) {
            long l7 = System.currentTimeMillis();
            long l8 = resultSet.getLong(1) + 1L;
            long l9 = resultSet.getLong(2) + 1L;
            double d9 = d + (double)((l9 - 1L) * (long)n2) * d6;
            double d10 = d4 - (double)((l8 - 1L) * (long)n) * d5;
            double d11 = d + (double)((l9 - 0L) * (long)n2) * d6;
            double d12 = d4 - (double)((l8 - 0L) * (long)n) * d5;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    dArray[j][i] = -1.7976931348623157E308;
                }
            }
            int[] nArray = Pc2Dem.getPcQueryParamStartPos(string3);
            oraclePreparedStatement.setDouble(nArray[0], d9);
            if (d12 >= d8) {
                oraclePreparedStatement.setDouble(nArray[1], d12);
            } else {
                oraclePreparedStatement.setDouble(nArray[1], d8);
            }
            if (d11 <= d7) {
                oraclePreparedStatement.setDouble(nArray[2], d11);
            } else {
                oraclePreparedStatement.setDouble(nArray[2], d7);
            }
            oraclePreparedStatement.setDouble(nArray[3], d10);
            ResultSet resultSet2 = oraclePreparedStatement.executeQuery();
            int n3 = 0;
            int n4 = 1000000;
            int n5 = -1000000;
            int n6 = 1000000;
            int n7 = -1000000;
            long l10 = 0L;
            while (resultSet2.next()) {
                ++l10;
                double d13 = resultSet2.getDouble(1);
                double d14 = resultSet2.getDouble(2);
                double d15 = resultSet2.getDouble(3);
                int n8 = (int)Math.floor((d13 - d) / d6);
                int n9 = (int)Math.floor((d4 - d14) / d5);
                if (n8 < 0) {
                    n8 = 0;
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                if (n8 < n4) {
                    n4 = n8;
                }
                if (n8 > n5) {
                    n5 = n8;
                }
                if (n9 < n6) {
                    n6 = n9;
                }
                if (n9 > n7) {
                    n7 = n9;
                }
                n8 %= n2;
                n9 %= n;
                ++n3;
                try {
                    if (!(d15 > dArray[n8][n9])) continue;
                    dArray[n8][n9] = d15;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("Trying to access pixel " + n8 + ", " + n9);
                    System.out.println("Block Size " + n2 + ", " + n);
                    throw new RuntimeException(arrayIndexOutOfBoundsException);
                }
            }
            resultSet2.close();
            long l11 = System.currentTimeMillis();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d16 = dArray[j][i];
                    if (d16 == -1.7976931348623157E308) {
                        d16 = Pc2Dem.interpolateValue(dArray, j, i);
                    }
                    dataOutputStream.writeFloat((float)d16);
                }
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            resultSet.updateBlob(3, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            resultSet.updateRow();
            long l12 = System.currentTimeMillis();
            System.out.println("Times: PC Query: " + (l11 - l7) + "ms, DEM Block: " + (l12 - l11) + "ms. #Pts: " + l10);
        }
        resultSet.close();
    }

    private static double interpolateValue(double[][] dArray, int n, int n2) {
        for (int i = 1; i < 10; ++i) {
            int n3 = n - i;
            int n4 = n + i;
            int n5 = n2 - i;
            int n6 = n2 + i;
            if (n3 < 0) {
                n3 = 0;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 >= dArray.length) {
                n4 = dArray.length - 1;
            }
            if (n6 >= dArray[0].length) {
                n6 = dArray[0].length - 1;
            }
            double d = 0.0;
            int n7 = 0;
            for (int j = n3; j <= n4; ++j) {
                for (int k = n5; k <= n6; ++k) {
                    if (dArray[j][k] == -1.7976931348623157E308) continue;
                    d += dArray[j][k];
                    ++n7;
                }
            }
            if (n7 <= 0) continue;
            return d / (double)n7;
        }
        return 0.0;
    }
}

