/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.JDBCExtensionInterface;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.xdb.XMLType;

public class JDBCAdapter {
    private static JDBCExtensionInterface jdbcExtension = new DefaultJDBCExtension();

    private JDBCAdapter() {
    }

    public static void initialize(JDBCExtensionInterface jDBCExtensionInterface) {
        if (jDBCExtensionInterface == null) {
            return;
        }
        jdbcExtension = jDBCExtensionInterface;
    }

    public static OracleConnection getOracleConnection(Connection connection) throws SQLException {
        return jdbcExtension.getOracleConnection(connection);
    }

    public static void clearStatementCache(Connection connection) throws SQLException {
        jdbcExtension.clearStatementCache(connection);
    }

    public static JGeometry getJGeometry(Object object) throws SQLException {
        return jdbcExtension.getJGeometry(object);
    }

    public static Datum[] getOracleAttributes(Object object) throws SQLException {
        return jdbcExtension.getOracleAttributes(object);
    }

    public static StructDescriptor getStructDescriptor(Object object) throws SQLException {
        return jdbcExtension.getStructDescriptor(object);
    }

    public static Datum[] getOracleArray(Object object) throws SQLException {
        return jdbcExtension.getOracleArray(object);
    }

    public static ArrayDescriptor getArrayDescriptor(Object object) throws SQLException {
        return jdbcExtension.getArrayDescriptor(object);
    }

    public static void closeOracleConnection(OracleConnection oracleConnection) throws SQLException {
        jdbcExtension.closeOracleConnection(oracleConnection);
    }

    public static DataSource[] getDataSource(String ... stringArray) {
        return jdbcExtension.getDataSource(stringArray);
    }

    public static XMLType getXMLType(Object object) throws SQLException {
        return jdbcExtension.getXMLType(object);
    }

    private static class DefaultJDBCExtension
    implements JDBCExtensionInterface {
        private DefaultJDBCExtension() {
        }

        @Override
        public OracleConnection getOracleConnection(Connection connection) throws SQLException {
            if (connection == null) {
                throw new IllegalArgumentException();
            }
            return (OracleConnection)connection;
        }

        @Override
        public void clearStatementCache(Connection connection) throws SQLException {
        }

        @Override
        public JGeometry getJGeometry(Object object) throws SQLException {
            return JGeometry.loadJS((Struct)((Struct)object));
        }

        @Override
        public Datum[] getOracleAttributes(Object object) throws SQLException {
            return ((STRUCT)object).getOracleAttributes();
        }

        @Override
        public StructDescriptor getStructDescriptor(Object object) throws SQLException {
            return ((STRUCT)object).getDescriptor();
        }

        @Override
        public Datum[] getOracleArray(Object object) throws SQLException {
            return ((ARRAY)object).getOracleArray();
        }

        @Override
        public ArrayDescriptor getArrayDescriptor(Object object) throws SQLException {
            return ((ARRAY)object).getDescriptor();
        }

        @Override
        public void closeOracleConnection(OracleConnection oracleConnection) throws SQLException {
            if (oracleConnection == null) {
                return;
            }
            oracleConnection.close();
        }

        @Override
        public DataSource[] getDataSource(String ... stringArray) {
            InitialContext initialContext = null;
            DataSource[] dataSourceArray = new DataSource[stringArray.length];
            try {
                initialContext = new InitialContext();
                for (int i = 0; i < stringArray.length; ++i) {
                    NamingEnumeration<NameClassPair> namingEnumeration = initialContext.list("");
                    while (namingEnumeration.hasMore()) {
                        NameClassPair nameClassPair = namingEnumeration.next();
                        if (!nameClassPair.getName().equals(stringArray[i])) continue;
                        dataSourceArray[i] = (DataSource)initialContext.lookup(nameClassPair.getName());
                    }
                }
            }
            catch (NamingException namingException) {
                throw new IllegalStateException("DataSource " + stringArray + " not found");
            }
            finally {
                if (initialContext != null) {
                    try {
                        initialContext.close();
                    }
                    catch (NamingException namingException) {}
                }
            }
            return dataSourceArray;
        }

        @Override
        public XMLType getXMLType(Object object) throws SQLException {
            return XMLType.createXML((OPAQUE)((OPAQUE)object));
        }
    }
}

