/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class DBMS {
    private CallableStatement OutputDisableStmt;
    private CallableStatement OutputEnableStmt;
    private int OutputMaxByte = 3200;
    private CallableStatement OutputShowStmt;

    public void DbmsOutputPrepare(Connection connection) throws SQLException {
        this.OutputEnableStmt = connection.prepareCall("begin dbms_output.enable(:1); end;");
        this.OutputDisableStmt = connection.prepareCall("begin dbms_output.disable; end;");
        this.OutputShowStmt = connection.prepareCall("declare   l_line varchar2(255);   l_done number;   l_buffer long; begin   loop     exit when length(l_buffer)+255 > :maxbytes OR l_done = 1;     dbms_output.get_line( l_line, l_done );     l_buffer := l_buffer || l_line || chr(10);   end loop;   :done := l_done;   :buffer := l_buffer; end;");
    }

    public void DbmsOutputEnable(int n) throws SQLException {
        this.OutputEnableStmt.setInt(1, n);
        this.OutputEnableStmt.executeUpdate();
    }

    public void DbmsOutputDisable() throws SQLException {
        this.OutputDisableStmt.executeUpdate();
    }

    public void DbmsOutputShow() throws SQLException {
        int n = 0;
        this.OutputShowStmt.registerOutParameter(2, 4);
        this.OutputShowStmt.registerOutParameter(3, 12);
        do {
            this.OutputShowStmt.setInt(1, this.OutputMaxByte);
            this.OutputShowStmt.executeUpdate();
            System.out.print(this.OutputShowStmt.getString(3));
        } while ((n = this.OutputShowStmt.getInt(2)) != 1);
    }

    public void DbmsOutputClose() throws SQLException {
        this.OutputEnableStmt.close();
        this.OutputDisableStmt.close();
        this.OutputShowStmt.close();
    }
}

