/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.OracleConnection;

public class Contour {
    public static Array findContourPoints(Blob blob, int n, double d) throws SQLException, IOException {
        double[] dArray = new double[3 * n];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        int n3 = (int)(blob.length() / (long)n);
        InputStream inputStream = blob.getBinaryStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        for (int i = 0; i < n; ++i) {
            double d5 = dataInputStream.readDouble();
            double d6 = dataInputStream.readDouble();
            double d7 = dataInputStream.readDouble();
            dataInputStream.skipBytes(n3 - 24);
            if (d == d7) {
                dArray[n2++] = d5;
                dArray[n2++] = d6;
                dArray[n2++] = d7;
            } else if (i > 0 && (d4 < d && d < d7 || d4 > d && d > d7)) {
                double d8 = (d - d4) / (d7 - d4);
                dArray[n2++] = d2 + (d5 - d2) * d8;
                dArray[n2++] = d3 + (d6 - d3) * d8;
                dArray[n2++] = d4 + (d7 - d4) * d8;
            }
            d2 = d5;
            d3 = d6;
            d4 = d7;
        }
        dataInputStream.close();
        bufferedInputStream.close();
        inputStream.close();
        return ((OracleConnection)DriverManager.getConnection("jdbc:default:connection:")).createARRAY("MDSYS.SDO_ORDINATE_ARRAY", (Object)Arrays.copyOf(dArray, n2));
    }
}

