/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.security;

import java.util.Random;
import oracle.spatial.security.OHSH;
import oracle.spatial.security.SeedGenerator;

public final class SecureRandom
extends Random {
    private static final int DIGEST_SIZE = 20;
    private static final int MAX_SEED_LEN = 256;
    private static final int MY_SEED_LEN = 20;
    private static final int SEED_BOUNDARY = 236;
    private static final int SEED_ENTROPY = Short.MIN_VALUE;
    private static final int SEED_CYCLE = 32768;
    private static final int MASK_ENTROPY = -524288;
    private static final int MASK_CYCLE = 524288;
    private static boolean _jce;
    private static byte[] _masterSeed;
    private static byte[] _mask;
    private static int _rem;
    private static SeedGenerator _sg;
    private static boolean _mixin;
    private static int _mixCount;
    private byte[] _cache;
    private int _cursor;
    private byte[] _state;
    private int _current;
    private OHSH _hash;
    private int _count;
    private Random _myrnd;
    private int _mixNext = 1;
    private boolean _mixDone = false;
    private java.security.SecureRandom _real = null;

    public static final synchronized boolean setSunLoops(int n) {
        if (n < 0) {
            return false;
        }
        if (_sg != null) {
            return false;
        }
        _mixCount = n;
        return true;
    }

    public static final boolean forceJCA(boolean bl) {
        _jce = bl;
        if (_jce) {
            try {
                _jce = java.security.SecureRandom.getInstance("SHA1PRNG") != null;
            }
            catch (Throwable throwable) {
                _jce = false;
            }
        }
        return _jce;
    }

    @Override
    protected final int next(int n) {
        int n2 = 0;
        if (n <= 0) {
            return n2;
        }
        if (n > 32) {
            n = 32;
        }
        if (this._real != null) {
            return -1 >> 32 - n | this._real.nextInt();
        }
        if (!this._mixDone) {
            this.checkMix((n + 7) / 8);
        }
        if ((n + 7) / 8 > this._cache.length - this._cursor) {
            this.engineNextBytes(this._cache, 0, 20);
        }
        switch (n % 8) {
            case 7: {
                n2 |= 0x7F & this._cache[this._cursor++];
                break;
            }
            case 6: {
                n2 |= 0x3F & this._cache[this._cursor++];
                break;
            }
            case 5: {
                n2 |= 0x1F & this._cache[this._cursor++];
                break;
            }
            case 4: {
                n2 |= 0xF & this._cache[this._cursor++];
                break;
            }
            case 3: {
                n2 |= 7 & this._cache[this._cursor++];
                break;
            }
            case 2: {
                n2 |= 3 & this._cache[this._cursor++];
                break;
            }
            case 1: {
                n2 |= 1 & this._cache[this._cursor++];
                break;
            }
        }
        int n3 = n / 8;
        while (n3-- > 0) {
            n2 = n2 << 8 | 0xFF & this._cache[this._cursor++];
        }
        return n2;
    }

    @Override
    public final void nextBytes(byte[] byArray) {
        if (this._real != null) {
            this._real.nextBytes(byArray);
        } else {
            this.engineNextBytes(byArray, 0, byArray.length);
        }
    }

    @Override
    public final void setSeed(long l) {
        if (this._real != null) {
            this._real.setSeed(l);
        } else {
            byte[] byArray = new byte[32];
            int n = 0;
            while (n < byArray.length && l != 0L) {
                byArray[n++] = (byte)l;
                l >>= 8;
            }
            this.setSeed(byArray);
        }
    }

    public final void setSeed(byte[] byArray) {
        if (this._real != null) {
            this._real.setSeed(byArray);
        } else {
            this.engineSetSeed(byArray);
        }
    }

    public SecureRandom() {
        if (_jce) {
            try {
                this._real = java.security.SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception exception) {
                this._real = null;
            }
        }
    }

    private static final synchronized boolean mixMask() {
        if (_mixin) {
            return true;
        }
        if (!_sg.isDone()) {
            return false;
        }
        for (int i = 1; i < _mask.length; ++i) {
            int n = _sg.nextInt(i + 1);
            byte by = _mask[n];
            SecureRandom._mask[n] = _mask[i];
            SecureRandom._mask[i] = by;
        }
        _rem = 0;
        _mixin = true;
        return true;
    }

    private static final synchronized void getSeedChunk(int n, byte[] byArray) {
        byte by = 0;
        if (_rem == 0) {
            if (_sg == null) {
                _sg = new SeedGenerator(_mixCount);
            }
            _sg.nextBytes(_masterSeed);
            _rem = _mask.length;
        }
        if ((n %= _rem) < 0) {
            n += _rem;
        }
        by = _mask[n];
        SecureRandom._mask[n] = _mask[--_rem];
        SecureRandom._mask[SecureRandom._rem] = by;
        System.arraycopy(_masterSeed, 0xFF & by, byArray, 0, byArray.length);
    }

    private final void checkMix(int n) {
        if (this._cache == null) {
            this.init(null);
        }
        if (this._mixDone || this._count + n < this._mixNext) {
            return;
        }
        this._mixDone = SecureRandom.mixMask();
        if (this._mixDone) {
            this.init(null);
            return;
        }
        if ((this._mixNext <<= 1) <= 0) {
            this._mixDone = true;
            return;
        }
    }

    private final void init(byte[] byArray) {
        if (this._hash == null) {
            this.reset();
        }
        this._cursor = 20;
        SecureRandom.getSeedChunk(~this._count ^ this._myrnd.nextInt(), this._cache);
        this._hash.update(this._cache);
        if (byArray != null) {
            this._hash.update(byArray);
        }
        if (this._state == null) {
            this._state = new byte[20];
            this._hash.digest(this._state, 0, this._state.length);
        } else {
            this._hash.digest(this._cache, 0, this._cache.length);
            this.mixState(this._state, this._cache, 0);
        }
    }

    private final void engineSetSeed(byte[] byArray) {
        this.init(byArray);
    }

    private final void engineNextBytes(byte[] byArray, int n, int n2) {
        if (!this._mixDone) {
            this.checkMix(n2);
        }
        if (byArray == this._cache) {
            this._cursor = 0;
        } else if (n2 >= 20) {
            this._cursor = 20;
        } else {
            if (n2 > this._cache.length - this._cursor) {
                this.engineNextBytes(this._cache, 0, this._cache.length);
            }
            System.arraycopy(this._cache, this._cursor, byArray, n, n2);
            this._cursor += n2;
            return;
        }
        int n3 = this._count + n2;
        if (n2 > 32768 || (n3 & Short.MIN_VALUE) != (this._count & Short.MIN_VALUE)) {
            if (n2 > 524288 || (n3 & 0xFFF80000) != (this._count & 0xFFF80000)) {
                this._hash.update(_mask);
            } else {
                this.init(null);
                if (byArray == this._cache) {
                    this._cursor = 0;
                }
            }
        }
        this._count += n2;
        int n4 = 0;
        while (n2 >= 20) {
            this._hash.update(this._state);
            n4 = this._hash.digest(byArray, n, n2);
            this.mixState(this._state, byArray, n);
            n += n4;
            n2 -= n4;
        }
        if (n2 > 0) {
            this.engineNextBytes(byArray, n, n2);
        }
    }

    private final void reset() {
        if (this._hash == null) {
            this._hash = new OHSH();
        } else {
            this._hash.reset();
        }
        if (this._myrnd == null) {
            this._myrnd = new Random();
        }
        if (this._cache == null) {
            this._cache = new byte[20];
        }
        this._cursor = 20;
    }

    private final void mixState(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 1;
        boolean bl = false;
        int n3 = 20;
        while (n3-- > 0) {
            int n4;
            byte by;
            bl |= byArray[n3] != (by = (byte)(n4 = byArray[n3] + byArray2[n++] + n2));
            byArray[n3] = by;
            n2 = n4 >> 8;
        }
        if (!bl) {
            byArray[0] = (byte)(byArray[0] + 1);
        }
    }

    static {
        _mixin = false;
        _mixCount = 1;
        _jce = false;
        try {
            String string = java.security.SecureRandom.getInstance("SHA1PRNG").getProvider().getName();
            _jce = string.startsWith("oracle.");
        }
        catch (Throwable throwable) {
            _jce = false;
        }
        if (!_jce) {
            _masterSeed = new byte[256];
            _mask = new byte[236];
            _rem = 0;
            int n = 236;
            while (n-- > 0) {
                SecureRandom._mask[n] = (byte)n;
            }
        }
    }
}

