/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editors;

import java.awt.Component;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.gui.base.inspector.editors.AbstractSimplePropretyEditor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.grammar.GrammarUtils;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.model.task.ReadOnlyTask;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XsdIdEditor
extends AbstractSimplePropretyEditor<String>
implements ContextualPropertyEditor {
    private XmlKey _key;
    private XmlContext _context;
    private Node _node;
    private Node _ownerNode;

    public XsdIdEditor() {
        super(String.class);
    }

    public void clearContext() {
        this._setContext(null, null, null, null);
    }

    public void setContext(PropertyEditorContext context) {
        this._setContext(context.getXmlContext(), context.getKey(), context.getNode(), context.getOwnerNode());
    }

    protected String getJavaInitializationStringImpl(String value) {
        return value;
    }

    public Component getCustomEditor() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    protected String getStringForValue(String value) throws IllegalArgumentException {
        return value;
    }

    protected String getValueForString(String text) throws IllegalArgumentException {
        if (text == null || "".equals(text)) {
            return null;
        }
        if (!this.checkUnique(this._context, text)) {
            throw new IllegalArgumentException(this._context.getTranslatedString("XSDID_EDITOR.DUPLICATE_ID"));
        }
        return text;
    }

    protected boolean checkUnique(final XmlContext xmlContext, final String newId) {
        Boolean isUnique = (Boolean)new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                if (!XsdIdEditor.this._isIdUniqueWithinElementAndChildren(xmlContext.getGrammarResolver(), null, model.getDocument().getDocumentElement(), newId)) {
                    return false;
                }
                return true;
            }
        }.run((AbstractModel)xmlContext.getSourceModel());
        return isUnique;
    }

    private boolean _isIdUniqueWithinElementAndChildren(GrammarResolver resolver, ElementDef parentElementDef, Element currentElement, String newId) {
        if (currentElement == null) {
            return true;
        }
        ElementDef currentDef = GrammarUtils.getElementDef((GrammarResolver)resolver, (ElementDef)parentElementDef, (Element)currentElement, (boolean)false);
        if (currentDef != null && !this.isIdUniqueWithinAttributes(currentElement, currentDef, newId)) {
            return false;
        }
        for (Node child = currentElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!DomUtils.isElement((Node)child) || this._isIdUniqueWithinElementAndChildren(resolver, currentDef, (Element)child, newId)) continue;
            return false;
        }
        return true;
    }

    private boolean isIdUniqueWithinAttributes(Element element, ElementDef elementDef, String newId) {
        NamedNodeMap attrMap;
        String currAttrName = "";
        if (this._key.getNodeType() == 2) {
            String nodeLocalName = element.getLocalName();
            String nodeNamespace = element.getNamespaceURI();
            if (this._ownerNode != null) {
                QualifiedName attributeQualifiedName;
                String currNodeName = this._ownerNode.getLocalName();
                String currNodeNamespace = this._ownerNode.getNamespaceURI();
                if (nodeLocalName.equals(currNodeName) && nodeNamespace.equals(currNodeNamespace) && (attributeQualifiedName = this._key.getAttributeQName()) != null) {
                    currAttrName = attributeQualifiedName.getName();
                }
            }
        }
        if ((attrMap = element.getAttributes()) != null) {
            int length = attrMap.getLength();
            for (int i = 0; i < length; ++i) {
                SimpleType simpleType;
                String attrLocalName;
                Attr currentAttr = (Attr)attrMap.item(i);
                String attrNamespace = currentAttr.getNamespaceURI();
                AttributeDef attributeDef = elementDef.getAttributeDefByName(attrNamespace, attrLocalName = DomUtils.getLocalName((Node)currentAttr));
                if (attributeDef == null || (simpleType = attributeDef.getType()) == null) continue;
                String attributeValue = currentAttr.getValue();
                if (attrLocalName.compareTo(currAttrName) == 0 || !TypeUtils.isIdType((SimpleType)simpleType) || !attributeValue.equals(newId)) continue;
                return false;
            }
        }
        return true;
    }

    private void _setContext(XmlContext context, XmlKey key, Node node, Node ownerNode) {
        this._key = key;
        this._context = context;
        this._node = node;
        this._ownerNode = ownerNode;
    }
}

