/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.base.inspector.editors.AbstractSimplePropretyEditor;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.model.metadata.PropertyEditorContext;

public class MultiLineEditor
extends AbstractSimplePropretyEditor<String>
implements ContextualPropertyEditor {
    private ActualMultiLineEditor _editor;
    private XmlContext _context;

    public MultiLineEditor() {
        super(String.class);
    }

    public Component getCustomEditor() {
        if (this._editor == null) {
            this._editor = new ActualMultiLineEditor();
        }
        return this._editor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void clearContext() {
        this._context = null;
    }

    public void setContext(PropertyEditorContext context) {
        this._context = context.getXmlContext();
    }

    protected String getValueForString(String string) throws IllegalArgumentException {
        return string;
    }

    protected String getStringForValue(String value) throws IllegalArgumentException {
        return value;
    }

    public XmlContext getContext() {
        return this._context;
    }

    class ActualMultiLineEditor
    extends JPanel
    implements VetoableChangeListener {
        private JTextArea _text;

        ActualMultiLineEditor() {
            this._init();
        }

        private void _init() {
            this.setLayout(new BorderLayout(3, 3));
            this._text = new JTextArea();
            JScrollPane scrollPane = new JScrollPane(this._text);
            scrollPane.setPreferredSize(new Dimension(100, 150));
            this.add("Center", scrollPane);
            String valueString = MultiLineEditor.this.getContext() != null ? MultiLineEditor.this.getContext().getTranslatedString("VALUE_LABEL") : "&Value:";
            JLabel label = new JLabel(StringUtils.stripMnemonic((String)valueString));
            label.setLabelFor(this._text);
            label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)valueString));
            this.add("North", label);
            HelpUtils.setHelpID((JComponent)this, (String)"f1_multieditor_html");
            this._text.setText(MultiLineEditor.this.getAsText());
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                MultiLineEditor.this.setValue(this._text.getText());
            }
        }
    }
}

