/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

final class XmlJTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Color inactiveBackgroundSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
    private Color inactiveTextSelectionColor;
    private boolean treeHasFocus;

    public XmlJTreeCellRenderer() {
        if (this.inactiveBackgroundSelectionColor == null) {
            this.inactiveBackgroundSelectionColor = this.backgroundSelectionColor;
        }
        this.inactiveTextSelectionColor = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground");
        if (this.inactiveTextSelectionColor == null) {
            this.inactiveTextSelectionColor = this.textSelectionColor;
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.treeHasFocus = tree.hasFocus();
        return this;
    }

    @Override
    public Color getBackgroundSelectionColor() {
        return this.treeHasFocus ? super.getBackgroundSelectionColor() : this.inactiveBackgroundSelectionColor;
    }

    @Override
    public Color getTextSelectionColor() {
        return this.treeHasFocus ? super.getTextSelectionColor() : this.inactiveTextSelectionColor;
    }
}

