/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineToolTip;
import oracle.bali.xml.gui.base.explorer.XmlTreeModel;
import oracle.bali.xml.gui.swing.explorer.SavedExpansionState;
import oracle.bali.xml.gui.swing.explorer.SwingExplorerGui;
import oracle.bali.xml.gui.swing.explorer.XmlJTreeCellRenderer;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.task.ReadOnlyTask;
import oracle.javatools.ui.ExpansionTreeTip;
import org.w3c.dom.Node;

public class XmlJTree
extends JTree {
    private SwingExplorerGui _gui;
    private SavedExpansionState _rootSavedExpansionState;
    private ExpansionTreeTip _expansionTip;

    protected XmlJTree(SwingExplorerGui gui) {
        if (gui == null) {
            throw new IllegalArgumentException("Gui required");
        }
        this.enableEvents(48L);
        this._gui = gui;
        this._gui.__getHelper().attachMouseAndKeyboardSupport(this);
        this._expansionTip = new ExpansionTreeTip((JTree)this);
        this.setCellRenderer(new XmlJTreeCellRenderer());
    }

    public void dispose() {
        this._gui = null;
        this.setLeadSelectionPath(null);
        this.setAnchorSelectionPath(null);
    }

    @Override
    public JToolTip createToolTip() {
        return new MultiLineToolTip();
    }

    protected final SwingExplorerGui getGui() {
        return this._gui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        if (this._gui == null) {
            return;
        }
        if (this._gui.getGuiContext().isDisposed()) {
            return;
        }
        XmlTreeModel xmlTreeModel = this._gui.getTreeModel();
        if (xmlTreeModel == null) {
            return;
        }
        if (xmlTreeModel.getGui() == null) {
            return;
        }
        XmlView view = this._gui.getView();
        view.acquireReadLock();
        try {
            Boolean updateInProgress = false;
            if (view.getBaseModel().isInTransaction() && view.getBaseModel().getDomModel().hasModifications()) {
                updateInProgress = true;
            }
            if (this._gui == null) {
                return;
            }
            if (this._gui.isModelInvalidated()) {
                return;
            }
            if (!updateInProgress.booleanValue()) {
                this._gui.paintBackground(this, g);
                super.paintComponent(g);
                if (this._gui != null) {
                    this._gui.paintSelection(this, g);
                }
            }
        }
        finally {
            view.releaseReadLock();
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        this._gui.__getHelper().processMouseMotionEvent(this, e);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        this._gui.__getHelper().processMouseEvent(this, e);
    }

    void __regularProcessMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    void __regularProcessMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
    }

    public void expandParentNode(final Node parentNode) {
        new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                XmlTreeModel xmlTreeModel = (XmlTreeModel)XmlJTree.this.getModel();
                XmlJTree.this.expandPath(xmlTreeModel.getPathForDomElement(parentNode));
                int childCount = xmlTreeModel.getChildCount((Object)parentNode);
                for (int i = 0; i < childCount; ++i) {
                    Node child = (Node)xmlTreeModel.getChild((Object)parentNode, i);
                    if (xmlTreeModel.isLeaf((Object)child)) continue;
                    XmlJTree.this.expandPath(xmlTreeModel.getPathForDomElement(child));
                }
                return true;
            }
        }.run((AbstractModel)this._gui.getView());
    }

    public void expandAllBelow(Node parentNode) {
        XmlTreeModel xmlTreeModel = (XmlTreeModel)this.getModel();
        this.expandOrCollapseAll(xmlTreeModel.getPathForDomElement(parentNode), true);
    }

    public void collapseAllBelow(Node parentNode) {
        XmlTreeModel xmlTreeModel = (XmlTreeModel)this.getModel();
        this.expandOrCollapseAll(xmlTreeModel.getPathForDomElement(parentNode), false);
    }

    public boolean isExpandableOrCollapsable(TreePath parentTreePath, boolean expandable) {
        Object parentNode;
        if (parentTreePath == null) {
            return false;
        }
        XmlTreeModel xmlTreeModel = (XmlTreeModel)this.getModel();
        int childCount = xmlTreeModel.getChildCount(parentNode = parentTreePath.getLastPathComponent());
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                Object childNode = xmlTreeModel.getChild(parentNode, i);
                TreePath treePath = parentTreePath.pathByAddingChild(childNode);
                if (!this.isExpandableOrCollapsable(treePath, expandable)) continue;
                return true;
            }
            if (expandable ? this.isCollapsed(parentTreePath) : this.isExpanded(parentTreePath)) {
                return true;
            }
        }
        return false;
    }

    private void expandOrCollapseAll(TreePath parentTreePath, boolean expandAll) {
        Node parentNode;
        XmlTreeModel xmlTreeModel = (XmlTreeModel)this.getModel();
        int childCount = xmlTreeModel.getChildCount((Object)(parentNode = (Node)parentTreePath.getLastPathComponent()));
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                Node childNode = (Node)xmlTreeModel.getChild((Object)parentNode, i);
                TreePath treePath = parentTreePath.pathByAddingChild(childNode);
                this.expandOrCollapseAll(treePath, expandAll);
            }
            this.expandOrCollapsePath(parentTreePath, expandAll);
        }
    }

    public void expandOrCollapsePath(final TreePath parentTreePath, final boolean expandAll) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (expandAll) {
                this.expandPath(parentTreePath);
            } else {
                this.collapsePath(parentTreePath);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (expandAll) {
                        XmlJTree.this.expandPath(parentTreePath);
                    } else {
                        XmlJTree.this.collapsePath(parentTreePath);
                    }
                }
            });
        }
    }

    public void saveRootExpansionState() {
        final XmlJTree xmlJTree = this;
        this._rootSavedExpansionState = (SavedExpansionState)new ReadOnlyTask<SavedExpansionState>(){

            protected SavedExpansionState runImpl(AbstractModel model) {
                return SavedExpansionState.saveState(XmlJTree.this._gui, xmlJTree, new TreePath(XmlJTree.this.getModel().getRoot()));
            }
        }.run((AbstractModel)this._gui.getView());
    }

    public void restoreRootExpansionState() {
        new ReadOnlyTask<Boolean>(){

            protected Boolean runImpl(AbstractModel model) {
                XmlJTree.this._rootSavedExpansionState.restore();
                return true;
            }
        }.run((AbstractModel)this._gui.getView());
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
        if (this._gui.getDisableAutoscroll()) {
            return;
        }
        super.scrollRectToVisible(aRect);
    }

    private void expandAll(final TreePath parentTreePath) {
        new SwingWorker<String, TreePath>(){

            @Override
            public String doInBackground() {
                Node parentNode;
                XmlTreeModel xmlTreeModel = (XmlTreeModel)XmlJTree.this.getModel();
                int childCount = xmlTreeModel.getChildCount((Object)(parentNode = (Node)parentTreePath.getLastPathComponent()));
                if (childCount > 0) {
                    for (int i = 0; i < childCount; ++i) {
                        Node childNode = (Node)xmlTreeModel.getChild((Object)parentNode, i);
                        TreePath treePath = parentTreePath.pathByAddingChild(childNode);
                        XmlJTree.this.expandAll(treePath);
                    }
                    this.publish(parentTreePath);
                }
                return "done";
            }

            @Override
            protected void process(List<TreePath> results) {
                for (TreePath treePath : results) {
                    XmlJTree.this.expandPath(treePath);
                }
            }

            @Override
            public void done() {
            }
        }.execute();
    }

    private void collapseAll(final TreePath parentTreePath) {
        new SwingWorker<String, TreePath>(){

            @Override
            public String doInBackground() {
                Node parentNode;
                XmlTreeModel xmlTreeModel = (XmlTreeModel)XmlJTree.this.getModel();
                int childCount = xmlTreeModel.getChildCount((Object)(parentNode = (Node)parentTreePath.getLastPathComponent()));
                if (childCount > 0) {
                    for (int i = 0; i < childCount; ++i) {
                        Node childNode = (Node)xmlTreeModel.getChild((Object)parentNode, i);
                        TreePath treePath = parentTreePath.pathByAddingChild(childNode);
                        XmlJTree.this.collapseAll(treePath);
                    }
                    this.publish(parentTreePath);
                }
                return "done";
            }

            @Override
            protected void process(List<TreePath> results) {
                for (TreePath treePath : results) {
                    XmlJTree.this.collapsePath(treePath);
                }
            }

            @Override
            public void done() {
            }
        }.execute();
    }
}

