/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.base.explorer.BaseExplorerGui;
import oracle.bali.xml.gui.swing.explorer.SwingTreeListDropHandler;
import oracle.bali.xml.gui.swing.explorer.TreeHelper;

class ExplorerDropHandler
extends SwingTreeListDropHandler<JTree>
implements ActionListener {
    private static final int _HYSTERESIS = 5;
    private Point _lastPosition;
    private Timer _autoExpandTimer;
    private HashSet _expandedNodes;
    private TreePath _currentPath;
    private TreePath _toggledPath;
    private JTree _tree;

    ExplorerDropHandler(TreeHelper helper) {
        super(helper);
    }

    public JTree getJTree(DropTargetEvent event) {
        return (JTree)ExplorerDropHandler.getJComponent(event);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        super.dragEnter(event);
        this._init(event);
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        boolean overToggled;
        TreePath positionPath;
        super.dragOver(event);
        this._init(event);
        Point p = event.getLocation();
        JTree tree = this.getJTree(event);
        this._currentPath = positionPath = tree.getPathForLocation(p.x, p.y);
        boolean bl = overToggled = positionPath == this._toggledPath || positionPath != null && positionPath.equals(this._toggledPath);
        if (!overToggled) {
            this._toggledPath = null;
        }
        if (Math.abs(p.x - this._lastPosition.x) > 5 || Math.abs(p.y - this._lastPosition.y) > 5) {
            if (this._autoExpandTimer.isRunning()) {
                this._autoExpandTimer.stop();
                this._tree = null;
            }
        } else if (!this._autoExpandTimer.isRunning()) {
            if (!(positionPath == null || overToggled || tree.getModel().getChildCount(positionPath.getLastPathComponent()) <= 0 || tree.isExpanded(positionPath) && !this._expandedNodes.contains(positionPath))) {
                this._tree = tree;
                this._autoExpandTimer.start();
            } else {
                this._tree = null;
            }
        }
        this._lastPosition = p;
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this._cleanup();
        super.dragExit(event);
    }

    @Override
    public void drop(DropTargetDropEvent dropEvent) {
        this._cleanup();
        Object xmlGui = this.getHelper().getGui();
        if (xmlGui instanceof BaseExplorerGui) {
            ((BaseExplorerGui)xmlGui).ensureActiveGuiAcquired();
        }
        super.drop(dropEvent);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._autoExpandTimer.stop();
        if (this._tree == null) {
            return;
        }
        TreePath positionPath = this._currentPath;
        if (this._currentPath != null) {
            if (this._expandedNodes.contains(positionPath)) {
                this._expandedNodes.remove(positionPath);
                this._tree.collapsePath(positionPath);
            } else {
                this._expandedNodes.add(positionPath);
                this._tree.expandPath(positionPath);
            }
            this._toggledPath = positionPath;
        }
    }

    @Override
    protected void setDropLocation(DomPosition dropPos) {
        ((BaseExplorerGui)this.getGui()).setDisableAutoscroll(true);
        super.setDropLocation(dropPos);
        ((BaseExplorerGui)this.getGui()).setDisableAutoscroll(false);
    }

    private void _init(DropTargetDragEvent event) {
        this._lastPosition = event.getLocation();
        if (this._autoExpandTimer == null) {
            this._autoExpandTimer = new Timer(2200, this);
            this._autoExpandTimer.setCoalesce(true);
            this._autoExpandTimer.setRepeats(false);
        }
        if (this._expandedNodes == null) {
            this._expandedNodes = new HashSet(23);
        }
    }

    private void _cleanup() {
        if (this._autoExpandTimer != null) {
            this._autoExpandTimer.stop();
        }
        this._lastPosition = null;
        if (this._expandedNodes != null) {
            this._expandedNodes.clear();
        }
        this._toggledPath = null;
        this._currentPath = null;
    }
}

