/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.controls;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.bali.xml.gui.swing.controls.TrimmedJTextField;

public class ModelessEditorTextField
extends TrimmedJTextField {
    public static final String PROPERTY_TEXT = "text";
    private Listener _listener;

    public ModelessEditorTextField() {
        this(null, null, 0);
    }

    public ModelessEditorTextField(String text) {
        this(null, text, 0);
    }

    public ModelessEditorTextField(int columns) {
        this(null, null, columns);
    }

    public ModelessEditorTextField(String text, int columns) {
        this(null, text, columns);
    }

    public ModelessEditorTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this._init();
    }

    @Override
    public void setDocument(Document d) {
        Document old = this.getDocument();
        if (old != null && this._listener != null) {
            old.removeDocumentListener(this._listener);
        }
        super.setDocument(d);
        Document newDoc = this.getDocument();
        if (newDoc != null && this._listener != null) {
            newDoc.addDocumentListener(this._listener);
        }
    }

    private void _init() {
        this._listener = new Listener();
        this.addFocusListener(this._listener);
        if (this.getDocument() != null) {
            this.getDocument().addDocumentListener(this._listener);
        }
    }

    private class Listener
    implements DocumentListener,
    FocusListener {
        private boolean _dirty;
        private String _text;

        private Listener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!this._dirty) {
                this._text = ModelessEditorTextField.this.getText();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this._dirty && !e.isTemporary()) {
                if (ModelessEditorTextField.this.isEditable()) {
                    String newText = ModelessEditorTextField.this.getText();
                    ModelessEditorTextField.this.firePropertyChange(ModelessEditorTextField.PROPERTY_TEXT, this._text, newText);
                }
                this._text = null;
                this._dirty = false;
                if (e.getOppositeComponent() != null) {
                    e.getOppositeComponent().requestFocus();
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this._dirty = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this._dirty = true;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this._dirty = true;
        }
    }
}

