/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.GuiEventProcessor;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.base.BaseNodeCreatorGui;
import oracle.bali.xml.gui.base.BaseNodeCustomizerGui;
import oracle.bali.xml.gui.swing.action.ConvertContextualActionProvider;
import oracle.bali.xml.gui.swing.action.PasteSpecialAction;
import oracle.bali.xml.gui.swing.action.SurroundAction;
import oracle.bali.xml.gui.swing.operation.SwingXmlContextOperationFactory;
import oracle.bali.xml.gui.swing.util.InsertionMenuGenerator;
import oracle.bali.xml.gui.swing.util.SwingGuiEventProcessor;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.resource.PaternalResourceBundle;
import oracle.bali.xml.share.clipboard.AWTClipboardManager;
import oracle.bali.xml.share.clipboard.ClipboardManager;
import oracle.bali.xml.util.ContextualActionProvider;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class SwingXmlContext
extends GuiXmlContext {
    public static final Object MENU_PROPERTY_REQUEST_AUTO_MNEUMONICS = new String("auto-mneumonics");

    public abstract Component getRootDocumentUIComponent();

    public void showErrorMessage(final String message, String title, final Throwable t, Component parent) {
        final Component dialogParent = parent != null ? parent : this.getRootDocumentUIComponent();
        final String dialogTitle = title != null ? title : this.getErrorTitle();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (t != null) {
                    ExceptionDialog.showExceptionDialog((Component)dialogParent, (Throwable)t, (String)dialogTitle, (String)message, null);
                } else {
                    JOptionPane.showMessageDialog(dialogParent, message, dialogTitle, 0);
                }
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    public final void showErrorMessage(String message, String title, Throwable t) {
        this.showErrorMessage(message, title, t, null);
    }

    public NodeCreator getDefaultNodeCreator(XmlKey key) {
        XmlGui gui = this.getGui(XmlUsage.NODE_CREATOR);
        if (gui instanceof BaseNodeCreatorGui) {
            return ((BaseNodeCreatorGui)gui).getDefaultNodeCreator(key);
        }
        return null;
    }

    public NodeCustomizer getDefaultNodeCustomizer(XmlKey key) {
        XmlGui gui = this.getGui(XmlUsage.NODE_CUSTOMIZER);
        if (gui instanceof BaseNodeCustomizerGui) {
            return ((BaseNodeCustomizerGui)gui).getDefaultNodeCustomizer(key);
        }
        return null;
    }

    public void guiReceivedEventHook(XmlGui gui, InputEvent event) {
    }

    public JMenu createMenu(String menuName, Iterator menuItems) {
        JMenu menu = new JMenu(menuName);
        if (menuItems != null) {
            this._initializeMenu(menu, menuItems);
        }
        return menu;
    }

    protected void postMenuPopulationHook(JMenu menu) {
    }

    protected ClipboardManager getUnderlyingClipboardManager() {
        return AWTClipboardManager.getClipboardManager();
    }

    protected ResourceBundle createBundle() {
        return PaternalResourceBundle.getOrCreateCachedBundle((ResourceBundle)this.createBundle("oracle.bali.xml.gui.swing.resource.SwingBundle"), (ResourceBundle)super.createBundle());
    }

    protected String getErrorTitle() {
        return this.getTranslatedString("ERROR_DIALOG_TITLE");
    }

    protected GuiEventProcessor createEventProcesor(XmlGui gui) {
        return new SwingGuiEventProcessor(gui);
    }

    protected void initActions() {
        super.initActions();
        this.addAction(new PasteSpecialAction(this.getAction("paste")));
        this.addAction((Action)((Object)new SurroundAction()));
        this.registerGlobalContextualActionProvider((ContextualActionProvider)new ConvertContextualActionProvider());
    }

    protected void initOperations() {
        super.initOperations();
        this.getOperationManager().registerOperationFactory(SwingXmlContextOperationFactory.getInstance());
    }

    protected List getDefaultExtraContextMenus(XmlView view, DomPosition viewPosition) {
        return InsertionMenuGenerator.generateInsertionMenus(view, viewPosition);
    }

    private void _initializeMenu(final JMenu menu, final Iterator items) {
        menu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){
            private boolean _initialized = false;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (this._initialized) {
                    return;
                }
                this._initialized = true;
                while (items.hasNext()) {
                    Object next = items.next();
                    if (next instanceof Action) {
                        menu.add((Action)next);
                        continue;
                    }
                    if (!(next instanceof JComponent)) continue;
                    menu.add((JComponent)next);
                }
                SwingXmlContext.this.postMenuPopulationHook(menu);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }
}

