/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import oracle.bali.xml.gui.base.BaseContextualActionsGui;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.gui.swing.util.GrammarBasedAddAttributeActionProvider;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.util.ContextualActionProvider;
import org.w3c.dom.Node;

public class SwingContextualActionsGui
extends BaseContextualActionsGui
implements ComponentXmlGui {
    private static final int _H_GAP = 5;
    private static final int _V_GAP = 3;
    private transient JPanel _panel;
    private transient JScrollPane _pane;

    public SwingContextualActionsGui(XmlView view) {
        super(view);
    }

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new ScrollablePanel();
            this._pane = new JScrollPane(this._panel);
            this._updateUI();
        }
        return this._pane;
    }

    protected void actionsChanged(List oldActions, List newActions) {
        if (this._panel != null) {
            this._updateUI();
            this._panel.getParent().validate();
            this._panel.repaint();
        }
    }

    protected List<Action> getGuiActions(Node domNode) {
        if (this.getView().getXmlMetadataResolver().isImmutable(domNode)) {
            return Collections.emptyList();
        }
        ContextualActionProvider addAttribute = GrammarBasedAddAttributeActionProvider.getProvider();
        return addAttribute.getContextualActions((XmlContext)this.getGuiContext(), this.getView().getXmlMetadataResolver().getNodeXmlKey(domNode), domNode);
    }

    private void _updateUI() {
        this._panel.removeAll();
        List actionList = this.getContextualActions();
        for (Action currAction : actionList) {
            if (Boolean.FALSE.equals(currAction.getValue("show-in-pi"))) continue;
            this._panel.add(this.createButton(currAction));
        }
        if (this._panel.getComponentCount() > 0) {
            this._pane.setBorder(UIManager.getBorder("ScrollPane.border"));
        } else {
            this._pane.setBorder(null);
        }
    }

    protected Component createButton(Action action) {
        JButton button = new JButton(action);
        return button;
    }

    private class ScrollablePanel
    extends JPanel
    implements Scrollable {
        public ScrollablePanel() {
            super(new GridLayout(0, 1, 5, 3));
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            if (this.getComponentCount() == 0) {
                return new Dimension();
            }
            Dimension d = this.getPreferredSize();
            return new Dimension(d.width, 40);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

