/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.util.UnhandledException;
import oracle.bali.xml.dom.MakeTestCaseUndoableEditListener;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.gui.demo.DemoTextSelectionSynchronizer;
import oracle.bali.xml.gui.demo.DemoUndoHandler;
import oracle.bali.xml.gui.demo.DemoXmlContext;
import oracle.bali.xml.gui.demo.DemoXmlGuiFactory;
import oracle.bali.xml.gui.demo.VisualEditor;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.gui.swing.ceditor.SwingXmlCodeEditorGui;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.bali.xml.preference.PreferencePanel;
import oracle.bali.xml.share.BaseAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.editor.plugins.StatusBarPlugin;

public class VisualEditorUI {
    private static final UsagesAndLocation[] _MAIN_LAYOUT_INFO;
    private static final Object _XML_GUI_KEY;
    private static final String _LAYOUT_NAME = "Layout";
    private static final String _SOURCE_NAME = "Source";
    private static final String _RECORDING_NAME = "RecordedTransactions";
    private static final String _LAYOUT_TAB_STRING = "Layout";
    private static final String _SOURCE_TAB_STRING = "Source";
    private static final String _RECORDED_TRANSACTIONS_STRING = "Recorded Transactions";
    private static final String _DEFAULT_APP_NAME_STRING = "XML Visual Editor";
    private static final String _REGISTER_SCHEMA_ITEM = "Register schema";
    private static final String _DOCUMENT_INVALID_KEY = "DocumentInvalid";
    private VisualEditor _ve;
    private JFrame _appFrame;
    private DemoXmlContext _context;
    private DemoUndoHandler _undoHandler;
    private PreferencePanel _preferencePanel;
    private final XmlUsage[] _additionalUsages;
    private XmlGui _activeGui = null;
    private JTabbedPane _tabs;
    private Component _lastVisibleTab;

    public VisualEditorUI(VisualEditor main, XmlViewFactory viewFactory, XmlGuiFactory[] additionalGuiFactories, File file, Locale locale, int width, int height, String applicationName, XmlUsage[] additionalUsages) {
        if (file == null) {
            throw new IllegalArgumentException("No file specified");
        }
        this._ve = main;
        if (applicationName == null) {
            applicationName = _DEFAULT_APP_NAME_STRING;
        }
        this._context = new DemoXmlContext(file, locale);
        this._context.finishInitialization();
        this._undoHandler = new DemoUndoHandler();
        this._context.addUndoableEditListener(this._undoHandler);
        XmlModel model = main.createXmlModel(this._context, null);
        this._context.setModel(model);
        this._context.registerViewFactory(viewFactory);
        if (additionalGuiFactories != null) {
            int i;
            boolean registerDemoGuiFactory = true;
            int additionGuiCount = additionalGuiFactories.length;
            for (i = 0; i < additionGuiCount; ++i) {
                if (!(additionalGuiFactories[i] instanceof DemoXmlGuiFactory)) continue;
                registerDemoGuiFactory = false;
                break;
            }
            if (registerDemoGuiFactory) {
                this._context.registerGuiFactory((XmlGuiFactory)DemoXmlGuiFactory.getInstance());
            }
            for (i = 0; i < additionGuiCount; ++i) {
                this._context.registerGuiFactory(additionalGuiFactories[i]);
            }
        } else {
            this._context.registerGuiFactory((XmlGuiFactory)DemoXmlGuiFactory.getInstance());
        }
        this._additionalUsages = additionalUsages == null ? new XmlUsage[0] : additionalUsages;
        this._preferencePanel = main.createPreferencePanel();
        this._appFrame = this._createUI(applicationName, file, width, height);
        this._context.setRootDocumentUIComponent(this._appFrame);
        SwingUtilities.invokeLater(new ShowAppFrame());
    }

    private static void _initLookAndFeel() {
        String lafName = UIManager.getSystemLookAndFeelClassName();
        try {
            Class<?> lafClass = Class.forName(lafName, true, Thread.currentThread().getContextClassLoader());
            try {
                LookAndFeel laf = (LookAndFeel)lafClass.newInstance();
                try {
                    UIManager.setLookAndFeel(laf);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private JFrame _createUI(String applicationName, File file, int width, int height) {
        JFrame appFrame = new JFrame(applicationName);
        appFrame.setJMenuBar(this._createAppMenu());
        appFrame.setSize(width, height);
        this._tabs = new JTabbedPane();
        Component mainTab = this._createMainTab(width, height);
        if (mainTab != null) {
            this._tabs.addTab("Layout", mainTab);
        }
        final Component srcComponent = this._createSourceTab(width, height);
        this._tabs.addTab("Source", srcComponent);
        Component recorder = this._createRecordTransactionsComponent();
        if (recorder != null) {
            this._tabs.addTab(_RECORDED_TRANSACTIONS_STRING, recorder);
        }
        for (int i = 0; i < this._additionalUsages.length; ++i) {
            XmlUsage usage = this._additionalUsages[i];
            Component c = this._getComponent(usage);
            if (c == null) continue;
            this._tabs.addTab(usage.toString(), c);
        }
        ChangeListener tabChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Component selectedComponent = VisualEditorUI.this._tabs.getSelectedComponent();
                XmlGui selectedGui = VisualEditorUI.this._getXmlGui(selectedComponent);
                VisualEditorUI.this._context.setActiveGui(selectedGui);
                if (selectedComponent != srcComponent && !VisualEditorUI.this._context.getModel().isDocumentValid()) {
                    String string = VisualEditorUI.this._context.getModel().getTranslatedString(VisualEditorUI._DOCUMENT_INVALID_KEY);
                }
                if (VisualEditorUI.this._lastVisibleTab != selectedComponent) {
                    VisualEditorUI.this._hideGuis(VisualEditorUI.this._lastVisibleTab);
                    VisualEditorUI.this._showGuis(selectedComponent);
                    VisualEditorUI.this._lastVisibleTab = selectedComponent;
                }
            }
        };
        this._tabs.addChangeListener(tabChangeListener);
        appFrame.getContentPane().add(this._tabs);
        appFrame.setDefaultCloseOperation(3);
        return appFrame;
    }

    private Component _getComponent(XmlUsage usage) {
        XmlGui gui = this._context.getGui(usage);
        if (gui != null && gui instanceof ComponentXmlGui) {
            Object c = ((ComponentXmlGui)gui).getComponent();
            if (this._ve.needsScrolling(usage)) {
                c = new JScrollPane((Component)c);
            }
            if (c instanceof JComponent) {
                ((JComponent)c).putClientProperty(_XML_GUI_KEY, gui);
            }
            new GuiActivationHandler((Component)c);
            return c;
        }
        return null;
    }

    private Component _createSourceTab(int width, int height) {
        Component sourceComponent = this._createSourceComponent();
        Component explorerComponent = this._getComponent(XmlUsage.XML_CODE_EXPLORER);
        if (sourceComponent != null && explorerComponent != null) {
            JSplitPane split = new JSplitPane(1, explorerComponent, sourceComponent);
            split.setDividerLocation(width / 4);
            return split;
        }
        if (sourceComponent != null) {
            return sourceComponent;
        }
        return explorerComponent;
    }

    private Component _createMainTab(int width, int height) {
        JSplitPane split;
        Component layoutComponent = this._getComponent(XmlUsage.LAYOUT_EDITOR);
        Component inspectorComponent = this._getComponent(XmlUsage.PROPERTY_INSPECTOR);
        Component actionsComponent = this._getComponent(XmlUsage.CONTEXTUAL_ACTIONS);
        Component explorerComponent = this._getComponent(XmlUsage.EXPLORER);
        Component paletteComponent = this._getComponent(XmlUsage.COMPONENT_PALETTE);
        Component statusComponent = this._getComponent(XmlUsage.STATUS_BAR);
        Component inspectorAndActionsLayout = null;
        Component inspectorAndPaletteLayout = null;
        if (inspectorComponent != null && inspectorComponent instanceof JComponent) {
            ((JComponent)inspectorComponent).setMinimumSize(new Dimension(100, 100));
        }
        if (inspectorComponent != null && actionsComponent != null) {
            Box verticalBox = Box.createVerticalBox();
            verticalBox.add(inspectorComponent);
            verticalBox.add(Box.createVerticalStrut(5));
            verticalBox.add(actionsComponent);
            inspectorAndActionsLayout = verticalBox;
        } else if (inspectorComponent != null) {
            inspectorAndActionsLayout = inspectorComponent;
        } else if (paletteComponent != null) {
            inspectorAndActionsLayout = actionsComponent;
        }
        if (inspectorAndActionsLayout != null && paletteComponent != null) {
            JSplitPane piStructureSplitter = new JSplitPane(0);
            piStructureSplitter.setTopComponent(inspectorAndActionsLayout);
            piStructureSplitter.setBottomComponent(paletteComponent);
            piStructureSplitter.setDividerLocation((int)((double)height * 0.5));
            inspectorAndPaletteLayout = piStructureSplitter;
        } else if (inspectorAndActionsLayout != null) {
            inspectorAndPaletteLayout = inspectorAndActionsLayout;
        } else if (paletteComponent != null) {
            inspectorAndPaletteLayout = paletteComponent;
        }
        Component main = explorerComponent;
        if (main == null) {
            main = layoutComponent;
        } else if (layoutComponent != null) {
            split = new JSplitPane(1, main, layoutComponent);
            split.setDividerLocation(width / 4);
            main = split;
        }
        if (main == null) {
            main = inspectorAndPaletteLayout;
        } else if (inspectorAndPaletteLayout != null) {
            split = new JSplitPane(1, main, inspectorAndPaletteLayout);
            split.setDividerLocation(width - width / 4);
            main = split;
        }
        if (main == null) {
            main = statusComponent;
        } else if (statusComponent != null) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add(main, "Center");
            panel.add(statusComponent, "South");
            main = panel;
        }
        if (main != null) {
            main.setName("Layout");
        }
        return main;
    }

    private JMenuBar _createAppMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add((Action)((Object)new RegisterSchemaAction()));
        menuBar.add(fileMenu);
        menuBar.add(this._createEditMenu());
        return menuBar;
    }

    private JMenu _createEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(69);
        DemoXmlContext context = this._context;
        editMenu.add(this._undoHandler.createUndoMenuItem());
        editMenu.add(this._undoHandler.createRedoMenuItem());
        editMenu.addSeparator();
        Action cutAction = context.getAction("cut");
        Action copyAction = context.getAction("copy");
        Action clearAction = context.getAction("clear");
        editMenu.add(UIUtils.createMenuItem(cutAction));
        editMenu.add(UIUtils.createMenuItem(copyAction));
        editMenu.add(UIUtils.createMenuItem(clearAction));
        if (this._preferencePanel != null) {
            editMenu.addSeparator();
            editMenu.add((Action)((Object)new PreferencesAction()));
        }
        return editMenu;
    }

    private JMenu _createUndoMenu() {
        JMenu undoMenu = new JMenu("Undo");
        undoMenu.setMnemonic(85);
        return undoMenu;
    }

    private JMenu _createRedoMenu() {
        JMenu redoMenu = new JMenu("Redo");
        redoMenu.setMnemonic(82);
        return redoMenu;
    }

    private Component _createSourceComponent() {
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.END_TAG", true);
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION", true);
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.SMART_INDENT", true);
        EditorProperties.getProperties().putBooleanProperty("code-folding-margin-visible", true);
        EditorProperties.getProperties().putBooleanProperty("code-folding-enabled", true);
        EditorProperties.getProperties().putIntegerProperty("editor-width", 2000);
        BasicEditorPane sourceComponent = new BasicEditorPane();
        XMLLanguageModule xmlModule = new XMLLanguageModule();
        String filename = "a.xml";
        try {
            File file = this._context.getFile();
            if (file != null) {
                filename = file.getCanonicalPath();
            }
        }
        catch (IOException ioE) {
            filename = "a.xml";
        }
        BasicDocument sourceDocument = (BasicDocument)this._context.getSourceDocument();
        sourceDocument.setLanguageSupport(filename);
        sourceComponent.setDocument((Document)sourceDocument);
        sourceComponent.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        FindHighlightPlugin findPlugin = new FindHighlightPlugin();
        sourceComponent.installPlugin((EditorPlugin)findPlugin);
        sourceComponent.putProperty("finder", (Object)findPlugin);
        LineGutterPlugin lineGutter = new LineGutterPlugin();
        sourceComponent.installPlugin((EditorPlugin)lineGutter);
        StatusBarPlugin statusBar = new StatusBarPlugin(sourceComponent.getFont());
        sourceComponent.installPlugin((EditorPlugin)statusBar);
        XmlGui gui = this._context.getGui(XmlUsage.XML_CODE_EDITOR);
        if (gui != null) {
            List xmlPlugins = ((SwingXmlCodeEditorGui)gui).createEditorPlugins();
            Iterator iter = xmlPlugins.iterator();
            while (iter.hasNext()) {
                sourceComponent.installPlugin((EditorPlugin)iter.next());
            }
        }
        JScrollPane scrollPane = new JScrollPane((Component)sourceComponent);
        scrollPane.setName("Source");
        scrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = scrollPane.getViewport();
        viewport.setScrollMode(1);
        JPanel leftMargin = new JPanel(new BorderLayout());
        leftMargin.add((Component)lineGutter, "Center");
        Component codeFoldingMargin = (Component)sourceComponent.getProperty("code-folding-margin");
        if (codeFoldingMargin != null) {
            leftMargin.add(codeFoldingMargin, "East");
        }
        scrollPane.setRowHeaderView(leftMargin);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)scrollPane, "Center");
        mainPanel.add((Component)statusBar.getPanel(), "South");
        this._context.getModel().addModelListener((XmlModelListener)new DemoTextSelectionSynchronizer(sourceComponent));
        return mainPanel;
    }

    private Component _createRecordTransactionsComponent() {
        BasicEditorPane component = new BasicEditorPane();
        component.setLanguageSupport("foo.java");
        RecorderWithDocument recorder = new RecorderWithDocument(component.getDocument());
        this._context.addUndoableEditListener((UndoableEditListener)((Object)recorder));
        JScrollPane pane = new JScrollPane((Component)component);
        pane.setName(_RECORDING_NAME);
        return pane;
    }

    private int _getOrientationForLocation(Object location) {
        if ("North".equals(location) || "South".equals(location)) {
            return 1;
        }
        return 0;
    }

    private XmlGui _getXmlGui(Component component) {
        if (component instanceof JComponent) {
            return (XmlGui)((JComponent)component).getClientProperty(_XML_GUI_KEY);
        }
        return null;
    }

    private List _getGuisRecursive(Component component) {
        LinkedList list = new LinkedList();
        this._getGuisRecursiveImpl(list, component);
        return list;
    }

    private void _getGuisRecursiveImpl(List list, Component component) {
        XmlGui gui = this._getXmlGui(component);
        if (gui != null) {
            list.add(gui);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this._getGuisRecursiveImpl(list, container.getComponent(i));
            }
        }
    }

    private void _showGuis(Component c) {
        if (c != null) {
            List guis = this._getGuisRecursive(c);
            Iterator itor = guis.iterator();
            while (itor.hasNext()) {
                ((XmlGui)itor.next()).shown();
            }
        }
    }

    private void _hideGuis(Component c) {
        if (c != null) {
            List guis = this._getGuisRecursive(c);
            Iterator itor = guis.iterator();
            while (itor.hasNext()) {
                ((XmlGui)itor.next()).hidden();
            }
        }
    }

    static {
        VisualEditorUI._initLookAndFeel();
        _MAIN_LAYOUT_INFO = new UsagesAndLocation[]{new UsagesAndLocation((Object)"Center", XmlUsage.LAYOUT_EDITOR), new UsagesAndLocation((Object)"West", XmlUsage.EXPLORER), new UsagesAndLocation((Object)"South", XmlUsage.STATUS_BAR), new UsagesAndLocation("East", XmlUsage.PROPERTY_INSPECTOR, XmlUsage.COMPONENT_PALETTE)};
        _XML_GUI_KEY = new String("XmlGuiKey");
    }

    private static class UsagesAndLocation {
        public final XmlUsage[] usages;
        public final Object location;

        public UsagesAndLocation(Object loc, XmlUsage[] u) {
            this.usages = u;
            this.location = loc;
        }

        public UsagesAndLocation(Object loc, XmlUsage u) {
            this(loc, new XmlUsage[]{u});
        }

        public UsagesAndLocation(Object loc, XmlUsage u1, XmlUsage u2) {
            this(loc, new XmlUsage[]{u1, u2});
        }

        public UsagesAndLocation(Object loc, XmlUsage u1, XmlUsage u2, XmlUsage u3) {
            this(loc, new XmlUsage[]{u1, u2, u3});
        }
    }

    private static class RecorderWithDocument
    extends MakeTestCaseUndoableEditListener {
        private final Document _doc;

        public RecorderWithDocument(Document doc) {
            this._doc = doc;
        }

        public void undoableEditHappened(UndoableEditEvent event) {
            super.undoableEditHappened(event);
            StringBuffer buf = this.getOutput();
            try {
                this._doc.insertString(this._doc.getLength(), buf.toString(), null);
            }
            catch (Exception e) {
                throw new UnhandledException((Throwable)e);
            }
            buf.delete(0, buf.length());
        }
    }

    private class RegisterSchemaAction
    extends BaseAction {
        public RegisterSchemaAction() {
            super(VisualEditorUI._REGISTER_SCHEMA_ITEM, (int)VisualEditorUI._REGISTER_SCHEMA_ITEM.charAt(0), KeyStroke.getKeyStroke(82, 2), "registerSchema", null);
        }

        public void actionPerformed(ActionEvent ae) {
            JFileChooser fileDialog = new JFileChooser();
            int ret = fileDialog.showOpenDialog(VisualEditorUI.this._appFrame);
            if (ret == 0) {
                try {
                    File file = fileDialog.getSelectedFile();
                    SchemaGrammarProvider gp = DemoXmlContext.getSharedGrammarProvider();
                    gp.addSchema(file.toURL());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class PreferencesAction
    extends BaseAction {
        public PreferencesAction() {
            super("Preferences", 80, KeyStroke.getKeyStroke(80, 2), "preferences", null);
        }

        public void actionPerformed(ActionEvent ae) {
            JEWTDialog dlg = JEWTDialog.createDialog((Component)VisualEditorUI.this._appFrame, (String)"Preferences", (int)3);
            dlg.setModal(true);
            dlg.setContent((Component)VisualEditorUI.this._preferencePanel);
            VisualEditorUI.this._preferencePanel.load(VisualEditorUI.this._context.getPreferenceManager());
            boolean ok = dlg.runDialog();
            if (ok) {
                VisualEditorUI.this._preferencePanel.save(VisualEditorUI.this._context.getPreferenceManager());
            }
        }
    }

    private class GuiActivationHandler
    implements FocusListener,
    ComponentListener,
    HierarchyListener {
        private Component _target;

        public GuiActivationHandler(Component target) {
            this._target = target;
            target.addFocusListener(this);
            target.addComponentListener(this);
            target.addHierarchyListener(this);
        }

        @Override
        public void focusGained(FocusEvent e) {
            XmlGui focusedGui = VisualEditorUI.this._getXmlGui(e.getComponent());
            VisualEditorUI.this._context.setActiveGui(focusedGui);
        }

        @Override
        public void focusLost(FocusEvent e) {
            XmlGui unfocusedGui = VisualEditorUI.this._getXmlGui(e.getComponent());
            if (VisualEditorUI.this._context.getActiveGui() == unfocusedGui) {
                VisualEditorUI.this._context.setActiveGui(null);
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this._handleShown();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this._handleHidden();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 0L) {
                if (this._target.isShowing()) {
                    this._handleShown();
                } else {
                    this._handleHidden();
                }
            }
        }

        private void _handleHidden() {
            XmlGui hiddenGui = VisualEditorUI.this._getXmlGui(this._target);
            if (VisualEditorUI.this._context.getActiveGui() == hiddenGui) {
                VisualEditorUI.this._context.setActiveGui(null);
            }
        }

        private void _handleShown() {
            Object layoutComponent;
            XmlGui layoutEditorGui;
            if (VisualEditorUI.this._context.getActiveGui() == null && (layoutEditorGui = VisualEditorUI.this._context.getGui(XmlUsage.LAYOUT_EDITOR)) instanceof ComponentXmlGui && ((Component)(layoutComponent = ((ComponentXmlGui)layoutEditorGui).getComponent())).isShowing()) {
                VisualEditorUI.this._context.setActiveGui(layoutEditorGui);
            }
        }
    }

    private class ShowAppFrame
    implements Runnable {
        private ShowAppFrame() {
        }

        @Override
        public void run() {
            VisualEditorUI.this._appFrame.setVisible(true);
            VisualEditorUI.this._lastVisibleTab = VisualEditorUI.this._tabs.getSelectedComponent();
            VisualEditorUI.this._showGuis(VisualEditorUI.this._lastVisibleTab);
        }
    }
}

