/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.demo;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.text.Document;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.buffer.BufferDomModelPluginFactory;
import oracle.bali.xml.dom.buffer.DefaultDocumentScannerFactory;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.impl.DomModelFactory;
import oracle.bali.xml.dom.impl.DomModelPluginFactory;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.instance.XmlInstanceGrammarProvider;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.SwingXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.xml.parser.v2.XMLDOMImplementation;
import org.w3c.dom.DOMImplementation;

public class DemoXmlContext
extends SwingXmlContext {
    private static HashMap _sRelatedModels = new HashMap();
    private static SchemaGrammarProvider _sharedGrammarProvider = new SchemaGrammarProvider();
    private final BasicDocument _document;
    private final File _file;
    private final Locale _locale;
    private XmlGui _activeGui;
    private Component _rootComponent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DemoXmlContext(File file, Locale locale) {
        this._file = file;
        this._locale = locale;
        this._document = new BasicDocument();
        TextBuffer textBuffer = this._document.getTextBuffer();
        if (this._file.exists()) {
            try {
                FileInputStream fileStream = new FileInputStream(file);
                InputStreamReader streamReader = new InputStreamReader(fileStream);
                try (BufferedReader bufferedReader = null;){
                    bufferedReader = new BufferedReader(streamReader);
                    textBuffer.read((Reader)bufferedReader);
                }
                textBuffer.setReadOnly(!this._file.canWrite());
            }
            catch (Exception e) {
                System.err.println("Error opening file: " + this._file);
                e.printStackTrace();
            }
        }
    }

    public URL getURL() {
        try {
            return this._file.toURL();
        }
        catch (MalformedURLException e) {
            this.getLogger().log(Level.WARNING, "exception in file to url: " + this._file, e);
            return null;
        }
    }

    @Override
    public Component getRootDocumentUIComponent() {
        return this._rootComponent;
    }

    public void setRootDocumentUIComponent(Component component) {
        this._rootComponent = component;
    }

    public Document getSourceDocument() {
        return this._document;
    }

    public TextBuffer getTextBuffer() {
        return this._document.getTextBuffer();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public XmlGui getActiveGui() {
        return this._activeGui;
    }

    public void setActiveGui(XmlGui newActiveGui) {
        XmlGui oldActiveGui = this._activeGui;
        this._activeGui = this.setActiveGui(newActiveGui, oldActiveGui);
        this.firePropertyChange("activeGui", oldActiveGui, this._activeGui);
    }

    public File getFile() {
        return this._file;
    }

    public String getRelativePathForURL(URL url) {
        return url.toString();
    }

    public URL getURLForRelativePath(String relativePath) {
        URL newURL = null;
        try {
            newURL = new URL(this._file.toURI().toURL(), relativePath);
        }
        catch (Exception e) {
            try {
                newURL = new URL(relativePath);
            }
            catch (Exception e2) {
                newURL = null;
            }
        }
        return newURL;
    }

    public XmlModel getRelatedXmlModel(URL url) {
        String relatedFilename;
        XmlModel model = (XmlModel)_sRelatedModels.get(url);
        if (model == null && (relatedFilename = url.getFile()) != null) {
            try {
                File relatedFile = new File(relatedFilename);
                DemoXmlContext xmlContext = new DemoXmlContext(relatedFile, this.getLocale());
                xmlContext.finishInitialization();
                model = new XmlModel();
                xmlContext.setModel(model);
                _sRelatedModels.put(url, model);
            }
            catch (Exception e) {
                model = null;
            }
        }
        return model;
    }

    public static SchemaGrammarProvider getSharedGrammarProvider() {
        return _sharedGrammarProvider;
    }

    protected GrammarProvider createGrammarProvider() {
        SchemaGrammarProvider base = DemoXmlContext.getSharedGrammarProvider();
        return new XmlInstanceGrammarProvider((GrammarProvider)base);
    }

    protected DomModel createSourceDomModel(XmlModel xmlModel) {
        BufferDomModelPluginFactory pluginFactory = new BufferDomModelPluginFactory(this.getTextBuffer(), (DOMImplementation)new XMLDOMImplementation(), (ParserConfiguration)new DefaultParserConfiguration(), (DocumentScannerFactory)new DefaultDocumentScannerFactory());
        DomModel dom = DomModelFactory.createDomModel((DomModelContext)this, (DomModelPluginFactory)pluginFactory, (WhitespaceHandler)xmlModel.getWhitespaceHandler());
        return dom;
    }
}

