/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.List;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.XMLLanguageModule;
import oracle.bali.xml.editor.insight.InsightUtils;
import oracle.bali.xml.editor.insight.XMLCompletionInsightProvider;
import oracle.bali.xml.editor.insight.XMLInsightData;
import oracle.bali.xml.editor.insight.data.BaseItem;
import oracle.bali.xml.editor.insight.data.ElementEndTagItem;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.insight.SortedInsightInputFilter;

public class ElementEndTagInsightData
implements XMLInsightData {
    private Object _defaultData = null;
    private XMLCompletionInsightProvider _insight;
    private ReadOnlyListModel _listModel;
    private InsightLocation _insightLocation;
    private ListDataItem[] _insightDataList;
    private Object[] _matchingDataList;
    private static final String RESOURCE_KEY_UNDO_DESCRIPTOR = "XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR";
    private static final EditDescriptor EDIT_DESCRIPTOR = new EditDescriptor(XMLLanguageModule.getXMLEditorResource("XMLEDITOR.INSIGHT.UNDO_ELEMENT_DESCRIPTOR"));

    public ElementEndTagInsightData(XMLCompletionInsightProvider insight, InsightLocation insightLocation) {
        this._insight = insight;
        this._insightLocation = insightLocation;
        this.fillDataList();
        this._updateDataImpl(true);
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    private ReadOnlyListModel buildListModel() {
        if (this._listModel == null) {
            this._listModel = new ReadOnlyListModel((Object[])this._insightDataList);
        }
        return this._listModel;
    }

    public Object[] getData() {
        return this._insightDataList;
    }

    public Object[] getMatchingData() {
        return this._matchingDataList;
    }

    public int getMatchingDataCount() {
        Object[] matchingData = this.getMatchingData();
        return matchingData == null ? 0 : matchingData.length;
    }

    public Object getDefault() {
        return this._defaultData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object selectedObject) {
        int startOffset;
        int endOffset;
        boolean retriggerInsight = false;
        BaseItem selectedItem = (BaseItem)((Object)selectedObject);
        String selectedName = selectedItem.getName();
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        editorPane.beginEdit(EDIT_DESCRIPTOR);
        List declarations = this._insightLocation.getElementDeclarations();
        int lastDeclIndex = declarations.size() - 1;
        ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastDeclIndex);
        ElementLocator elementLocator = elementDecl.getElementLocator();
        boolean insertEndBracket = true;
        if (textBuffer.getChar(elementLocator.getEndOffset() - 1) == '>') {
            insertEndBracket = false;
        }
        for (endOffset = startOffset = elementLocator.getStartOffset() + 2; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>'; ++endOffset) {
        }
        try {
            String insertString = selectedName;
            if (insertEndBracket) {
                insertString = insertString + ">";
            }
            document.remove(startOffset, endOffset - startOffset);
            document.insertString(startOffset, insertString, null);
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in completion: " + e);
            e.printStackTrace();
        }
        finally {
            editorPane.endEdit();
        }
        return retriggerInsight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialComplete() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        BasicEditorPane editorPane = this._insight.getEditorPane();
        BasicDocument document = this._insight.getDocument();
        document.readLock();
        try {
            BaseItem item;
            int i;
            int listSize;
            int startOffset;
            int endOffset;
            List declarations = this._insightLocation.getElementDeclarations();
            int lastDeclIndex = declarations.size() - 1;
            ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastDeclIndex);
            ElementLocator elementLocator = elementDecl.getElementLocator();
            for (endOffset = startOffset = elementLocator.getStartOffset() + 2; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>'; ++endOffset) {
            }
            String userPrefix = new String(textBuffer.getChars(startOffset, endOffset - startOffset));
            int startIndex = listSize = this._insightDataList != null ? this._insightDataList.length : 0;
            int endIndex = listSize;
            for (i = 0; i < listSize; ++i) {
                item = (BaseItem)this._insightDataList[i];
                String itemName = item.getName();
                if (!itemName.startsWith(userPrefix)) continue;
                startIndex = i;
                break;
            }
            for (i = startIndex; i < listSize; ++i) {
                item = (BaseItem)this._insightDataList[i];
                String endItemName = item.getName();
                if (endItemName.startsWith(userPrefix)) continue;
                endIndex = i;
                break;
            }
            if (startIndex == listSize) {
                return;
            }
            BaseItem firstItem = (BaseItem)this._insightDataList[startIndex];
            String commonPrefix = firstItem.getName();
            if (endIndex - startIndex > 1) {
                for (int i2 = startIndex + 1; i2 < endIndex; ++i2) {
                    BaseItem nextItem = (BaseItem)this._insightDataList[i2];
                    commonPrefix = InsightUtils.getCommonPrefix(commonPrefix, nextItem.getName());
                }
            }
            if (!commonPrefix.startsWith(userPrefix)) {
                System.err.println("userPrefix: " + userPrefix);
                System.err.println("commonPrefix: " + commonPrefix);
                throw new IllegalStateException("Common text/prefix error");
            }
            editorPane.beginEdit(EDIT_DESCRIPTOR);
            try {
                document.remove(startOffset, endOffset - startOffset);
                document.insertString(startOffset, commonPrefix, null);
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in partial completion: " + e);
                e.printStackTrace();
            }
            finally {
                editorPane.endEdit();
            }
        }
        finally {
            document.readUnlock();
        }
    }

    @Override
    public void updateData() {
        this._updateDataImpl(false);
    }

    private void _updateDataImpl(boolean initializing) {
        int startOffset;
        int endOffset;
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int caretOffset = this._insight.getCaretPosition();
        List declarations = this._insightLocation.getElementDeclarations();
        int lastDeclIndex = declarations.size() - 1;
        ElementDeclaration elementDecl = (ElementDeclaration)declarations.get(lastDeclIndex);
        ElementLocator elementLocator = elementDecl.getElementLocator();
        for (endOffset = startOffset = elementLocator.getStartOffset() + 2; endOffset < textBuffer.getLength() && textBuffer.getChar(endOffset) != ' ' && textBuffer.getChar(endOffset) != '\t' && textBuffer.getChar(endOffset) != '\n' && textBuffer.getChar(endOffset) != '<' && textBuffer.getChar(endOffset) != '>'; ++endOffset) {
        }
        if (caretOffset < startOffset || caretOffset > endOffset) {
            if (!initializing) {
                this.clearData();
                return;
            }
        } else {
            String userPrefix = new String(textBuffer.getChars(startOffset, caretOffset - startOffset));
            this.fillDefault(userPrefix);
            this.fillMatchingData(userPrefix);
        }
    }

    private void clearData() {
        if (this._insightDataList == null || this._insightDataList.length > 0) {
            this._insightDataList = new ListDataItem[0];
        }
        this._defaultData = null;
        this._matchingDataList = null;
    }

    private void fillDataList() {
        ElementDeclaration matchingDecl;
        ResolvedName matchingName;
        ElementDeclaration elementDecl;
        ElementEndTagItem endTagItem = null;
        List declarations = this._insightLocation.getElementDeclarations();
        int pathSize = declarations.size();
        if (pathSize >= 2 && !(elementDecl = (ElementDeclaration)declarations.get(pathSize - 1)).isStartTag() && elementDecl.isEndTag() && (matchingName = (matchingDecl = (ElementDeclaration)declarations.get(pathSize - 2)).getResolvedName()) != null) {
            String prefix = matchingName.getPrefix();
            String localName = matchingName.getLocalName();
            if (localName != null) {
                endTagItem = new ElementEndTagItem(prefix, localName);
            }
        }
        if (endTagItem != null) {
            this._insightDataList = new ListDataItem[1];
            this._insightDataList[0] = endTagItem;
        } else {
            this._insightDataList = new ListDataItem[0];
        }
    }

    private void fillMatchingData(String userPrefix) {
        this._matchingDataList = SortedInsightInputFilter.INSTANCE.getMatchingData(this._insightDataList, userPrefix);
    }

    private void fillDefault(String userPrefix) {
        this._defaultData = null;
        if (this._insightDataList.length == 0) {
            return;
        }
        int listSize = this._insightDataList.length;
        int prefixLength = userPrefix.length();
        String lowerCasePrefix = userPrefix.toLowerCase();
        for (int j = prefixLength; j > 0; --j) {
            String shortenedPrefix = userPrefix.substring(0, j);
            BaseItem lowerCaseMatch = null;
            for (int i = 0; i < listSize; ++i) {
                BaseItem item = (BaseItem)this._insightDataList[i];
                String itemName = item.getName();
                if (itemName.startsWith(shortenedPrefix)) {
                    this._defaultData = item;
                    return;
                }
                if (lowerCaseMatch != null || !itemName.toLowerCase().startsWith(lowerCasePrefix)) continue;
                lowerCaseMatch = item;
            }
            if (lowerCaseMatch == null) continue;
            this._defaultData = lowerCaseMatch;
            return;
        }
    }
}

