/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.utils.db;

import oracle.dmt.dataminer.core.utils.db.DbVersions;
import oracle.javatools.util.Version;

public class DbVersionHelper {
    public static boolean isDB112(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V11_2_0_0, version, false, 2);
        return bl;
    }

    public static boolean isDB112Up(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V11_2_0_0, version, true, 2);
        return bl;
    }

    public static boolean isDB11201(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V11_2_0_1, version, false, 0);
        return bl;
    }

    public static boolean isDB11202(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V11_2_0_2, version, false, 0);
        return bl;
    }

    public static boolean isDB11202Up(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V11_2_0_2, version, true, 0);
        return bl;
    }

    public static boolean isDB11203Up(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V11_2_0_3, version, true, 0);
        return bl;
    }

    public static boolean isDB11204Up(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V11_2_0_4, version, true, 0);
        return bl;
    }

    public static boolean isDB121(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V12_1_0_0, version, false, 2);
        return bl;
    }

    public static boolean isDB121Up(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V12_1_0_0, version, true, 2);
        return bl;
    }

    public static boolean isDB12102Up(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V12_1_0_2, version, true, 0);
        return bl;
    }

    public static boolean isDB122Up(Version version) {
        boolean bl = DbVersionHelper.isDatabaseVersion(DbVersions.V12_2_0_0, version, true, 2);
        return bl;
    }

    private static boolean isDatabaseVersion(DbVersions dbVersions, Version version, boolean bl, int n) {
        assert (n < 5 && n >= 0);
        assert (dbVersions != null && version != null) : "Versions can't be null";
        if (n == 0) {
            int n2 = dbVersions.get().compareTo((Object)version);
            return bl ? n2 <= 0 : n2 == 0;
        }
        int[] nArray = version.toIntArray();
        int[] nArray2 = dbVersions.get().toIntArray();
        for (int i = 0; i < n; ++i) {
            if (bl && nArray2[i] < nArray[i]) {
                return true;
            }
            if (!bl ? nArray2[i] == nArray[i] : nArray2[i] <= nArray[i]) continue;
            return false;
        }
        return true;
    }
}

