/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.utils.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.metadata.GetIsMultiByteDatabaseQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.metadata.GetTableColumnDefinitionQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.metadata.GetTableColumnsDataTypeQuery;
import oracle.dmt.dataminer.core.model.common.ColumnDataRow;
import oracle.dmt.dataminer.core.utils.Arrays;
import oracle.dmt.dataminer.core.utils.Strings;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Pair;
import oracle.javatools.util.Version;

public class DbMetadataUtils {
    public static final String ESCAPE_STRING = " ESCAPE '@' ";
    public static final String EXCLUDE_TABLES_STRING = "TABLE_NAME NOT LIKE 'BIN$%'AND TABLE_NAME NOT LIKE 'DM$%'AND TABLE_NAME NOT LIKE 'DM4J$%'AND TABLE_NAME NOT LIKE 'DR$%'AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'Z__@___@___@___%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMNUM@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'EUL_GW_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'SYS_IOT_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMCAT@_%' ESCAPE '@' AND TABLE_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND TABLE_NAME NOT LIKE 'DM$%' ESCAPE '@' ";
    public static final String EXCLUDE_VIEWS_STRING = "VIEW_NAME NOT LIKE 'DM$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'DR$%'  ESCAPE '@' AND VIEW_NAME NOT LIKE 'ODMR$%' ESCAPE '@'  AND VIEW_NAME NOT LIKE 'DM4J$%'  ESCAPE '@' ";
    public static final String ATTRIBUTE_TYPE_CATEGORICAL = "Categorical";
    public static final String ATTRIBUTE_TYPE_NUMERICAL = "Numerical";
    public static final String ATTRIBUTE_TYPE_TEXT = "Text";
    public static final String ATTRIBUTE_TYPE_TEXT_CUSTOM = "TextCustom";
    public static final String ATTRIBUTE_TYPE_MIXED = "Mixed";
    public static final String ATTRIBUTE_TYPE_PARTITION = "Partition";
    public static final String ATTRIBUTE_TYPE_NESTED_NUMERICALS = "Numerical";
    public static final String ATTRIBUTE_TYPE_NESTED_CATEGORICALS = "Categorical";
    public static final String ATTRIBUTE_TYPE_ODMR_HISTOGRAMS = "Categorical";
    public static final String ATTRIBUTE_TYPE_NOT_APPLICABLE = "NotApplicable";
    public static final String ORACLE_VARCHAR2 = "VARCHAR2";
    public static final String ORACLE_CHAR = "CHAR";
    public static final String ORACLE_NVARCHAR2 = "NVARCHAR2";
    public static final String ORACLE_NCHAR = "NCHAR";
    public static final String ORACLE_FLOAT = "FLOAT";
    public static final String ORACLE_NUMBER = "NUMBER";
    public static final String ORACLE_INTEGER = "INTEGER";
    public static final String ORACLE_BINARY_DOUBLE = "BINARY_DOUBLE";
    public static final String ORACLE_BINARY_FLOAT = "BINARY_FLOAT";
    public static final String ORACLE_DATE = "DATE";
    public static final String ORACLE_BFILE = "BFILE";
    public static final String ORACLE_BFILE_MINING_DATA_TYPE = "114";
    public static final String ORACLE_XMLTYPE = "XMLTYPE";
    public static final String ORACLE_URITYPE = "URITYPE";
    public static final String ORACLE_BLOB = "BLOB";
    public static final String ORACLE_CLOB = "CLOB";
    public static final String ORACLE_NCLOB = "NCLOB";
    public static final String ORACLE_LONG = "LONG";
    public static final String ORACLE_RAW = "RAW";
    public static final String ORACLE_LONG_RAW = "LONG RAW";
    public static final String ORACLE_ROWID = "ROWID";
    public static final String ORACLE_ROWID_DATA_TYPE_CODE = "11";
    public static final String ORACLE_UROWID = "UROWID";
    public static final String ORACLE_UROWID_DATA_TYPE_CODE = "208";
    public static final String ORACLE_NESTED_NUMERICALS = "DM_NESTED_NUMERICALS";
    public static final String ORACLE_NESTED_CATEGORICALS = "DM_NESTED_CATEGORICALS";
    public static final String ORACLE_NESTED_BINARY_DOUBLES = "DM_NESTED_BINARY_DOUBLES";
    public static final String ORACLE_NESTED_BINARY_FLOATS = "DM_NESTED_BINARY_FLOATS";
    public static final String ODMR_HISTOGRAMS = "ODMR_HISTOGRAMS";
    public static final String ORACLE_NESTED_VARCHAR2 = "ODMR_NESTED_VARCHAR2";
    public static final String ORACLE_NESTED_NVARCHAR2 = "ODMR_NESTED_NVARCHAR2";
    public static final String ODMR_HISTOGRAMS_EX = "ODMR_HISTOGRAMS_EX";
    public static final String ORACLE_NESTED_VARCHAR2_EX = "ODMR_NESTED_VARCHAR2_EX";
    public static final String ORACLE_NESTED_NVARCHAR2_EX = "ODMR_NESTED_NVARCHAR2_EX";
    public static final String ORACLE_NESTED_CHAR = "ODMR_NESTED_CHAR";
    public static final String ORACLE_NESTED_NCHAR = "ODMR_NESTED_NCHAR";
    public static final String ORACLE_NESTED_TABLE = "NESTED TABLE";
    public static final String ORACLE_NUMBER_TX = "DM_NESTED_NUMERICALS";
    public static final String ORACLE_VARCHAR2_TX = "DM_NESTED_CATEGORICALS";
    public static final String ORACLE_TIMESTAMP = "TIMESTAMP";
    public static final String ORACLE_TIMSTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    public static final String ORACLE_TIMSTAMP_WITH_LOCAL_TIME_ZONE = "TIMESTAMP WITH LOCAL TIME ZONE";
    private static final String _WITH_TIMEZONE = "WITH TIME ZONE";
    private static final String _WITH_LOCAL_TIMEZONE = "WITH LOCAL TIME ZONE";
    private static final String[] _INTERVAL_YEAR_TO_MONTH = new String[]{"INTERVAL YEAR", "TO MONTH"};
    private static final String[] _INTERVAL_DAY_TO_SECOND = new String[]{"INTERVAL DAY", "TO SECOND"};
    public static final String JSON_OBJECT = "OBJECT";
    public static final String JSON_ARRAY = "ARRAY";
    public static final String JSON_NUMBER = "NUMBER";
    public static final String JSON_STRING = "STRING";
    public static final String JSON_BOOLEAN = "BOOLEAN";
    public static final String JSON_NULL = "NULL";
    public static final String JSON_BOOLEAN_TRUE = "true";
    public static final String JSON_BOOLEAN_FALSE = "false";
    public static final String JSON_NULL_VALUE = "null";
    public static final String JSON_VARCHAR2 = "JSON(VARCHAR2)";
    public static final String JSON_NVARCHAR2 = "JSON(NVARCHAR2)";
    public static final String JSON_CLOB = "JSON(CLOB)";
    public static final String JSON_NCLOB = "JSON(NCLOB)";
    public static final String JSON_BLOB = "JSON(BLOB)";
    public static final String JSON_RAW = "JSON(RAW)";
    private static final String[] ORACLE_DATA_TYPES_SUPPORTED = new String[]{"VARCHAR2", "CHAR", "NVARCHAR2", "NCHAR", "FLOAT", "NUMBER", "BINARY_DOUBLE", "BINARY_FLOAT", "DATE", "BLOB", "CLOB", "NCLOB", "BFILE", "DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "DM_NESTED_BINARY_DOUBLES", "DM_NESTED_BINARY_FLOATS", "XMLTYPE", "RAW", "ROWID", "UROWID", "URITYPE"};
    private static final String[] JSON_DATA_TYPES_SUPPORTED = new String[]{"JSON(VARCHAR2)", "JSON(NVARCHAR2)", "JSON(CLOB)", "JSON(NCLOB)", "JSON(BLOB)", "JSON(RAW)"};
    private static final Map<String, String> JSON_DATA_TYPES_MAP = new HashMap<String, String>();
    private static final String[] ORACLE_COMPATIBLE_CHARACTER_TYPES;
    private static final String[] ORACLE_COMPATIBLE_TIMESTAMP_TYPES;
    private static final String[] ORACLE_COMPATIBLE_NUMBER_TYPES;
    private static final String[] ORACLE_NESTED_TYPES_SUPPORTED;
    private static final String[] ORACLE_NESTED_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_NUMERIC_DATA_TYPES_SUPPORTED;
    private static final String[] ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12;
    private static final String[] CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED;
    private static final String[] CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_DYNAMIC_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12;
    private static final String[] NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED;
    private static final String[] NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_KEY_DATA_TYPES_SUPPORTED;
    private static final String[] ORACLE_CASE_DATA_TYPES_SUPPORTED;
    private static final String[] ORACLE_CASE_DATA_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_DYNAMIC_CASE_DATA_TYPES_SUPPORTED_12;
    private static final String[] ORACLE_INDEX_NOT_SUPPORTED;
    private static final String[] ORACLE_TEXT_DATA_TYPES_SUPPORTED;
    private static final String[] ORACLE_PARTITION_KEY_DATA_TYPES_SUPPORTED;

    public static boolean isTargetNumericalDataTypeSupported(Version version, String string) {
        String[] stringArray = DbVersionHelper.isDB121Up(version) ? NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED_12 : NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED;
        boolean bl = Arrays.contains(stringArray, string);
        return bl;
    }

    public static boolean isTargetCategoricalDataTypeSupported(Version version, String string) {
        String[] stringArray = DbVersionHelper.isDB121Up(version) ? CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12 : CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED;
        boolean bl = Arrays.contains(stringArray, string);
        return bl;
    }

    public static boolean isDynamicTargetDataTypeSupported(String string) {
        boolean bl = Arrays.contains(NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED_12, string);
        if (!bl) {
            bl = Arrays.contains(ORACLE_DYNAMIC_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12, string);
        }
        return bl;
    }

    public static boolean isBinningNumericDataTypeSupported(String string) {
        boolean bl = Arrays.contains(NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED_12, string);
        return bl;
    }

    public static String getColumnDataType(ConnectionManager connectionManager, String string, String string2, String string3) throws ODMrDAOException {
        assert (string != null) : "Owner can't be null";
        assert (string2 != null) : "Table can't be null";
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        Optional<Pair<String, String>> optional = sqlDataAccessObject.readItem(new GetTableColumnsDataTypeQuery(string, string2).setColumnName(string3));
        if (optional.isPresent()) {
            Pair<String, String> pair = optional.get();
            return (String)pair.getSecond();
        }
        return "";
    }

    public static Map<String, String> getColumnDataTypes(ConnectionManager connectionManager, String string, String string2) throws ODMrDAOException {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        List<Pair<String, String>> list = sqlDataAccessObject.readItems(new GetTableColumnsDataTypeQuery(string, string2));
        Map<String, String> map = list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        return map;
    }

    public static List<ColumnDataRow> getTableColumnDefinition(ConnectionManager connectionManager, String string, String string2) throws ODMrDAOException {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        List<ColumnDataRow> list = sqlDataAccessObject.readItems(new GetTableColumnDefinitionQuery(string, string2));
        return list;
    }

    public static boolean isMultiByteDatabase(ConnectionManager connectionManager) throws ODMrDAOException {
        SqlDataAccessObject sqlDataAccessObject = new SqlDataAccessObject(connectionManager);
        return sqlDataAccessObject.readItem(new GetIsMultiByteDatabaseQuery()).orElse(false);
    }

    public static StringBuilder clobToStringBuilder(Clob clob) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        if (clob == null) {
            return stringBuilder;
        }
        InputStream inputStream = clob.getAsciiStream();
        if (inputStream == null) {
            return stringBuilder;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append(Strings.NEW_LINE);
            }
        }
        catch (IOException iOException) {
            stringBuilder.setLength(0);
        }
        return stringBuilder;
    }

    static {
        JSON_DATA_TYPES_MAP.put(JSON_VARCHAR2, ORACLE_VARCHAR2);
        JSON_DATA_TYPES_MAP.put(JSON_NVARCHAR2, ORACLE_NVARCHAR2);
        JSON_DATA_TYPES_MAP.put(JSON_CLOB, ORACLE_CLOB);
        JSON_DATA_TYPES_MAP.put(JSON_NCLOB, ORACLE_NCLOB);
        JSON_DATA_TYPES_MAP.put(JSON_BLOB, ORACLE_BLOB);
        JSON_DATA_TYPES_MAP.put(JSON_RAW, ORACLE_RAW);
        ORACLE_COMPATIBLE_CHARACTER_TYPES = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_NVARCHAR2, ORACLE_NCHAR, ORACLE_BLOB, ORACLE_CLOB, ORACLE_NCLOB};
        ORACLE_COMPATIBLE_TIMESTAMP_TYPES = new String[]{ORACLE_TIMESTAMP, ORACLE_TIMSTAMP_WITH_TIME_ZONE, ORACLE_TIMSTAMP_WITH_LOCAL_TIME_ZONE};
        ORACLE_COMPATIBLE_NUMBER_TYPES = new String[]{"NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT, ORACLE_FLOAT};
        ORACLE_NESTED_TYPES_SUPPORTED = new String[]{"DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS"};
        ORACLE_NESTED_TYPES_SUPPORTED_12 = new String[]{"DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS", ORACLE_NESTED_BINARY_DOUBLES, ORACLE_NESTED_BINARY_FLOATS};
        ORACLE_NUMERIC_DATA_TYPES_SUPPORTED = new String[]{ORACLE_FLOAT, "NUMBER"};
        ORACLE_NUMERIC_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT};
        CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, "NUMBER", ORACLE_FLOAT, ORACLE_CHAR};
        CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_VARCHAR2, "NUMBER", ORACLE_FLOAT, ORACLE_CHAR, ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT};
        ORACLE_DYNAMIC_CATEGORICAL_TARGETS_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_VARCHAR2, ORACLE_NVARCHAR2, "NUMBER", ORACLE_FLOAT, ORACLE_CHAR, ORACLE_NCHAR, ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT};
        NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED = new String[]{ORACLE_FLOAT, "NUMBER"};
        NUMERICAL_TARGETS_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT};
        ORACLE_KEY_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_NVARCHAR2, ORACLE_NCHAR, ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT, ORACLE_DATE, ORACLE_TIMESTAMP, ORACLE_TIMSTAMP_WITH_TIME_ZONE, ORACLE_TIMSTAMP_WITH_LOCAL_TIME_ZONE};
        ORACLE_CASE_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_FLOAT, "NUMBER", ORACLE_RAW, ORACLE_ROWID, ORACLE_UROWID};
        ORACLE_CASE_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT, ORACLE_RAW, ORACLE_ROWID, ORACLE_UROWID};
        ORACLE_DYNAMIC_CASE_DATA_TYPES_SUPPORTED_12 = new String[]{ORACLE_VARCHAR2, ORACLE_NVARCHAR2, ORACLE_CHAR, ORACLE_NCHAR, ORACLE_FLOAT, "NUMBER", ORACLE_BINARY_DOUBLE, ORACLE_BINARY_FLOAT};
        ORACLE_INDEX_NOT_SUPPORTED = new String[]{ORACLE_XMLTYPE, ORACLE_CLOB, ORACLE_BLOB, ORACLE_NCLOB, "DM_NESTED_NUMERICALS", "DM_NESTED_CATEGORICALS"};
        ORACLE_TEXT_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, ORACLE_NVARCHAR2, ORACLE_NCHAR, ORACLE_CLOB, ORACLE_BLOB, ORACLE_NCLOB, ORACLE_BFILE};
        ORACLE_PARTITION_KEY_DATA_TYPES_SUPPORTED = new String[]{ORACLE_VARCHAR2, ORACLE_CHAR, "NUMBER"};
    }
}

