/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.utils;

import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import oracle.dmt.dataminer.core.utils.DefaultNameGenerator;
import oracle.dmt.dataminer.core.utils.ObjectUtils;
import oracle.dmt.dataminer.core.utils.Patterns;
import oracle.dmt.dataminer.core.utils.db.DbReservedWords;
import oracle.i18n.text.OraUnicodeProperty;

public class StringUtils {
    private static final Logger LOGGER = Logger.getLogger(StringUtils.class.getName());
    private static final String ROWID = "ROWID";
    private static final char DOUBLE_QUOTE_CHAR = '\"';
    private static final char DOLLAR_SIGN_CHAR = '$';
    private static final char POUND_SIGN_CHAR = '#';
    private static final char UNERSCORE_CHAR = '_';
    private static final char DOT_CHAR = '.';
    public static final String EMPTY = "";
    public static final String FORMAT_DECIMAL = "%d";
    public static final String FORMAT_REPLACEMENT = "{$%s}";
    public static final String FORMAT_PARENTHESES = "(%s)";
    public static final String FORMAT_COLON = "%s:";

    public static char stripFirstCharFromString(String string) {
        char c = 'Z';
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string.length() > 0) {
            c = stringBuilder.charAt(0);
        }
        return c;
    }

    public static boolean isDoubleQuotedString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("\"") && string.endsWith("\"");
    }

    public static boolean areEqual(String string, String string2) {
        return ObjectUtils.areEqual(string, string2);
    }

    public static String addSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return "'" + string + "'";
    }

    public static String addParentheses(String string) {
        if (StringUtils.isEmpty(string)) {
            return EMPTY;
        }
        return String.format(FORMAT_PARENTHESES, string);
    }

    public static String addColon(String string) {
        if (StringUtils.isEmpty(string)) {
            return EMPTY;
        }
        return String.format(FORMAT_COLON, string);
    }

    public static String addDoubleQuotes(String string) {
        if (string == null) {
            return string;
        }
        return "\"" + string + "\"";
    }

    public static String formatReplacement(String string) {
        if (StringUtils.isEmpty(string)) {
            return EMPTY;
        }
        return String.format(FORMAT_REPLACEMENT, string);
    }

    public static String trimDoubleQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isSingleQuotedString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("'") && string.endsWith("'") && string.length() > 1;
    }

    public static String trimSingleQuotes(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String removeBlankLines(String string) {
        if (string == null) {
            return string;
        }
        String string2 = string.replaceAll("\n{2,}", "\n");
        string2 = string2.replaceAll("\r\n{2,}", "\r\n");
        string2 = string2.replaceAll("\r{2,}", "\r");
        return string2;
    }

    public static String getReplacedString(String string, String string2, String string3) {
        if (string == null) {
            return EMPTY;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.length() > 0) {
            int n2 = string.indexOf(string2, n);
            while (n2 >= 0) {
                stringBuilder.append(string.substring(n, n2));
                stringBuilder.append(string3);
                n = n2 + string2.length();
                n2 = string.indexOf(string2, n);
            }
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    public static String getReplacedString(String string, Map<String, String> map) {
        Matcher matcher = Patterns.REPLACE_HOLDER.matcher(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (matcher.find()) {
            String string2 = map.get(matcher.group(1));
            stringBuilder.append(string.substring(n, matcher.start()));
            if (string2 == null) {
                stringBuilder.append(matcher.group(0));
            } else {
                stringBuilder.append(string2);
            }
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n, string.length()));
        return stringBuilder.toString();
    }

    public static String removeSectionFromText(String string, String string2) {
        if (string == null) {
            return EMPTY;
        }
        if (StringUtils.isEmpty(string2)) {
            return string;
        }
        Matcher matcher = Patterns.REPLACE_HOLDER.matcher(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = 0;
        block0: while (matcher.find()) {
            if (!matcher.group(1).equals(string2)) continue;
            n = matcher.start();
            while (matcher.find()) {
                if (!matcher.group(1).equals(string2)) continue;
                stringBuilder.append(string.substring(n2, n));
                n2 = matcher.end();
                continue block0;
            }
        }
        stringBuilder.append(string.substring(n2, string.length()));
        return stringBuilder.toString();
    }

    public static String getReplacedString(String string, String string2) {
        Matcher matcher = Patterns.REPLACE_HOLDER.matcher(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (matcher.find()) {
            stringBuilder.append(string.substring(n, matcher.start()));
            if (string2 == null) {
                stringBuilder.append(matcher.group(0));
            } else {
                stringBuilder.append(string2);
            }
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n, string.length()));
        return stringBuilder.toString();
    }

    public static String escapeCharacterForSQLScript(String string, String string2) {
        return StringUtils.getReplacedString(string, string2, "\\" + string2);
    }

    public static String escapeSingleQuotesForSQL(String string) {
        return StringUtils.getReplacedString(string, "'", "''");
    }

    public static String processQuotedName(String string) {
        String string2 = StringUtils.trimDoubleQuotes(string);
        string2 = StringUtils.getReplacedString(string2, "'", "''");
        return string2;
    }

    public static String getTargetUserFromProxyTNSUser(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (string.length() > 0) {
                int n = 0;
                int n2 = 0;
                n = string.lastIndexOf("[");
                n2 = string.lastIndexOf("]");
                if (n > 0 && n2 > 0 && n < n2 && n2 + 1 == string.length()) {
                    stringBuffer.append(string.subSequence(n + 1, n2));
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static ArrayList<String> chopString(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3;
            for (n3 = Math.min(n + i, n2); n3 < n2 - 1 && string.charAt(n3 + 1) == '\''; ++n3) {
            }
            String string2 = string.substring(i, n3);
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean checkStringLength(String string, int n) {
        if (string == null) {
            return false;
        }
        return string.length() <= n;
    }

    public static char getMnemonic(String string) {
        assert (string.length() == 1) : "Mnemonic key length not equal to 1.";
        return string.charAt(0);
    }

    public static String createFullyQualifiedName(String string, String string2) {
        String string3 = StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string));
        String string4 = string3 + "." + StringUtils.addDoubleQuotes(StringUtils.processQuotedName(string2));
        return string4;
    }

    public static String createNonQuotedCompliantName(String string) {
        String string2 = string.trim();
        char[] cArray = string2.toUpperCase().toCharArray();
        char[] cArray2 = new char[string2.length()];
        cArray2[0] = !Character.isLetter(cArray[0]) ? 65 : cArray[0];
        char c = ' ';
        for (int i = 1; i < cArray.length; ++i) {
            c = cArray[i];
            cArray2[i] = cArray[i];
            if (!Character.isLetterOrDigit(c)) {
                if (c == '$' || c == '#' || c == '_') continue;
                cArray2[i] = 95;
                continue;
            }
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            cArray2[i] = 95;
        }
        String string3 = new String(cArray2);
        StringBuilder stringBuilder = new StringBuilder(string3);
        while (StringUtils.isDBReservedWord(stringBuilder.toString())) {
            stringBuilder.append("1");
        }
        return stringBuilder.toString();
    }

    public static boolean isDBReservedWord(String string) {
        return DbReservedWords.isReservedWord(string);
    }

    public static boolean isValidNonQuotedDBObjectName(String string) {
        boolean bl = true;
        boolean bl2 = bl = !StringUtils.isDBReservedWord(string);
        if (bl) {
            bl = StringUtils.containsOnlyValidDBNameCharacters(string);
        }
        return bl;
    }

    public static boolean isValidQuotedDBObjectName(String string) {
        boolean bl = true;
        boolean bl2 = bl = !StringUtils.isDBReservedWord(string);
        if (bl) {
            bl = StringUtils.containsNoDoubleQuotes(string);
        }
        return bl;
    }

    public static boolean isEqualToROWID(String string) {
        boolean bl = false;
        if (string.equals(ROWID)) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsNoDoubleQuotes(String string) {
        int n = 32;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 34) continue;
            return false;
        }
        return true;
    }

    public static boolean containsDoubleQuote(String string) {
        boolean bl = false;
        if (string.lastIndexOf(34) != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsSingleQuote(String string) {
        boolean bl = false;
        if (string.lastIndexOf("'") != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsNoDot(String string) {
        int n = 32;
        for (int i = 1; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n != 46) continue;
            return false;
        }
        return true;
    }

    public static boolean hasMultibyteCharactes(String string) {
        boolean bl = false;
        char c = ' ';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (!StringUtils.isMultibyteChar(c)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isMultibyteChar(char c) {
        boolean bl = false;
        char[] cArray = new char[]{c};
        int n = Character.codePointAt(cArray, 0);
        OraUnicodeProperty oraUnicodeProperty = OraUnicodeProperty.getInstance();
        try {
            int n2 = oraUnicodeProperty.getDisplayWidth(n, "EN_US", false);
            if (n2 != 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return bl;
    }

    public static boolean containsOnlyValidDBNameCharacters(String string) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            return bl;
        }
        bl = Character.isLetter(string.charAt(0));
        if (bl) {
            char c = ' ';
            for (int i = 1; i < string.length() && bl; ++i) {
                c = string.charAt(i);
                if (StringUtils.isValidDBNameCharacter(c)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isValidDBNameCharacter(char c) {
        boolean bl = true;
        if (!Character.isLetterOrDigit(c)) {
            if (c != '$' && c != '#' && c != '_') {
                bl = false;
            }
        } else if (Character.isLetter(c) && Character.isLowerCase(c)) {
            bl = false;
        }
        return bl;
    }

    public static String generateUniqueName(String string, HashMap hashMap) {
        String string2 = string;
        if (string2.length() > 26) {
            string2 = string2.substring(0, 26);
        }
        String string3 = string2;
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(string3, EMPTY, false);
        string2 = defaultNameGenerator.nextName();
        boolean bl = true;
        do {
            boolean bl2;
            if (bl2 = hashMap.containsKey(string2)) {
                String string4;
                string2 = string4 = defaultNameGenerator.nextName();
                continue;
            }
            bl = false;
        } while (bl);
        return string2;
    }

    public static final boolean isEmpty(String string) {
        return string == null || EMPTY.equals(string);
    }

    public static final boolean isNotEmpty(String string) {
        return string != null && !EMPTY.equals(string);
    }

    public static final String toSqlList(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(20 * stringArray.length);
        for (String string : stringArray) {
            stringBuilder.append("'");
            stringBuilder.append(string);
            stringBuilder.append("',");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static String join(String string, List<String> list) {
        if (list == null || list.isEmpty()) {
            return EMPTY;
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            if (StringUtils.isEmpty(string2)) continue;
            if (!bl) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(string2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String join(String string, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return EMPTY;
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (StringUtils.isEmpty(string2)) continue;
            if (!bl) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append(string2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String getQualifiedName(String string, String string2, boolean bl) {
        assert (!StringUtils.isEmpty(string)) : "Owner Cannot be Null.";
        assert (!StringUtils.isEmpty(string2)) : "Source Table Cannot be Null.";
        String string3 = String.format("\"%s\".\"%s\"", string, string2);
        return bl ? StringUtils.escapeSingleQuotesForSQL(string3) : string3;
    }

    public static String toString(Object object) {
        String string = EMPTY;
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public static String toString(Object object, String string) {
        String string2 = string;
        if (object != null) {
            string2 = object.toString();
        }
        return string2;
    }

    public static String cleanQuotedString(String string) {
        assert (StringUtils.isNotEmpty(string)) : "The string cannot be empty or null";
        String string2 = string;
        if (StringUtils.isDoubleQuotedString(string)) {
            string2 = StringUtils.trimDoubleQuotes(string);
        } else if (StringUtils.isSingleQuotedString(string)) {
            string2 = StringUtils.trimSingleQuotes(string);
        }
        return string2;
    }

    public static <T> String joinElementsByComma(List<T> list, Function<T, String> function) {
        return list.stream().map(function).collect(Collectors.joining(","));
    }

    public static <T> String joinElementsByComma(T[] TArray, Function<T, String> function) {
        return Arrays.stream(TArray).map(function).collect(Collectors.joining(","));
    }

    public static String insertPrefix(String string, String string2) {
        assert (StringUtils.isNotEmpty(string2) && StringUtils.isNotEmpty(string)) : "Prefix and content cannot be null.";
        return string2.concat(string);
    }

    public static boolean hasMultiByteCharacters(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            String string2 = Character.toString(c);
            byte[] byArray = string2.getBytes(StandardCharsets.UTF_8);
            if (byArray.length <= 1) continue;
            return true;
        }
        return false;
    }

    public static Optional<Number> parseNumber(String string) {
        Optional<Number> optional = Optional.empty();
        try {
            Number number = NumberFormat.getNumberInstance().parse(string);
            optional = Optional.of(number);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return optional;
    }
}

