/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.utils;

public class DebugTimer {
    private long startTime;
    private long elapsedTime;
    private boolean started;

    public DebugTimer start() {
        if (this.started) {
            throw new IllegalStateException("Timer is already running");
        }
        this.startTime = System.currentTimeMillis();
        this.started = true;
        return this;
    }

    public DebugTimer stop() {
        if (!this.started) {
            throw new IllegalStateException("Timer must be started first");
        }
        long l = System.currentTimeMillis();
        this.elapsedTime = l - this.startTime;
        return this;
    }

    public DebugTimer reset() {
        this.started = false;
        this.startTime = 0L;
        this.elapsedTime = 0L;
        return this;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }
}

