/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.generated.server;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import oracle.dmt.dataminer.core.model.generated.server.OdmrApplySettings;
import oracle.dmt.dataminer.core.model.generated.server.OdmrAttrUsages;
import oracle.dmt.dataminer.core.model.generated.server.OdmrBuildSettings;
import oracle.dmt.dataminer.core.model.generated.server.OdmrCostMatrix;
import oracle.dmt.dataminer.core.model.generated.server.OdmrImpactReports;
import oracle.dmt.dataminer.core.model.generated.server.OdmrModelBuilds;
import oracle.dmt.dataminer.core.model.generated.server.OdmrObjectIds;
import oracle.dmt.dataminer.core.model.generated.server.OdmrPrior;
import oracle.dmt.dataminer.core.model.generated.server.OdmrTableColumns;
import oracle.dmt.dataminer.core.model.generated.server.OdmrTestSettings;
import oracle.dmt.dataminer.core.model.generated.server.OdmrWeight;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ORAData;

public class ODMRPkg_Activity {
    protected Connection __onn = null;
    protected DataSource __dataSource = null;

    public void setDataSource(DataSource dataSource) throws SQLException {
        this.release();
        this.__dataSource = dataSource;
    }

    public void setDataSourceLocation(String string) throws SQLException {
        try {
            Class<?> clazz = Class.forName("javax.naming.InitialContext");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("lookup", String.class);
            DataSource dataSource = (DataSource)method.invoke(obj, "java:comp/env/" + string);
            this.setDataSource(dataSource);
        }
        catch (Exception exception) {
            throw new SQLException("Error initializing DataSource at " + string + ": " + exception.getMessage());
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.__onn != null) {
            return this.__onn;
        }
        if (this.__dataSource != null) {
            this.__onn = this.__dataSource.getConnection();
        }
        return this.__onn;
    }

    public void release() throws SQLException {
        this.__onn = null;
        this.__dataSource = null;
    }

    public void closeConnection() {
        if (this.__dataSource != null) {
            try {
                if (this.__onn != null) {
                    this.__onn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.__onn = null;
        }
    }

    public void setConnection(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public ODMRPkg_Activity() throws SQLException {
    }

    public ODMRPkg_Activity(Connection connection) throws SQLException {
        this.__onn = connection;
    }

    public ODMRPkg_Activity(DataSource dataSource) throws SQLException {
        this.__dataSource = dataSource;
    }

    public void setModelBuildSetting(BigDecimal bigDecimal, OdmrBuildSettings odmrBuildSettings) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_BUILD_SETTING(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrBuildSettings == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_BUILD_SETTINGS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrBuildSettings);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_BUILD_SETTING(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrBuildSettings == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_BUILD_SETTINGS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrBuildSettings);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelApplyData(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_APPLY_DATA(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 1);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_APPLY_DATA(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 1);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelTestData(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_TEST_DATA(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 1);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_TEST_DATA(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 1);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public OdmrImpactReports deleteActivity(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, String string) throws SQLException {
        Connection connection = null;
        OdmrImpactReports odmrImpactReports = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.DELETE_ACTIVITY(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 1);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.DELETE_ACTIVITY(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 1);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrImpactReports;
    }

    public OdmrImpactReports deleteActivity(BigDecimal bigDecimal, BigDecimal bigDecimal2, String string) throws SQLException {
        Connection connection = null;
        OdmrImpactReports odmrImpactReports = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.DELETE_ACTIVITY(:2 ,:3 ,:4 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(4, 1);
            } else {
                oracleCallableStatement.setString(4, string);
            }
            oracleCallableStatement.executeUpdate();
            odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.DELETE_ACTIVITY(:2 ,:3 ,:4 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_IMPACT_REPORTS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(4, 1);
                } else {
                    oracleCallableStatement.setString(4, string);
                }
                oracleCallableStatement.executeUpdate();
                odmrImpactReports = (OdmrImpactReports)oracleCallableStatement.getORAData(1, OdmrImpactReports.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrImpactReports;
    }

    public void renameActivityModel(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.RENAME_ACTIVITY_MODEL(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.RENAME_ACTIVITY_MODEL(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelDataUsage(BigDecimal bigDecimal, OdmrAttrUsages odmrAttrUsages) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_DATA_USAGE(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrAttrUsages == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_ATTR_USAGES");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrAttrUsages);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_DATA_USAGE(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrAttrUsages == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_ATTR_USAGES");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrAttrUsages);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void renameActivity(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.RENAME_ACTIVITY(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.RENAME_ACTIVITY(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void stopActivity(BigDecimal bigDecimal) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.STOP_ACTIVITY(:1 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.STOP_ACTIVITY(:1 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelApplySupplAttrs(BigDecimal bigDecimal, OdmrTableColumns odmrTableColumns) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_APPLY_SUPPL_ATTRS(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrTableColumns == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrTableColumns);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_APPLY_SUPPL_ATTRS(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrTableColumns == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrTableColumns);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelCostBenefit(BigDecimal bigDecimal, OdmrCostMatrix odmrCostMatrix, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_COST_BENEFIT(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrCostMatrix == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_COST_MATRIX");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrCostMatrix);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_COST_BENEFIT(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrCostMatrix == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_COST_MATRIX");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrCostMatrix);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void enableModelCostBenefit(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.ENABLE_MODEL_COST_BENEFIT(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 1);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.ENABLE_MODEL_COST_BENEFIT(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 1);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelTestSetting(BigDecimal bigDecimal, OdmrTestSettings odmrTestSettings) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_TEST_SETTING(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrTestSettings == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_TEST_SETTINGS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrTestSettings);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_TEST_SETTING(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrTestSettings == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_TEST_SETTINGS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrTestSettings);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public BigDecimal createActivity(BigDecimal bigDecimal, BigDecimal bigDecimal2, OdmrObjectIds odmrObjectIds, String string, OdmrModelBuilds odmrModelBuilds, BigDecimal bigDecimal3, String string2) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal4 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.CREATE_ACTIVITY(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ,:8 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(3, 2);
            } else {
                oracleCallableStatement.setBigDecimal(3, bigDecimal2);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(4, (ORAData)odmrObjectIds);
            }
            if (string == null) {
                oracleCallableStatement.setNull(5, 12);
            } else {
                oracleCallableStatement.setString(5, string);
            }
            if (odmrModelBuilds == null) {
                oracleCallableStatement.setNull(6, 2003, "ODMRSYS.ODMR_MODEL_BUILDS");
            } else {
                oracleCallableStatement.setORAData(6, (ORAData)odmrModelBuilds);
            }
            if (bigDecimal3 == null) {
                oracleCallableStatement.setNull(7, 2);
            } else {
                oracleCallableStatement.setBigDecimal(7, bigDecimal3);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(8, 12);
            } else {
                oracleCallableStatement.setString(8, string2);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal4 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.CREATE_ACTIVITY(:2 ,:3 ,:4 ,:5 ,:6 ,:7 ,:8 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(3, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(3, bigDecimal2);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(4, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(4, (ORAData)odmrObjectIds);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(5, 12);
                } else {
                    oracleCallableStatement.setString(5, string);
                }
                if (odmrModelBuilds == null) {
                    oracleCallableStatement.setNull(6, 2003, "ODMRSYS.ODMR_MODEL_BUILDS");
                } else {
                    oracleCallableStatement.setORAData(6, (ORAData)odmrModelBuilds);
                }
                if (bigDecimal3 == null) {
                    oracleCallableStatement.setNull(7, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(7, bigDecimal3);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(8, 12);
                } else {
                    oracleCallableStatement.setString(8, string2);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal4 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal4;
    }

    public void setActivitySplitPercent(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_SPLIT_PERCENT(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_SPLIT_PERCENT(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public OdmrObjectIds addActivityModels(BigDecimal bigDecimal, OdmrModelBuilds odmrModelBuilds) throws SQLException {
        Connection connection = null;
        OdmrObjectIds odmrObjectIds = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.ADD_ACTIVITY_MODELS(:2 ,:3 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrModelBuilds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_MODEL_BUILDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrModelBuilds);
            }
            oracleCallableStatement.executeUpdate();
            odmrObjectIds = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.ADD_ACTIVITY_MODELS(:2 ,:3 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrModelBuilds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_MODEL_BUILDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrModelBuilds);
                }
                oracleCallableStatement.executeUpdate();
                odmrObjectIds = (OdmrObjectIds)oracleCallableStatement.getORAData(1, OdmrObjectIds.getORADataFactory());
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return odmrObjectIds;
    }

    public void deleteActivityModel(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.DELETE_ACTIVITY_MODEL(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.DELETE_ACTIVITY_MODEL(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void purgeActivityResults(BigDecimal bigDecimal, BigDecimal bigDecimal2, Timestamp timestamp) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.PURGE_ACTIVITY_RESULTS(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal2);
            }
            if (timestamp == null) {
                oracleCallableStatement.setNull(3, 93);
            } else {
                oracleCallableStatement.setTimestamp(3, timestamp);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.PURGE_ACTIVITY_RESULTS(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal2);
                }
                if (timestamp == null) {
                    oracleCallableStatement.setNull(3, 93);
                } else {
                    oracleCallableStatement.setTimestamp(3, timestamp);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setActivityComment(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_COMMENT(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_COMMENT(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelCostBenefit2(BigDecimal bigDecimal, OdmrCostMatrix odmrCostMatrix) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_COST_BENEFIT2(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrCostMatrix == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_COST_MATRIX");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrCostMatrix);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_COST_BENEFIT2(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrCostMatrix == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_COST_MATRIX");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrCostMatrix);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelResultSetting(BigDecimal bigDecimal, String string, String string2) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_RESULT_SETTING(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string2);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_RESULT_SETTING(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string2);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setActivityApplySupplAttrs(BigDecimal bigDecimal, OdmrTableColumns odmrTableColumns) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_APPLY_SUPPL_ATTRS(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrTableColumns == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrTableColumns);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_APPLY_SUPPL_ATTRS(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrTableColumns == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_TABLE_COLUMNS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrTableColumns);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public BigDecimal createModelLike(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        BigDecimal bigDecimal2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.CREATE_MODEL_LIKE(:2 ,:3 ); END;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            oracleCallableStatement.executeUpdate();
            bigDecimal2 = oracleCallableStatement.getBigDecimal(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.CREATE_MODEL_LIKE(:2 ,:3 ); END;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                oracleCallableStatement.executeUpdate();
                bigDecimal2 = oracleCallableStatement.getBigDecimal(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return bigDecimal2;
    }

    public void deleteActivityResults(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.DELETE_ACTIVITY_RESULTS(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrObjectIds);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.DELETE_ACTIVITY_RESULTS(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrObjectIds);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelPriors(BigDecimal bigDecimal, OdmrPrior odmrPrior, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_PRIORS(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrPrior == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_PRIOR");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrPrior);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_PRIORS(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrPrior == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_PRIOR");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrPrior);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelApplySetting(BigDecimal bigDecimal, OdmrApplySettings odmrApplySettings) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_APPLY_SETTING(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrApplySettings == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_APPLY_SETTINGS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrApplySettings);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_APPLY_SETTING(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrApplySettings == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_APPLY_SETTINGS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrApplySettings);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setTypeCaseFiltering(BigDecimal bigDecimal, String string, String string2) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_TYPE_CASE_FILTERING(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            if (string2 == null) {
                oracleCallableStatement.setNull(3, 12);
            } else {
                oracleCallableStatement.setString(3, string2);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_TYPE_CASE_FILTERING(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                if (string2 == null) {
                    oracleCallableStatement.setNull(3, 12);
                } else {
                    oracleCallableStatement.setString(3, string2);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void enableModelPrior(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.ENABLE_MODEL_PRIOR(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 1);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.ENABLE_MODEL_PRIOR(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 1);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setNodeCaseFiltering(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_NODE_CASE_FILTERING(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_NODE_CASE_FILTERING(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public String runActivity(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, BigDecimal bigDecimal2, String string, Timestamp timestamp) throws SQLException {
        Connection connection = null;
        String string2 = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.RUN_ACTIVITY(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
            oracleCallableStatement.registerOutParameter(1, 12);
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(2, 2);
            } else {
                oracleCallableStatement.setBigDecimal(2, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
            }
            if (bigDecimal2 == null) {
                oracleCallableStatement.setNull(4, 2);
            } else {
                oracleCallableStatement.setBigDecimal(4, bigDecimal2);
            }
            if (string == null) {
                oracleCallableStatement.setNull(5, 12);
            } else {
                oracleCallableStatement.setString(5, string);
            }
            if (timestamp == null) {
                oracleCallableStatement.setNull(6, 93);
            } else {
                oracleCallableStatement.setTimestamp(6, timestamp);
            }
            oracleCallableStatement.executeUpdate();
            string2 = oracleCallableStatement.getString(1);
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN :1 := ODMRSYS.ODMR_ACTIVITY.RUN_ACTIVITY(:2 ,:3 ,:4 ,:5 ,:6 ); END;");
                oracleCallableStatement.registerOutParameter(1, 12);
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(2, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(2, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(3, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(3, (ORAData)odmrObjectIds);
                }
                if (bigDecimal2 == null) {
                    oracleCallableStatement.setNull(4, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(4, bigDecimal2);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(5, 12);
                } else {
                    oracleCallableStatement.setString(5, string);
                }
                if (timestamp == null) {
                    oracleCallableStatement.setNull(6, 93);
                } else {
                    oracleCallableStatement.setTimestamp(6, timestamp);
                }
                oracleCallableStatement.executeUpdate();
                string2 = oracleCallableStatement.getString(1);
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
        return string2;
    }

    public void setModelCustomPerformance(BigDecimal bigDecimal, OdmrWeight odmrWeight) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_CUSTOM_PERFORMANCE(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrWeight == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_WEIGHT");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrWeight);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_CUSTOM_PERFORMANCE(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrWeight == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_WEIGHT");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrWeight);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setActivityTestData(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_TEST_DATA(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 1);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_TEST_DATA(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 1);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setActivityModelComment(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_MODEL_COMMENT(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 12);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_MODEL_COMMENT(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 12);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setModelSupplAttrsData(BigDecimal bigDecimal, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_SUPPL_ATTRS_DATA(:1 ,:2 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (string == null) {
                oracleCallableStatement.setNull(2, 1);
            } else {
                oracleCallableStatement.setString(2, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_MODEL_SUPPL_ATTRS_DATA(:1 ,:2 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(2, 1);
                } else {
                    oracleCallableStatement.setString(2, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }

    public void setActivityDataPreparation(BigDecimal bigDecimal, OdmrObjectIds odmrObjectIds, String string) throws SQLException {
        Connection connection = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            connection = this.getConnection();
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_DATA_PREPARATION(:1 ,:2 ,:3 ); END;");
            if (bigDecimal == null) {
                oracleCallableStatement.setNull(1, 2);
            } else {
                oracleCallableStatement.setBigDecimal(1, bigDecimal);
            }
            if (odmrObjectIds == null) {
                oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
            } else {
                oracleCallableStatement.setORAData(2, (ORAData)odmrObjectIds);
            }
            if (string == null) {
                oracleCallableStatement.setNull(3, 1);
            } else {
                oracleCallableStatement.setString(3, string);
            }
            oracleCallableStatement.executeUpdate();
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                oracleCallableStatement.close();
                if (this.__dataSource == null) {
                    throw sQLException;
                }
                connection = this.getConnection();
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("BEGIN ODMRSYS.ODMR_ACTIVITY.SET_ACTIVITY_DATA_PREPARATION(:1 ,:2 ,:3 ); END;");
                if (bigDecimal == null) {
                    oracleCallableStatement.setNull(1, 2);
                } else {
                    oracleCallableStatement.setBigDecimal(1, bigDecimal);
                }
                if (odmrObjectIds == null) {
                    oracleCallableStatement.setNull(2, 2003, "ODMRSYS.ODMR_OBJECT_IDS");
                } else {
                    oracleCallableStatement.setORAData(2, (ORAData)odmrObjectIds);
                }
                if (string == null) {
                    oracleCallableStatement.setNull(3, 1);
                } else {
                    oracleCallableStatement.setString(3, string);
                }
                oracleCallableStatement.executeUpdate();
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
            catch (SQLException sQLException2) {
                oracleCallableStatement.close();
                throw sQLException;
            }
        }
    }
}

