/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common.build;

import oracle.dmt.dataminer.core.model.common.build.Attribute;
import oracle.dmt.dataminer.core.utils.ObjectUtils;

public class AttributeBiCoefficient
extends Attribute {
    protected Double coefficient1;
    protected Double coefficient2;
    protected ComparisonLevel comparisonLevel;

    public AttributeBiCoefficient() {
        this("");
    }

    public AttributeBiCoefficient(String string) {
        this(string, "", 0.0, 0.0);
    }

    public AttributeBiCoefficient(String string, String string2) {
        this(string, null, string2);
    }

    public AttributeBiCoefficient(String string, String string2, String string3) {
        this(string, string2, string3, 0.0, 0.0);
    }

    public AttributeBiCoefficient(String string, String string2, Double d) {
        this(string, string2, d, 0.0);
    }

    public AttributeBiCoefficient(String string, String string2, Double d, Double d2) {
        this(string, null, string2, d, d2);
    }

    public AttributeBiCoefficient(String string, String string2, String string3, Double d, Double d2) {
        super(string, string2, string3);
        this.coefficient1 = d;
        this.coefficient2 = d2;
        this.comparisonLevel = ComparisonLevel.NAME;
    }

    public void setCoefficient1(Double d) {
        this.coefficient1 = d;
    }

    public Double getCoefficient1() {
        return this.coefficient1;
    }

    public void setCoefficient2(Double d) {
        this.coefficient2 = d;
    }

    public Double getCoefficient2() {
        return this.coefficient2;
    }

    public void setComparisonLevel(ComparisonLevel comparisonLevel) {
        this.comparisonLevel = comparisonLevel;
    }

    protected boolean isNameSort() {
        return ComparisonLevel.NAME.equals((Object)this.comparisonLevel);
    }

    protected boolean isNameSubnameSort() {
        return ComparisonLevel.NAME_SUBNAME.equals((Object)this.comparisonLevel);
    }

    public boolean isNameSubnameValueSort() {
        return ComparisonLevel.NAME_SUBNAME_VALUE.equals((Object)this.comparisonLevel);
    }

    public boolean isObjectSpecific() {
        return ComparisonLevel.OBJECT_SPECIFIC.equals((Object)this.comparisonLevel);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AttributeBiCoefficient)) {
            return false;
        }
        AttributeBiCoefficient attributeBiCoefficient = (AttributeBiCoefficient)object;
        if (attributeBiCoefficient.getAttributeName() != null && this.getAttributeName() != null && attributeBiCoefficient.getAttributeName().equals(this.getAttributeName())) {
            if (this.isNameSort()) {
                return true;
            }
            if (ObjectUtils.areEqual(attributeBiCoefficient.getAttributeSubname(), this.getAttributeSubname()) && this.isNameSubnameSort()) {
                return true;
            }
            if (ObjectUtils.areEqual(attributeBiCoefficient.getAttributeValue(), this.getAttributeValue())) {
                if (this.isNameSubnameSort()) {
                    return true;
                }
                return this.objectSpecificEquals(object);
            }
        }
        return false;
    }

    protected boolean objectSpecificEquals(Object object) {
        if (!(object instanceof AttributeBiCoefficient)) {
            return false;
        }
        AttributeBiCoefficient attributeBiCoefficient = (AttributeBiCoefficient)object;
        return ObjectUtils.areEqual(attributeBiCoefficient.getCoefficient1(), this.getCoefficient1()) && ObjectUtils.areEqual(attributeBiCoefficient.getCoefficient2(), this.getCoefficient2());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name:");
        stringBuilder.append(this.getAttributeName());
        stringBuilder.append(", Subname:");
        stringBuilder.append(this.getAttributeSubname());
        stringBuilder.append(", Value:");
        stringBuilder.append(this.getAttributeValue());
        stringBuilder.append(", Coeff1:");
        stringBuilder.append(this.getCoefficient1());
        stringBuilder.append(", Coeff2:");
        stringBuilder.append(this.getCoefficient2());
        return stringBuilder.toString();
    }

    public static enum ComparisonLevel {
        NAME,
        NAME_SUBNAME,
        NAME_SUBNAME_VALUE,
        OBJECT_SPECIFIC;

    }
}

