/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.clus.compare;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.dmt.dataminer.core.model.generated.server.DmHistograms;
import oracle.dmt.dataminer.core.model.graph.GraphDataModel;
import oracle.dmt.dataminer.core.utils.ObjectUtils;
import oracle.dmt.dataminer.core.utils.Patterns;

public class CompareClustersModelRow {
    private String name;
    private String subName;
    private Integer rank;
    private String centroid1;
    private String centroid2;
    private double divergence;
    private DmHistograms[] histograms;
    private Integer cluster1Id;
    private Integer cluster2Id;
    private String cluster1Label1;
    private String cluster1Label2;
    private GraphDataModel graphDataModel;

    public CompareClustersModelRow(String string) {
        this.name = string;
        this.subName = null;
        this.histograms = new DmHistograms[2];
    }

    public CompareClustersModelRow(String string, String string2, Integer n, Integer n2) {
        this.name = string;
        this.subName = string2;
        this.cluster1Id = n;
        this.cluster2Id = n2;
        this.histograms = new DmHistograms[2];
    }

    public String getFullAttributeName() {
        Object object = this.subName != null ? this.name + "." + this.subName : this.name;
        return object;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setSubName(String string) {
        this.subName = string;
    }

    public String getSubName() {
        return this.subName;
    }

    public void setFirstClusterHistogram(DmHistograms dmHistograms) {
        this.histograms[0] = dmHistograms;
    }

    public void setSecondClusterHistogram(DmHistograms dmHistograms) {
        this.histograms[1] = dmHistograms;
    }

    public DmHistograms getFirstClusterHistogram() {
        return this.histograms[0];
    }

    public DmHistograms getSecondClusterHistogram() {
        return this.histograms[1];
    }

    public void setCluster1Id(Integer n) {
        this.cluster1Id = n;
    }

    public Integer getCluster1Id() {
        return this.cluster1Id;
    }

    public void setCluster2Id(Integer n) {
        this.cluster2Id = n;
    }

    public Integer getCluster2Id() {
        return this.cluster2Id;
    }

    public void setGraphDataModel(GraphDataModel graphDataModel) {
        this.graphDataModel = graphDataModel;
    }

    public GraphDataModel getGraphDataModel() {
        return this.graphDataModel;
    }

    public void setRank(Integer n) {
        this.rank = n;
    }

    public Integer getRank() {
        return this.rank;
    }

    public void setCentroid1(String string) {
        this.centroid1 = string;
    }

    public String getCentroid1() {
        return this.centroid1;
    }

    public void setCentroid2(String string) {
        this.centroid2 = string;
    }

    public String getCentroid2() {
        return this.centroid2;
    }

    public void setDivergence(double d) {
        this.divergence = d;
    }

    public double getDivergence() {
        return this.divergence;
    }

    public void setCluster1Label1(String string) {
        this.cluster1Label1 = string;
    }

    public String getCluster1Label1() {
        return this.cluster1Label1;
    }

    public void setCluster1Label2(String string) {
        this.cluster1Label2 = string;
    }

    public String getCluster1Label2() {
        return this.cluster1Label2;
    }

    public String toString() {
        String string = "[ Name = " + this.name + ", rank = " + this.rank + ", divergence = " + this.divergence + ", Centroid1 = " + this.centroid1 + ", Centroid2 = " + this.centroid2 + "]";
        return string;
    }

    public boolean equals(Object object) {
        Object object2;
        Object object3;
        boolean bl = true;
        if (!(object instanceof CompareClustersModelRow)) {
            return false;
        }
        CompareClustersModelRow compareClustersModelRow = (CompareClustersModelRow)object;
        boolean bl2 = bl = ObjectUtils.areEqual(this.rank, compareClustersModelRow.getRank()) && ObjectUtils.areEqual(this.divergence, compareClustersModelRow.getDivergence());
        if (bl && this.centroid1 != null && compareClustersModelRow.getCentroid1() != null) {
            if (Patterns.SCIENTIFIC_NOTATION.matcher(this.centroid1).matches()) {
                object3 = new BigDecimal(this.centroid1);
                object2 = new BigDecimal(compareClustersModelRow.getCentroid1());
                if (!((BigDecimal)(object3 = ((BigDecimal)object3).setScale(12, 1))).equals(object2 = ((BigDecimal)object2).setScale(12, 1))) {
                    bl = false;
                }
            } else if (!this.centroid1.equals(compareClustersModelRow.getCentroid1())) {
                bl = false;
            }
        } else if (this.centroid1 != null || compareClustersModelRow.getCentroid1() != null) {
            bl = false;
        }
        if (bl && this.centroid2 != null && compareClustersModelRow.getCentroid2() != null) {
            if (Patterns.SCIENTIFIC_NOTATION.matcher(this.centroid2).matches()) {
                object3 = new BigDecimal(this.centroid2);
                object2 = new BigDecimal(compareClustersModelRow.getCentroid2());
                if (!((BigDecimal)(object3 = ((BigDecimal)object3).setScale(12, 1))).equals(object2 = ((BigDecimal)object2).setScale(12, 1))) {
                    bl = false;
                }
            } else if (!this.centroid2.equals(compareClustersModelRow.getCentroid2())) {
                bl = false;
            }
        } else if (bl && (this.centroid2 == null || compareClustersModelRow.getCentroid2() == null)) {
            bl = false;
        }
        if (bl) {
            object3 = new DmHistograms();
            object2 = new DmHistograms();
            try {
                object3 = this.getFirstClusterHistogram();
                object2 = compareClustersModelRow.getFirstClusterHistogram();
                if (((DmHistograms)object3).length() != ((DmHistograms)object2).length()) {
                    return false;
                }
                object3 = this.getSecondClusterHistogram();
                object2 = compareClustersModelRow.getSecondClusterHistogram();
                if (((DmHistograms)object3).length() != ((DmHistograms)object2).length()) {
                    return false;
                }
            }
            catch (SQLException sQLException) {
                return false;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 7;
        n += ObjectUtils.hashCode(this.name);
        n += ObjectUtils.hashCode(this.rank);
        n += ObjectUtils.hashCode(this.divergence);
        n += ObjectUtils.hashCode(this.centroid1);
        return n += ObjectUtils.hashCode(this.centroid2);
    }
}

