/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class GlobalDetailsQuery
extends ModelDetailsQuery {
    private static final String GLOBAL_DETAIL_NAME = "GLOBAL_DETAIL_NAME";
    private static final String GLOBAL_DETAIL_VALUE = "GLOBAL_DETAIL_VALUE";

    public GlobalDetailsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public GlobalDetailsQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {GLOBAL_DETAIL_NAME, "VARCHAR2"}, {GLOBAL_DETAIL_VALUE, "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {GLOBAL_DETAIL_NAME, "VARCHAR2"}, {GLOBAL_DETAIL_VALUE, "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\n      SELECT CAST('{$MODEL_SCHEMA_VALUE}'  AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n      CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n      PARTITION_NAME as \"{$PARTITION_NAME}\",\n      NAME as \"{$GLOBAL_DETAIL_NAME}\",\n      CASE WHEN NUMERIC_VALUE IS NULL THEN STRING_VALUE ELSE TO_CHAR(NUMERIC_VALUE) END as \"{$GLOBAL_DETAIL_VALUE}\"\n      FROM {$MODEL_SCHEMA_VALUE}.DM$VG{$MODEL_NAME_VALUE}" : "\n      SELECT CAST('{$MODEL_SCHEMA_VALUE}'  AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n      CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\n      T.global_detail_name as \"{$GLOBAL_DETAIL_NAME}\",\n      T.global_detail_value as \"{$GLOBAL_DETAIL_VALUE}\" \n      FROM TABLE(DBMS_DATA_MINING.GET_MODEL_DETAILS_GLOBAL('{$GET_MODEL_NAME}')) T";
        return string;
    }
}

