/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class GLMRCoefficientsQuery
extends ModelDetailsQuery {
    private static final String STD_ERROR = "STD_ERROR";
    private static final String TEST_STATISTIC = "TEST_STATISTIC";
    private static final String P_VALUE = "P_VALUE";
    private static final String VIF = "VIF";
    private static final String STD_COEFFICIENT = "STD_COEFFICIENT";
    private static final String LOWER_COEFF_LIMIT = "LOWER_COEFF_LIMIT";
    private static final String UPPER_COEFF_LIMIT = "UPPER_COEFF_LIMIT";
    private static final String EXP_COEFFICIENT = "EXP_COEFFICIENT";
    private static final String EXP_LOWER_COEFF_LIMIT = "EXP_LOWER_COEFF_LIMIT";
    private static final String EXP_UPPER_COEFF_LIMIT = "EXP_UPPER_COEFF_LIMIT";
    private static final String FEATURE_EXPRESSION = "FEATURE_EXPRESSION";

    public GLMRCoefficientsQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl) {
        super(version, modelDetailType, list, map, bl);
    }

    public GLMRCoefficientsQuery(Version version, ModelDetailType modelDetailType) {
        super(version, modelDetailType);
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {FEATURE_EXPRESSION, "VARCHAR2"}, {"COEFFICIENT", "NUMBER"}, {STD_ERROR, "NUMBER"}, {TEST_STATISTIC, "NUMBER"}, {P_VALUE, "NUMBER"}, {VIF, "NUMBER"}, {STD_COEFFICIENT, "NUMBER"}, {LOWER_COEFF_LIMIT, "NUMBER"}, {UPPER_COEFF_LIMIT, "NUMBER"}} : (DbVersionHelper.isDB121Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {FEATURE_EXPRESSION, "VARCHAR2"}, {"COEFFICIENT", "NUMBER"}, {STD_ERROR, "NUMBER"}, {TEST_STATISTIC, "NUMBER"}, {P_VALUE, "NUMBER"}, {VIF, "NUMBER"}, {STD_COEFFICIENT, "NUMBER"}, {LOWER_COEFF_LIMIT, "NUMBER"}, {UPPER_COEFF_LIMIT, "NUMBER"}, {EXP_COEFFICIENT, "BINARY_DOUBLE"}, {EXP_LOWER_COEFF_LIMIT, "BINARY_DOUBLE"}, {EXP_UPPER_COEFF_LIMIT, "BINARY_DOUBLE"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ATTRIBUTE_NAME", "VARCHAR2"}, {"ATTRIBUTE_SUBNAME", "VARCHAR2"}, {"ATTRIBUTE_VALUE", "VARCHAR2"}, {"COEFFICIENT", "NUMBER"}, {STD_ERROR, "NUMBER"}, {TEST_STATISTIC, "NUMBER"}, {P_VALUE, "NUMBER"}, {VIF, "NUMBER"}, {STD_COEFFICIENT, "NUMBER"}, {LOWER_COEFF_LIMIT, "NUMBER"}, {UPPER_COEFF_LIMIT, "NUMBER"}, {EXP_COEFFICIENT, "BINARY_DOUBLE"}, {EXP_LOWER_COEFF_LIMIT, "BINARY_DOUBLE"}, {EXP_UPPER_COEFF_LIMIT, "BINARY_DOUBLE"}});
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\",\n   CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\",\n   PARTITION_NAME as \"{$PARTITION_NAME}\",\n   ATTRIBUTE_NAME as \"{$ATTRIBUTE_NAME}\",\n   ATTRIBUTE_SUBNAME as \"{$ATTRIBUTE_SUBNAME}\",\n   ATTRIBUTE_VALUE as \"{$ATTRIBUTE_VALUE}\",\n   FEATURE_EXPRESSION as \"{$FEATURE_EXPRESSION}\" , \n   COEFFICIENT as \"{$COEFFICIENT}\",\n   STD_ERROR as \"{$STD_ERROR}\",\n   TEST_STATISTIC as \"{$TEST_STATISTIC}\",\n   P_VALUE as \"{$P_VALUE}\",\n   VIF as \"{$VIF}\",\n   STD_COEFFICIENT as \"{$STD_COEFFICIENT}\",\n   LOWER_COEFF_LIMIT as \"{$LOWER_COEFF_LIMIT}\",\n   UPPER_COEFF_LIMIT as \"{$UPPER_COEFF_LIMIT}\" \nFROM {$MODEL_SCHEMA_VALUE}.DM$VD{$MODEL_NAME_VALUE}" : (DbVersionHelper.isDB121Up(this.dbVersion) ? "SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\n     t.attribute_name as \"{$ATTRIBUTE_NAME}\",\n     t.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\",\n     t.attribute_value as \"{$ATTRIBUTE_VALUE}\",\n     t.feature_expression as \"{$FEATURE_EXPRESSION}\" , \n     t.coefficient as \"{$COEFFICIENT}\",\n     t.std_error as \"{$STD_ERROR}\",\n     t.test_statistic as \"{$TEST_STATISTIC}\",\n     t.p_value as \"{$P_VALUE}\",\n     t.vif as \"{$VIF}\",\n     t.std_coefficient as \"{$STD_COEFFICIENT}\",\n     t.lower_coeff_limit as \"{$LOWER_COEFF_LIMIT}\",\n     t.upper_coeff_limit as \"{$UPPER_COEFF_LIMIT}\",\n     t.exp_coefficient as \"{$EXP_COEFFICIENT}\",\n     t.exp_lower_coeff_limit as \"{$EXP_LOWER_COEFF_LIMIT}\",\n     t.exp_upper_coeff_limit as \"{$EXP_UPPER_COEFF_LIMIT}\"\n   FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_GLM('{$GET_MODEL_NAME}')) t" : "SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\",\n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\",\n     t.attribute_name as \"{$ATTRIBUTE_NAME}\",\n     t.attribute_subname as \"{$ATTRIBUTE_SUBNAME}\",\n     t.attribute_value as \"{$ATTRIBUTE_VALUE}\",\n     t.coefficient as \"{$COEFFICIENT}\",\n     t.std_error as \"{$STD_ERROR}\",\n     t.test_statistic as \"{$TEST_STATISTIC}\",\n     t.p_value as \"{$P_VALUE}\",\n     t.vif as \"{$VIF}\",\n     t.std_coefficient as \"{$STD_COEFFICIENT}\",\n     t.lower_coeff_limit as \"{$LOWER_COEFF_LIMIT}\",\n     t.upper_coeff_limit as \"{$UPPER_COEFF_LIMIT}\",\n     t.exp_coefficient as \"{$EXP_COEFFICIENT}\",\n     t.exp_lower_coeff_limit as \"{$EXP_LOWER_COEFF_LIMIT}\",\n     t.exp_upper_coeff_limit as \"{$EXP_UPPER_COEFF_LIMIT}\"\n   FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_GLM('{$GET_MODEL_NAME}')) t");
        return string;
    }
}

