/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.ParameterlessQuery;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public abstract class ExtractQuery
extends ParameterlessQuery<Object, OraclePreparedStatement> {
    protected static final String VARCHAR2 = "VARCHAR2";
    protected static final String NUMBER = "NUMBER";
    static final String MODEL_SCHEMA = "MODEL_SCHEMA";
    static final String MODEL_NAME = "MODEL_NAME";
    static final String PARTITION_NAME = "PARTITION_NAME";
    static final String PREDICTION = "PREDICTION";
    static final String RECORD_COUNT = "RECORD_COUNT";
    static final String CONFIDENCE = "CONFIDENCE";
    static final String SUPPORT = "SUPPORT";
    protected static final String ATTRIBUTE_NAME = "ATTRIBUTE_NAME";
    static final String ATTRIBUTE_SUBNAME = "ATTRIBUTE_SUBNAME";
    protected static final String TABLE_NAME = "TABLE_NAME";
    static final String ID = "ID";
    static final String VALUE = "VALUE";
    static final String OPERATOR = "OPERATOR";
    static final String CATEGORICAL_VAL = "CATEGORICAL_VAL";
    static final String CLASS = "CLASS";
    static final String ATTRIBUTE_VALUE = "ATTRIBUTE_VALUE";
    static final String TARGET_ATTRIBUTE_VALUE = "TARGET_ATTRIBUTE_VALUE";
    static final String COEFFICIENT = "COEFFICIENT";
    static final String CLOB = "CLOB";
    static final String CHAR = "CHAR";
    static final String XMLTYPE = "XMLTYPE";
    static final String BINARY_DOUBLE = "BINARY_DOUBLE";
    static final String CLUSTER_ID = "CLUSTER_ID";
    static final String CLUSTER_NAME = "CLUSTER_NAME";
    static final String FEATURE_ID = "FEATURE_ID";
    static final String MATRIX_TYPE = "MATRIX_TYPE";
    static final String PROJECTION = "PROJECTION";
    static final String VARIANCE = "VARIANCE";
    static final String CASE_ID = "CASE_ID";
    static final String TARGET_VALUE = "TARGET_VALUE";
    static final String HAT = "HAT";
    static final String ATTRIBUTE_STR_VALUE = "ATTRIBUTE_STR_VALUE";
    static final String ATTRIBUTE_NUM_VALUE = "ATTRIBUTE_NUM_VALUE";
    static final String PROFILE_ID = "PROFILE_ID";
    static final String FULL_SIMPLE_RULE = "FULL_SIMPLE_RULE";
    static final String COMPONENT_ID = "COMPONENT_ID";
    static final String ITEM_NAME = "ITEM_NAME";
    static final String ITEM_VALUE = "ITEM_VALUE";
    static final String ITEMSET_ID = "ITEMSET_ID";
    static final String NUMBER_OF_ITEMS = "NUMBER_OF_ITEMS";
    static final String REVCONFIDENCE = "REVCONFIDENCE";
    static final String ANTECEDENT_ITEMS = "ANTECEDENT_ITEMS";
    static final String CONSEQUENT_ITEMS = "CONSEQUENT_ITEMS";
    static final String LIFT = "LIFT";
    static final String LENGTH = "LENGTH";
    static final String ANTECEDENT_SUPPORT = "ANTECEDENT_SUPPORT";
    static final String CONSEQUENT_SUPPORT = "CONSEQUENT_SUPPORT";
    protected Enum outputType;
    protected String[][] outputColumns;
    protected StringBuilder _builder;
    protected Map<String, String> _replacements = new HashMap<String, String>();

    public ExtractQuery(Version version) {
        super(version, null);
    }

    protected Attributes convertOutputColumnList(List<OutputAttributeType> list) {
        Attributes attributes = new Attributes();
        List list2 = attributes.getAttribute();
        for (OutputAttributeType outputAttributeType : list) {
            list2.add(outputAttributeType.getAttributeType());
        }
        return attributes;
    }

    protected String addColumnAlias(String string, List<OutputAttributeType> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        list.forEach(outputAttributeType -> hashMap.put(outputAttributeType.getName(), outputAttributeType.getName()));
        string = StringUtils.getReplacedString(string, hashMap);
        return string;
    }

    protected void addColumnAliasReplacements(List<OutputAttributeType> list) {
        list.forEach(outputAttributeType -> this._replacements.put(outputAttributeType.getName(), outputAttributeType.getName()));
    }

    protected String getAliasName(OutputAttributeType outputAttributeType, List<AttributeType> list) {
        String string = outputAttributeType.getName();
        for (AttributeType attributeType : list) {
            if (!outputAttributeType.getName().equals(attributeType.getName())) continue;
            if (attributeType.getAlias() == null || attributeType.getAlias().length() <= 0) break;
            string = attributeType.getAlias();
            break;
        }
        return string;
    }

    protected boolean containsColumn(AttributeType attributeType, List<OutputAttributeType> list) {
        boolean bl = false;
        for (OutputAttributeType outputAttributeType : list) {
            if (attributeType.getName().compareTo(outputAttributeType.getName()) != 0 || attributeType.getDataType().compareTo(outputAttributeType.getDataType()) != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean validateOutputColumns(List<OutputAttributeType> list, List<AttributeType> list2) {
        boolean bl = true;
        for (AttributeType attributeType : list2) {
            if (this.containsColumn(attributeType, list)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void generateCollection(String[][] stringArray, List<OutputAttributeType> list) {
        for (int i = 0; i < stringArray.length; ++i) {
            OutputAttributeType outputAttributeType = new OutputAttributeType(stringArray[i][0], stringArray[i][1]);
            list.add(outputAttributeType);
        }
    }

    public List<OutputAttributeType> getOutputColumnList() {
        ArrayList<OutputAttributeType> arrayList = new ArrayList<OutputAttributeType>();
        if (this.outputType == null) {
            return arrayList;
        }
        this.generateCollection(this.outputColumns, arrayList);
        return arrayList;
    }

    protected abstract void initializeColumns();

    protected abstract String getSQLTemplate();
}

