/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.ar.ARNodeSettings;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class AssociationRulesQuery
extends ModelDetailsQuery {
    ARNodeSettings _nodeSettings;

    public AssociationRulesQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, ARNodeSettings aRNodeSettings, boolean bl) {
        super(version, modelDetailType, list, map, bl);
        assert (aRNodeSettings != null);
        this._nodeSettings = aRNodeSettings;
    }

    public AssociationRulesQuery(Version version, ModelDetailType modelDetailType, ARNodeSettings aRNodeSettings) {
        super(version, modelDetailType);
        assert (aRNodeSettings != null);
        this._nodeSettings = aRNodeSettings;
    }

    @Override
    protected void initializeColumns() {
        this.outputColumns = DbVersionHelper.isDB122Up(this.dbVersion) ? new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"PARTITION_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"ANTECEDENT_ITEMS", "VARCHAR2"}, {"CONSEQUENT_ITEMS", "VARCHAR2"}, {"SUPPORT", "NUMBER"}, {"CONFIDENCE", "NUMBER"}, {"REVCONFIDENCE", "NUMBER"}, {"LIFT", "NUMBER"}, {"ANTECEDENT_SUPPORT", "NUMBER"}, {"CONSEQUENT_SUPPORT", "NUMBER"}, {"LENGTH", "NUMBER"}} : new String[][]{{"MODEL_SCHEMA", "VARCHAR2"}, {"MODEL_NAME", "VARCHAR2"}, {"ID", "NUMBER"}, {"ANTECEDENT_ITEMS", "VARCHAR2"}, {"CONSEQUENT_ITEMS", "VARCHAR2"}, {"SUPPORT", "NUMBER"}, {"CONFIDENCE", "NUMBER"}, {"LIFT", "NUMBER"}, {"ANTECEDENT_SUPPORT", "NUMBER"}, {"CONSEQUENT_SUPPORT", "NUMBER"}, {"LENGTH", "NUMBER"}};
    }

    @Override
    protected String getSQLTemplate() {
        String string = null;
        string = DbVersionHelper.isDB122Up(this.dbVersion) ? "\n     SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\", \n     PARTITION_NAME as \"{$PARTITION_NAME}\", \n     RULE_ID as \"{$ID}\", \n     {$SPECIFIC_ANTECEDENT_ITEMS} as \"{$ANTECEDENT_ITEMS}\",\n     {$SPECIFIC_CONSEQUENT_ITEM} as \"{$CONSEQUENT_ITEMS}\",\n     RULE_SUPPORT AS \"{$SUPPORT}\",\n     RULE_CONFIDENCE AS \"{$CONFIDENCE}\",\n     RULE_REVCONFIDENCE AS \"{$REVCONFIDENCE}\",\n     RULE_LIFT AS \"{$LIFT}\",\n     ANTECEDENT_SUPPORT AS \"{$ANTECEDENT_SUPPORT}\",\n     CONSEQUENT_SUPPORT AS {$CONSEQUENT_SUPPORT},\n     NUMBER_OF_ITEMS - 1 AS {$LENGTH}\n     FROM {$MODEL_SCHEMA_VALUE}.DM$VR{$MODEL_NAME_VALUE}" : "\n     SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(30)) as \"{$MODEL_NAME}\", \n     AR.rule_id as \"{$ID}\", \n    dbms_xmlgen.CONVERT(REPLACE(REPLACE(REPLACE(EXTRACT(XMLELEMENT(\"R\", XMLAGG( XMLELEMENT(\"V\", NVL2( ant_pred.attribute_subname, ant_pred.attribute_name || '.' || ant_pred.attribute_subname, ant_pred.attribute_name) || ' ' || ant_pred.conditional_operator || ' '\n         ||ant_pred.attribute_str_value\n         ||ant_pred.attribute_num_value))), '/R/V').getstringval(), '</V><V>',', '),'<V>', ''),'</V>',''), 1) AS {$ANTECEDENT_ITEMS},\n     dbms_xmlgen.CONVERT(MAX(NVL2( cons_pred.attribute_subname, cons_pred.attribute_name || '.' || cons_pred.attribute_subname, cons_pred.attribute_name) || ' ' || cons_pred.conditional_operator || ' '\n         ||ant_pred.attribute_str_value\n         ||ant_pred.attribute_num_value), 1) {$CONSEQUENT_ITEMS},\n     AVG(ar.rule_support) AS {$SUPPORT},\n     AVG(ar.rule_confidence) AS {$CONFIDENCE},\n     AVG(ar.rule_lift) AS {$LIFT},\n     AVG(ar.antecedent_support) AS {$ANTECEDENT_SUPPORT},\n     AVG(ar.consequent_support) AS {$CONSEQUENT_SUPPORT},\n     AVG(ar.number_of_items) AS {$LENGTH}\n     FROM TABLE(dbms_data_mining.get_association_rules('{$GET_MODEL_NAME}')) AR, \n     TABLE(AR.antecedent) ant_pred ,  TABLE(AR.consequent) cons_pred\n     GROUP BY AR.rule_id";
        return string;
    }

    @Override
    protected Map<String, String> getSpecificColumns(MiningAlgorithmType miningAlgorithmType) {
        HashMap<String, String> hashMap;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            hashMap = new HashMap<String, String>();
            String string = this._nodeSettings.getItemID();
            if (StringUtils.isNotEmpty(string)) {
                switch (this._nodeSettings.getItemValueType()) {
                    case NOT_SET: {
                        hashMap.put("SPECIFIC_ANTECEDENT_ITEMS", "CAST(XMLQUERY('string-join(//item/string-join((\"" + string + "\", item_name),\".\") , \", \")' PASSING ANTECEDENT RETURNING CONTENT) AS VARCHAR2(4000))");
                        hashMap.put("SPECIFIC_CONSEQUENT_ITEM", "('" + string + "' || '.' || CONSEQUENT_NAME)");
                        break;
                    }
                    case CATEGORICAL: 
                    case NUMERICAL: {
                        hashMap.put("SPECIFIC_ANTECEDENT_ITEMS", "CAST(XMLQUERY('string-join(//item/string-join((string-join((\"" + string + "\", item_name),\".\") , item_value), \" =  \"), \", \")' PASSING ANTECEDENT RETURNING CONTENT) AS VARCHAR2(4000))");
                        hashMap.put("SPECIFIC_CONSEQUENT_ITEM", "('" + string + "' || '.' || CONSEQUENT_NAME || ' =  ' || CONSEQUENT_VALUE)");
                    }
                }
            } else {
                switch (this._nodeSettings.getItemValueType()) {
                    case NOT_SET: {
                        hashMap.put("SPECIFIC_ANTECEDENT_ITEMS", "CAST(XMLQUERY('string-join(//item/string-join((string-join((\"" + this._nodeSettings.getItemID() + "\", item_name),\".\"), item_subname), \".\"), \", \")' PASSING ANTECEDENT RETURNING CONTENT) AS VARCHAR2(4000))");
                        hashMap.put("SPECIFIC_CONSEQUENT_ITEM", "CONSEQUENT_NAME || '.' || CONSEQUENT_SUBNAME");
                        break;
                    }
                    case CATEGORICAL: 
                    case NUMERICAL: {
                        hashMap.put("SPECIFIC_ANTECEDENT_ITEMS", "CAST(XMLQUERY('string-join(//item/string-join((string-join((string-join((\"" + this._nodeSettings.getItemID() + "\", item_name),\".\"), item_subname), \".\"), item_value), \" =  \"), \", \")' PASSING ANTECEDENT RETURNING CONTENT) AS VARCHAR2(4000))");
                        hashMap.put("SPECIFIC_CONSEQUENT_ITEM", "(CONSEQUENT_NAME || '.' || CONSEQUENT_SUBNAME || ' =  ' || CONSEQUENT_VALUE)");
                    }
                }
            }
        } else {
            return Collections.emptyMap();
        }
        return hashMap;
    }
}

