/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.md;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.model.ar.ARNodeSettings;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAlgorithmType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class AssociationRulesAggregatesQuery
extends ModelDetailsQuery {
    private static final int DEFAULT_COLUMN_NO = 13;
    private static final String ANT_ = "ANT_";
    private static final String CON_ = "CON_";
    private static final String RULE_ = "RULE_";
    ARNodeSettings _nodeSettings;

    public AssociationRulesAggregatesQuery(Version version, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, ARNodeSettings aRNodeSettings, boolean bl) {
        super(version, modelDetailType, list, map, bl, false);
        assert (aRNodeSettings != null);
        this._nodeSettings = aRNodeSettings;
        this.initializeColumns();
    }

    public AssociationRulesAggregatesQuery(Version version, ModelDetailType modelDetailType, ARNodeSettings aRNodeSettings) {
        super(version, modelDetailType, false);
        assert (aRNodeSettings != null);
        this._nodeSettings = aRNodeSettings;
        this.initializeColumns();
    }

    @Override
    protected void initializeColumns() {
        List<String> list = this._nodeSettings.getAggregates();
        this.outputColumns = new String[13 + list.size() * 4][2];
        this.outputColumns[0] = new String[]{"MODEL_SCHEMA", "VARCHAR2"};
        this.outputColumns[1] = new String[]{"MODEL_NAME", "VARCHAR2"};
        this.outputColumns[2] = new String[]{"PARTITION_NAME", "VARCHAR2"};
        this.outputColumns[3] = new String[]{"ID", "NUMBER"};
        this.outputColumns[4] = new String[]{"ANTECEDENT_ITEMS", "VARCHAR2"};
        this.outputColumns[5] = new String[]{"CONSEQUENT_ITEMS", "VARCHAR2"};
        this.outputColumns[6] = new String[]{"SUPPORT", "NUMBER"};
        this.outputColumns[7] = new String[]{"CONFIDENCE", "NUMBER"};
        this.outputColumns[8] = new String[]{"REVCONFIDENCE", "NUMBER"};
        this.outputColumns[9] = new String[]{"LIFT", "NUMBER"};
        this.outputColumns[10] = new String[]{"ANTECEDENT_SUPPORT", "NUMBER"};
        this.outputColumns[11] = new String[]{"CONSEQUENT_SUPPORT", "NUMBER"};
        this.outputColumns[12] = new String[]{"LENGTH", "NUMBER"};
        int n = 13;
        for (String string : list) {
            List<String> list2 = this.aggregateColumNames(string);
            for (String string2 : list2) {
                this.outputColumns[n++] = new String[]{string2, "NUMBER"};
            }
        }
    }

    @Override
    protected String getSQLTemplate() {
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            this._builder = new StringBuilder("\n     SELECT CAST('{$MODEL_SCHEMA_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_SCHEMA}\", \n     CAST('{$MODEL_NAME_VALUE}' AS VARCHAR2(128)) as \"{$MODEL_NAME}\", \n     PARTITION_NAME as \"{$PARTITION_NAME}\", \n     RULE_ID as \"{$ID}\", \n     {$SPECIFIC_ANTECEDENT_ITEMS} as \"{$ANTECEDENT_ITEMS}\",\n     {$SPECIFIC_CONSEQUENT_ITEM} as \"{$CONSEQUENT_ITEMS}\",\n     RULE_SUPPORT AS \"{$SUPPORT}\",\n     RULE_CONFIDENCE AS \"{$CONFIDENCE}\",\n     RULE_REVCONFIDENCE AS \"{$REVCONFIDENCE}\",\n     RULE_LIFT AS \"{$LIFT}\",\n     ANTECEDENT_SUPPORT AS \"{$ANTECEDENT_SUPPORT}\",\n     CONSEQUENT_SUPPORT AS \"{$CONSEQUENT_SUPPORT}\",\n     NUMBER_OF_ITEMS - 1 AS \"{$LENGTH}\",\n");
            List<String> list = this._nodeSettings.getAggregates();
            for (String string : list) {
                for (String string2 : this.aggregateColumNames(string)) {
                    this._builder.append(String.format("     %s AS \"{$%s}\",\n", string2, string2));
                }
            }
            this._builder = new StringBuilder(this._builder.substring(0, this._builder.length() - 2));
            this._builder.append("\n     FROM {$MODEL_SCHEMA_VALUE}.DM$VR{$MODEL_NAME_VALUE}");
            return this._builder.toString();
        }
        return "";
    }

    @Override
    protected Map<String, String> getSpecificColumns(MiningAlgorithmType miningAlgorithmType) {
        HashMap<String, String> hashMap;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            hashMap = new HashMap<String, String>();
            String string = this._nodeSettings.getItemID();
            if (StringUtils.isNotEmpty(string)) {
                switch (this._nodeSettings.getItemValueType()) {
                    case NOT_SET: {
                        hashMap.put("SPECIFIC_ANTECEDENT_ITEMS", "CAST(XMLQUERY('string-join(//item/string-join((\"" + string + "\", item_name),\".\") , \", \")' PASSING ANTECEDENT RETURNING CONTENT) AS VARCHAR2(4000))");
                        hashMap.put("SPECIFIC_CONSEQUENT_ITEM", "('" + string + "' || '.' || CONSEQUENT_NAME)");
                        break;
                    }
                    case CATEGORICAL: 
                    case NUMERICAL: {
                        hashMap.put("SPECIFIC_ANTECEDENT_ITEMS", "CAST(XMLQUERY('string-join(//item/string-join((string-join((\"" + string + "\", item_name),\".\") , item_value), \" =  \"), \", \")' PASSING ANTECEDENT RETURNING CONTENT) AS VARCHAR2(4000))");
                        hashMap.put("SPECIFIC_CONSEQUENT_ITEM", "('" + string + "' || '.' || CONSEQUENT_NAME || ' =  ' || CONSEQUENT_VALUE)");
                    }
                }
            } else {
                switch (this._nodeSettings.getItemValueType()) {
                    case NOT_SET: {
                        hashMap.put("SPECIFIC_ANTECEDENT_ITEMS", "CAST(XMLQUERY('string-join(//item/string-join((string-join((\"" + this._nodeSettings.getItemID() + "\", item_name),\".\"), item_subname), \".\"), \", \")' PASSING ANTECEDENT RETURNING CONTENT) AS VARCHAR2(4000))");
                        hashMap.put("SPECIFIC_CONSEQUENT_ITEM", "CONSEQUENT_NAME || '.' || CONSEQUENT_SUBNAME");
                        break;
                    }
                    case CATEGORICAL: 
                    case NUMERICAL: {
                        hashMap.put("SPECIFIC_ANTECEDENT_ITEMS", "CAST(XMLQUERY('string-join(//item/string-join((string-join((string-join((\"" + this._nodeSettings.getItemID() + "\", item_name),\".\"), item_subname), \".\"), item_value), \" =  \"), \", \")' PASSING ANTECEDENT RETURNING CONTENT) AS VARCHAR2(4000))");
                        hashMap.put("SPECIFIC_CONSEQUENT_ITEM", "(CONSEQUENT_NAME || '.' || CONSEQUENT_SUBNAME || ' =  ' || CONSEQUENT_VALUE)");
                    }
                }
            }
        } else {
            return Collections.emptyMap();
        }
        return hashMap;
    }

    private List<String> aggregateColumNames(String string) {
        if (StringUtils.isEmpty(string.trim())) {
            return Collections.emptyList();
        }
        String string2 = string.toUpperCase();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%s%s%s", ANT_, RULE_, string2));
        arrayList.add(String.format("%s%s%s", CON_, RULE_, string2));
        arrayList.add(String.format("%s%s", ANT_, string2));
        arrayList.add(String.format("%s%s", CON_, string2));
        return arrayList;
    }
}

