/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.pca;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.ISqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.tuple.SqlTuple3Mapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.queries.Tuple3;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetScreePlotDataQuery
extends SqlBaseModelQuery<Tuple3<String, Double, Double>, OraclePreparedStatement> {
    private ISqlQuery<OraclePreparedStatement> query;

    public GetScreePlotDataQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlTuple3Mapper<String, Double, Double>(String.class, Double.class, Double.class), modelDescriptor);
        this.query = DbVersionHelper.isDB122Up(this.dbVersion) ? new DB122Query() : new OriginalQuery();
    }

    @Override
    protected String getSQLCommand() {
        return this.query.getSQLCommand();
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        this.query.setParameters(oraclePreparedStatement);
    }

    private class DB122Query
    implements ISqlQuery<OraclePreparedStatement> {
        private DB122Query() {
        }

        @Override
        public String getSQLCommand() {
            SqlBuilder sqlBuilder = new SqlBuilder().select("FEATURE_NAME", "VARIANCE", "PCT_CUM_VARIANCE").from(GetScreePlotDataQuery.this.getViewName("DM$VE")).where(Conditional.equals("PARTITION_NAME", GetScreePlotDataQuery.this.getPartitionId()));
            return sqlBuilder.toString();
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            SqlUtils.setStringAtName(oraclePreparedStatement, "PARTITION_NAME", GetScreePlotDataQuery.this.getPartitionId());
        }
    }

    private class OriginalQuery
    implements ISqlQuery<OraclePreparedStatement> {
        private OriginalQuery() {
        }

        @Override
        public String getSQLCommand() {
            return "SELECT MAPPED_FEATURE_ID, VARIANCE, PCT_CUM_VARIANCE \nFROM TABLE(dbms_data_mining.get_model_details_svd(:model)) \nWHERE MATRIX_TYPE = 'S'";
        }

        @Override
        public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
            oraclePreparedStatement.setStringAtName("model", GetScreePlotDataQuery.this.getQualifiedName());
        }
    }
}

