/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.esa;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlMapMapperEntry;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlMapSingleRowMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.SqlBaseModelQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.StringUtils;
import oracle.javatools.util.Version;
import oracle.jdbc.internal.OraclePreparedStatement;

public class ESACoefStatsQuery
extends SqlBaseModelQuery<Map<String, Object>, OraclePreparedStatement> {
    private static final SqlMapMapperEntry[] entries = new SqlMapMapperEntry[]{new SqlMapMapperEntry("TOTAL_COEFFICIENTS", "TOTAL_COEFFICIENTS", Integer.class), new SqlMapMapperEntry("MAXIMUM_ABS_COEFFICIENT_VALUE", "MAXIMUM_ABS_COEFFICIENT_VALUE", Double.class)};
    private List<String> _featureIds = new ArrayList<String>();

    public ESACoefStatsQuery(Version version, ModelDescriptor modelDescriptor) {
        super(version, new SqlMapSingleRowMapper(entries), modelDescriptor);
    }

    public ESACoefStatsQuery setFeatureId(String string) {
        if (StringUtils.isEmpty(string)) {
            return this;
        }
        this._featureIds.add(string);
        return this;
    }

    public ESACoefStatsQuery setFeatureIds(List<String> list) {
        if (list == null) {
            return this;
        }
        this._featureIds.addAll(list);
        return this;
    }

    @Override
    public String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select("COUNT(*) TOTAL_COEFFICIENTS", "MAX(ABS(COEFFICIENT)) MAXIMUM_ABS_COEFFICIENT_VALUE").from(this.getViewName("DM$VA")).where(Conditional.equalsOrNull("PARTITION_NAME", this.getPartitionId()), Conditional.in("FEATURE_ID", this._featureIds));
        String string = sqlBuilder.toString();
        return string;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, "PARTITION_NAME", this.getPartitionId());
        SqlUtils.setStringParameterList((oracle.jdbc.OraclePreparedStatement)oraclePreparedStatement, "FEATURE_ID", this._featureIds);
    }
}

