/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.fe.common;

import oracle.dmt.dataminer.core.dal.sql.queries.StringSearchQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitSemanticAnalysisModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PCAModelType;
import oracle.dmt.dataminer.workflow.xmlschema.SVDModelType;
import oracle.javatools.util.Version;

public class SearchFeatureIdQuery
extends StringSearchQuery {
    private Class<? extends ModelType> type;

    public SearchFeatureIdQuery(Version version, Class<? extends ModelType> clazz, ModelDescriptor modelDescriptor) {
        super(version, modelDescriptor);
        assert (clazz != null) : "Model Type Cannot be Null";
        this.type = clazz;
    }

    @Override
    protected String getSource() {
        assert (ExplicitSemanticAnalysisModelType.class.equals(this.type) || PCAModelType.class.equals(this.type) || SVDModelType.class.equals(this.type) || NonNegativeMatrixFactorModelType.class.equals(this.type)) : "Invalid Model Type";
        String string = null;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            if (ExplicitSemanticAnalysisModelType.class.equals(this.type)) {
                string = "{$SCHEMA}.DM$VA{$MODEL_NAME}";
            } else if (PCAModelType.class.equals(this.type) || SVDModelType.class.equals(this.type)) {
                string = "{$SCHEMA}.DM$VV{$MODEL_NAME}";
            } else if (NonNegativeMatrixFactorModelType.class.equals(this.type)) {
                string = "{$SCHEMA}.DM$VE{$MODEL_NAME}";
            }
        } else if (PCAModelType.class.equals(this.type) || SVDModelType.class.equals(this.type)) {
            string = "(\n    SELECT MAPPED_FEATURE_ID\n    FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_SVD('{$SCHEMA}.{$MODEL_NAME}'))\n)\n";
        } else if (NonNegativeMatrixFactorModelType.class.equals(this.type)) {
            string = "(\n    SELECT MAPPED_FEATURE_ID\n    FROM TABLE(dbms_data_mining.GET_MODEL_DETAILS_NMF('{$SCHEMA}.{$MODEL_NAME}'))\n)\n";
        }
        return string;
    }

    @Override
    protected String getColumn() {
        String string = null;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            if (ExplicitSemanticAnalysisModelType.class.equals(this.type)) {
                string = "FEATURE_ID";
            } else if (PCAModelType.class.equals(this.type) || SVDModelType.class.equals(this.type) || NonNegativeMatrixFactorModelType.class.equals(this.type)) {
                string = "FEATURE_NAME";
            }
        } else {
            string = "MAPPED_FEATURE_ID";
        }
        return string;
    }

    @Override
    protected String getColumnExpression() {
        String string = null;
        if (DbVersionHelper.isDB122Up(this.dbVersion)) {
            if (ExplicitSemanticAnalysisModelType.class.equals(this.type)) {
                string = "UPPER(FEATURE_ID)";
            } else if (PCAModelType.class.equals(this.type) || SVDModelType.class.equals(this.type) || NonNegativeMatrixFactorModelType.class.equals(this.type)) {
                string = "UPPER(FEATURE_NAME)";
            }
        } else {
            string = "UPPER(MAPPED_FEATURE_ID)";
        }
        return string;
    }
}

