/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.common.build;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.common.SqlDefaultMapper;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.javatools.util.Version;
import oracle.jdbc.OraclePreparedStatement;

public class GetModelGeneralDescriptionsQuery
extends SqlQuery<ModelGeneralDescription, OraclePreparedStatement> {
    private static final String OWNER = "OWNER";
    private static final String ALGORITHM = "ALGORITHM";
    private static final String MODEL_NAME = "MODEL_NAME";
    private static final String MINING_FUNCTION = "MINING_FUNCTION";
    private String _owner;
    private String _algorithm;
    private String _miningFunction;
    private boolean _ownerAccountOnly;
    private List<String> _modelNames = Collections.emptyList();

    public GetModelGeneralDescriptionsQuery(Version version) {
        super(version, new SqlDefaultMapper<ModelGeneralDescription>(ModelGeneralDescription.class));
    }

    @Override
    public String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select(new String[0]).from(this._ownerAccountOnly ? "USER_MINING_MODELS" : "ALL_MINING_MODELS").where(Conditional.equals(ALGORITHM, this._algorithm), Conditional.equals(MINING_FUNCTION, this._miningFunction), Conditional.equals(OWNER, this._owner), Conditional.in(MODEL_NAME, this._modelNames));
        return sqlBuilder.toString();
    }

    public GetModelGeneralDescriptionsQuery setOwner(String string) {
        this._owner = string;
        return this;
    }

    public GetModelGeneralDescriptionsQuery setAlgorithm(String string) {
        this._algorithm = string;
        return this;
    }

    public GetModelGeneralDescriptionsQuery setMiningFunction(String string) {
        this._miningFunction = string;
        return this;
    }

    public GetModelGeneralDescriptionsQuery setOwnerAccountOnly(boolean bl) {
        this._ownerAccountOnly = bl;
        return this;
    }

    public GetModelGeneralDescriptionsQuery setModelName(String string) {
        assert (string != null) : "Model name cannot be null";
        this._modelNames = new ArrayList<String>(1);
        this._modelNames.add(string);
        return this;
    }

    public GetModelGeneralDescriptionsQuery setModelNames(List<String> list) {
        assert (list != null) : "Model name list cannot be null";
        this._modelNames = list;
        return this;
    }

    @Override
    public void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        SqlUtils.setStringAtName(oraclePreparedStatement, ALGORITHM, this._algorithm);
        SqlUtils.setStringAtName(oraclePreparedStatement, MINING_FUNCTION, this._miningFunction);
        SqlUtils.setStringAtName(oraclePreparedStatement, OWNER, this._owner);
        SqlUtils.setStringParameterList(oraclePreparedStatement, MODEL_NAME, this._modelNames);
    }
}

